/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.rdf2dmn.json;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.analysis.semantics.type.DateTimeType;
import com.gs.dmn.feel.analysis.semantics.type.DateType;
import com.gs.dmn.feel.analysis.semantics.type.DurationType;
import com.gs.dmn.feel.analysis.semantics.type.FEELTypes;
import com.gs.dmn.feel.analysis.semantics.type.StringType;
import com.gs.dmn.feel.analysis.semantics.type.TimeType;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.dialect.SignavioDMNDialectDefinition;
import com.gs.dmn.signavio.rdf2dmn.RDFModel;
import com.gs.dmn.signavio.rdf2dmn.json.Context;
import com.gs.dmn.signavio.rdf2dmn.json.Visitor;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionTable;
import com.gs.dmn.signavio.rdf2dmn.json.decision.FreeTextExpression;
import com.gs.dmn.signavio.rdf2dmn.json.decision.LiteralExpression;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Any;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Arithmetic;
import com.gs.dmn.signavio.rdf2dmn.json.expression.ArithmeticNegation;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Comparison;
import com.gs.dmn.signavio.rdf2dmn.json.expression.DataAcceptance;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Disjunction;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Enumeration;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Expression;
import com.gs.dmn.signavio.rdf2dmn.json.expression.FeelContext;
import com.gs.dmn.signavio.rdf2dmn.json.expression.FunctionCall;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Hierarchy;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Interval;
import com.gs.dmn.signavio.rdf2dmn.json.expression.List;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Logical;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Negation;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Reference;
import com.gs.dmn.signavio.rdf2dmn.json.expression.SimpleLiteral;
import com.gs.dmn.signavio.rdf2dmn.json.expression.UnaryComparison;
import com.gs.dmn.signavio.rdf2dmn.json.expression.UnaryTestFunctionCall;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.lazy.NopLazyEvaluationDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ToDMNVisitor
implements Visitor {
    protected static final Map<String, String> TO_FEEL_OPERATOR = new HashMap<String, String>();
    private final RDFModel rdfModel;
    private final DMNDialectDefinition dialectDefinition = new SignavioDMNDialectDefinition();
    private final BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer;

    public ToDMNVisitor(RDFModel rdfModel, InputParameters inputParameters) {
        this.dmnTransformer = this.dialectDefinition.createBasicTransformer((DMNModelRepository)new SignavioDMNModelRepository(), (LazyEvaluationDetector)new NopLazyEvaluationDetector(), inputParameters);
        this.rdfModel = rdfModel;
    }

    @Override
    public String visit(List element, Context context) {
        String list = element.getValue().stream().map(ie -> ie.accept(this, context)).collect(Collectors.joining(", "));
        return String.format("[%s]", list);
    }

    @Override
    public String visit(SimpleLiteral element, Context context) {
        String typeName = element.getType();
        Type type = (Type)FEELTypes.FEEL_NAME_TO_FEEL_TYPE.get(typeName);
        if (StringType.STRING == type) {
            return String.format("%s", element.getValue());
        }
        if (DateType.DATE == type) {
            return String.format("date(%s)", element.getValue());
        }
        if (TimeType.TIME == type) {
            return String.format("time(%s)", element.getValue());
        }
        if (DateTimeType.DATE_AND_TIME == type) {
            return String.format("date and time(%s)", element.getValue());
        }
        if (DurationType.DAYS_AND_TIME_DURATION == type || DurationType.YEARS_AND_MONTHS_DURATION == type) {
            return String.format("duration(%s)", element.getValue());
        }
        return String.format("%s", element.getValue());
    }

    @Override
    public String visit(DecisionTable element, Context params) {
        throw new UnsupportedOperationException(String.format("%s not supported yet", element.getClass().getSimpleName()));
    }

    @Override
    public String visit(FreeTextExpression element, Context params) {
        throw new UnsupportedOperationException(String.format("%s not supported yet", element.getClass().getSimpleName()));
    }

    @Override
    public String visit(LiteralExpression element, Context params) {
        return element.getText().accept(this, params);
    }

    @Override
    public String visit(Logical element, Context params) {
        String leftOperandText = element.getLeftOperand().accept(this, params);
        String rightOperandText = element.getRightOperand().accept(this, params);
        String feelOperator = TO_FEEL_OPERATOR.get(element.getOperator());
        if (feelOperator == null) {
            throw new DMNRuntimeException(String.format("Cannot find FEEL operator for '%s'", element.getOperator()));
        }
        return String.format("(%s) %s (%s)", leftOperandText, feelOperator, rightOperandText);
    }

    @Override
    public String visit(Comparison element, Context params) {
        String leftOperandText = element.getLeftOperand().accept(this, params);
        String rightOperandText = element.getRightOperand().accept(this, params);
        String feelOperator = TO_FEEL_OPERATOR.get(element.getOperator());
        if (feelOperator == null) {
            throw new DMNRuntimeException(String.format("Cannot find FEEL operator for '%s'", element.getOperator()));
        }
        return String.format("(%s) %s (%s)", leftOperandText, feelOperator, rightOperandText);
    }

    @Override
    public String visit(Arithmetic element, Context params) {
        String leftOperandText = element.getLeftOperand().accept(this, params);
        String rightOperandText = element.getRightOperand().accept(this, params);
        String feelOperator = TO_FEEL_OPERATOR.get(element.getOperator());
        if (feelOperator == null) {
            throw new DMNRuntimeException(String.format("Cannot find FEEL operator for '%s'", element.getOperator()));
        }
        return String.format("(%s) %s (%s)", leftOperandText, feelOperator, rightOperandText);
    }

    @Override
    public String visit(ArithmeticNegation element, Context context) {
        Expression operand = element.getOperand();
        return String.format("- (%s)", operand.accept(this, context));
    }

    @Override
    public String visit(FunctionCall functionCall, Context context) {
        String functionId = functionCall.getFunctionId();
        java.util.List<Expression> parameters = functionCall.getParameters();
        String argList = parameters.stream().map(r -> r.accept(this, context)).collect(Collectors.joining(", "));
        return String.format("%s(%s)", functionId, argList);
    }

    @Override
    public String visit(Reference reference, Context context) {
        String shapeId = reference.getShapeId();
        java.util.List<String> pathElements = reference.getPathElements();
        Element description = this.rdfModel.findDescriptionById(shapeId);
        String root = this.dmnTransformer.nativeFriendlyVariableName(this.rdfModel.getName(description));
        if (pathElements == null || pathElements.isEmpty() || this.rdfModel.hasSingleOutput(shapeId)) {
            return String.format("%s", root);
        }
        String path = pathElements.stream().map(pe -> this.dmnTransformer.nativeFriendlyVariableName(this.rdfModel.pathName(description, (String)pe))).collect(Collectors.joining("."));
        return String.format("%s.%s", root, path);
    }

    @Override
    public String visit(Any element, Context context) {
        return "-";
    }

    @Override
    public String visit(Disjunction element, Context context) {
        return element.getValue().stream().map(ie -> ie.accept(this, context)).collect(Collectors.joining(", "));
    }

    @Override
    public String visit(Enumeration element, Context context) {
        return ((FeelContext)context).findEnumerator(element.getItemId());
    }

    @Override
    public String visit(Hierarchy element, Context context) {
        return "TODO";
    }

    @Override
    public String visit(Interval element, Context context) {
        String leftBrace = element.isOpenStart() ? "(" : "[";
        String rightBrace = element.isOpenEnd() ? ")" : "]";
        return String.format("%s%s..%s%s", leftBrace, element.getStart().accept(this, context), element.getEnd().accept(this, context), rightBrace);
    }

    @Override
    public String visit(Negation element, Context context) {
        Expression operand = element.getOperand();
        return String.format("not (%s)", operand.accept(this, context));
    }

    @Override
    public String visit(UnaryComparison element, Context context) {
        String rdfOperator = element.getOperator();
        String operator = TO_FEEL_OPERATOR.get(rdfOperator);
        if (operator == null) {
            throw new DMNRuntimeException("Cannot find FEEL operator for " + rdfOperator);
        }
        return String.format("%s %s", operator, element.getOperand().accept(this, context));
    }

    @Override
    public String visit(UnaryTestFunctionCall element, Context context) {
        java.util.List<Expression> parameters = element.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            Expression inputEntry = parameters.get(0);
            String args = parameters.stream().map(ie -> ie.accept(this, context)).collect(Collectors.joining(","));
            if (inputEntry instanceof Disjunction) {
                return String.format("%s(?, [%s])", element.getFunctionId(), args);
            }
            return String.format("%s(?, %s)", element.getFunctionId(), args);
        }
        return String.format("%s(?)", element.getFunctionId());
    }

    @Override
    public String visit(DataAcceptance dataAcceptance, Context context) {
        String functionId = dataAcceptance.getValue();
        return String.format("%s(?)", functionId);
    }

    static {
        TO_FEEL_OPERATOR.put("and", "and");
        TO_FEEL_OPERATOR.put("or", "or");
        TO_FEEL_OPERATOR.put("less", "<");
        TO_FEEL_OPERATOR.put("lessOrEqual", "<=");
        TO_FEEL_OPERATOR.put("greater", ">");
        TO_FEEL_OPERATOR.put("greaterOrEqual", ">=");
        TO_FEEL_OPERATOR.put("equal", "=");
        TO_FEEL_OPERATOR.put("add", "+");
        TO_FEEL_OPERATOR.put("subtract", "-");
        TO_FEEL_OPERATOR.put("multiply", "*");
        TO_FEEL_OPERATOR.put("divide", "/");
    }
}

