/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.rdf2dmn.json.expression;

import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.signavio.rdf2dmn.RDFModel;
import com.gs.dmn.signavio.rdf2dmn.json.Context;
import com.gs.dmn.signavio.rdf2dmn.json.EnumItem;
import com.gs.dmn.signavio.rdf2dmn.json.ItemDefinition;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionTable;
import com.gs.dmn.signavio.rdf2dmn.json.decision.InputClause;
import com.gs.dmn.signavio.rdf2dmn.json.decision.OutputClause;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Expression;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Reference;
import com.gs.dmn.signavio.rdf2dmn.json.relation.EnumerationProperty;
import com.gs.dmn.signavio.rdf2dmn.json.relation.Relation;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class FeelContext
extends Context {
    private final Element decision;
    private final DecisionTable decisionTable;
    private final int entryIndex;
    private final boolean isInput;
    private final RDFModel rdfModel;

    public FeelContext(Element decision, RDFModel rdfModel, DecisionTable decisionTable, int entryIndex, boolean isInput) {
        this.decision = decision;
        this.rdfModel = rdfModel;
        this.decisionTable = decisionTable;
        this.entryIndex = entryIndex;
        this.isInput = isInput;
    }

    public String findEnumerator(String enumeratorIndex) {
        return this.isInput ? this.findEnumeratorInInputClause(enumeratorIndex) : this.findEnumeratorInOutputClause(enumeratorIndex);
    }

    private String findEnumeratorInInputClause(String enumeratorIndex) {
        InputClause clause = this.decisionTable.getInputClauses().get(this.entryIndex);
        Expression expression = clause.getExpression();
        try {
            if (expression instanceof Reference) {
                String resourceId = ((Reference)expression).getShapeId();
                Element resource = this.rdfModel.findDescriptionById(resourceId);
                String enumItemsString = this.rdfModel.getEnumItems(resource);
                String relationsString = this.rdfModel.getRelations(resource);
                if (!StringUtils.isBlank((CharSequence)enumItemsString)) {
                    List<EnumItem> enumItemList = this.rdfModel.getEnumItemList(enumItemsString);
                    return this.findEnumItem(enumItemList, enumeratorIndex);
                }
                if (!StringUtils.isBlank((CharSequence)relationsString)) {
                    List<Relation> relationList = this.rdfModel.getRelationList(relationsString);
                    String relationIndex = ((Reference)expression).getPathElements().get(0);
                    return this.findEnumItem(relationList, relationIndex, enumeratorIndex);
                }
                throw new DMNRuntimeException(String.format("Cannot find enumerator at index '%s' in inputEntry '%s'", enumeratorIndex, expression.toString()));
            }
            throw new UnsupportedOperationException(expression.getClass().getSimpleName() + " not supported");
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot find enumerator at index '%s' in inputEntry '%s'", enumeratorIndex, expression.toString()), (Throwable)e);
        }
    }

    private String findEnumeratorInOutputClause(String enumeratorIndex) {
        OutputClause clause = this.decisionTable.getOutputClauses().get(this.entryIndex);
        ItemDefinition itemDefinition = clause.getItemDefinition();
        String itemDefinitionName = itemDefinition.getName();
        try {
            List<EnumItem> enumItemsList = itemDefinition.getEnumItems();
            return this.findEnumItem(enumItemsList, enumeratorIndex);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot find enumerator at index '%s' in itemDefinition '%s'", enumeratorIndex, itemDefinitionName), (Throwable)e);
        }
    }

    private String findEnumItem(List<EnumItem> enumItemsList, String enumeratorIndex) {
        List enumItems = enumItemsList.stream().filter(ei -> enumeratorIndex.equals(ei.getId())).collect(Collectors.toList());
        if (enumItems.size() == 1) {
            return String.format("\"%s\"", ((EnumItem)enumItems.get(0)).getTitle().trim());
        }
        throw new DMNRuntimeException(String.format("Cannot find enumerator at index '%s'", enumeratorIndex));
    }

    private String findEnumItem(List<Relation> relationList, String relationIndex, String enumeratorIndex) {
        Integer index = Integer.valueOf(relationIndex);
        for (Relation relation : relationList) {
            if (relation.getRelationId() != index.intValue()) continue;
            for (EnumItem enumItem : ((EnumerationProperty)relation.getValue()).getEnumItems()) {
                if (!enumItem.getId().equals(enumeratorIndex)) continue;
                return String.format("\"%s\"", enumItem.getTitle());
            }
        }
        throw new DMNRuntimeException(String.format("Cannot find enumerator at index '%s' in relation at index '%s'", enumeratorIndex, relationIndex));
    }
}

