/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.runtime;

import com.gs.dmn.context.DMNContext;
import com.gs.dmn.context.DMNContextKind;
import com.gs.dmn.context.environment.Environment;
import com.gs.dmn.context.environment.EnvironmentFactory;
import com.gs.dmn.context.environment.RuntimeEnvironment;
import com.gs.dmn.el.analysis.semantics.type.AnyType;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.analysis.semantics.environment.StandardEnvironmentFactory;
import com.gs.dmn.feel.analysis.semantics.type.BooleanType;
import com.gs.dmn.feel.analysis.semantics.type.BuiltinFunctionType;
import com.gs.dmn.feel.analysis.semantics.type.DateTimeType;
import com.gs.dmn.feel.analysis.semantics.type.DateType;
import com.gs.dmn.feel.analysis.semantics.type.ListType;
import com.gs.dmn.feel.analysis.semantics.type.NumberType;
import com.gs.dmn.feel.analysis.semantics.type.StringType;
import com.gs.dmn.feel.analysis.semantics.type.TemporalType;
import com.gs.dmn.feel.analysis.semantics.type.TimeType;
import com.gs.dmn.feel.analysis.syntax.ast.expression.function.FormalParameter;
import com.gs.dmn.runtime.function.BuiltinFunction;
import java.util.List;
import java.util.Map;

public class SignavioEnvironmentFactory
implements EnvironmentFactory {
    private static final EnvironmentFactory INSTANCE = new SignavioEnvironmentFactory();
    private static final DMNContext BUILT_IN_CONTEXT;

    public static EnvironmentFactory instance() {
        return INSTANCE;
    }

    public DMNContext getBuiltInContext() {
        return BUILT_IN_CONTEXT;
    }

    private static void addSignavioFunctions(Environment environment) {
        SignavioEnvironmentFactory.addDataAcceptanceFunctions(environment);
        SignavioEnvironmentFactory.addConversionFunctions(environment);
        SignavioEnvironmentFactory.addNumberFunctions(environment);
        SignavioEnvironmentFactory.addStringFunctions(environment);
        SignavioEnvironmentFactory.addBooleanFunctions(environment);
        SignavioEnvironmentFactory.addDateTimeFunctions(environment);
        SignavioEnvironmentFactory.addListFunctions(environment);
        SignavioEnvironmentFactory.addStatisticalFunctions(environment);
    }

    private static void addDataAcceptanceFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isDefined", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("arg", (Object)AnyType.ANY)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isUndefined", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("arg", (Object)AnyType.ANY)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isValid", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("arg", (Object)AnyType.ANY)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isInvalid", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("arg", (Object)AnyType.ANY)}));
    }

    private static void addConversionFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "date", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[]{new FormalParameter("from", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "date and time", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[]{new FormalParameter("from", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "time", new BuiltinFunctionType((Type)TimeType.TIME, new FormalParameter[]{new FormalParameter("from", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "string", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("from", (Object)AnyType.ANY)}));
    }

    private static void addNumberFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "abs", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "count", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "round", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER), new FormalParameter("digits", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "ceiling", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "floor", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "integer", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "modulo", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("dividend", (Object)NumberType.NUMBER), new FormalParameter("divisor", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "percent", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "power", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("base", (Object)NumberType.NUMBER), new FormalParameter("exponent", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "product", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "roundDown", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER), new FormalParameter("digits", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "roundUp", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("number", (Object)NumberType.NUMBER), new FormalParameter("digits", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "sum", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
    }

    private static void addStringFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "concat", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isAlpha", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isAlphanumeric", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isNumeric", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "isSpaces", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "len", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "lower", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "trim", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "upper", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "number", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING), new FormalParameter("default_value", (Object)NumberType.NUMBER, true, false)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "mid", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING), new FormalParameter("start", (Object)NumberType.NUMBER), new FormalParameter("num_chars", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "left", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING), new FormalParameter("num_chars", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "right", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING), new FormalParameter("num_chars", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "text", new BuiltinFunctionType((Type)StringType.STRING, new FormalParameter[]{new FormalParameter("num", (Object)NumberType.NUMBER), new FormalParameter("format_text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "textOccurrences", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("find_text", (Object)StringType.STRING), new FormalParameter("within_text", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "contains", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("text", (Object)StringType.STRING), new FormalParameter("substring", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "startsWith", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("string", (Object)StringType.STRING), new FormalParameter("prefix", (Object)StringType.STRING)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "endsWith", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("string", (Object)StringType.STRING), new FormalParameter("suffix", (Object)StringType.STRING)}));
    }

    private static void addBooleanFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "not", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("negand", (Object)BooleanType.BOOLEAN)}));
    }

    private static void addDateTimeFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "day", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "day", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayAdd", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE), new FormalParameter("days_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayAdd", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("days_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dayDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "date", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[]{new FormalParameter("year", (Object)NumberType.NUMBER), new FormalParameter("month", (Object)NumberType.NUMBER), new FormalParameter("day", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "dateTime", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[]{new FormalParameter("day", (Object)NumberType.NUMBER), new FormalParameter("month", (Object)NumberType.NUMBER), new FormalParameter("year", (Object)NumberType.NUMBER), new FormalParameter("hour", (Object)NumberType.NUMBER), new FormalParameter("minute", (Object)NumberType.NUMBER), new FormalParameter("second", (Object)NumberType.NUMBER), new FormalParameter("hourOffset", (Object)NumberType.NUMBER, true, false)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "hour", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)TimeType.TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "hour", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "hourDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)TemporalType.TEMPORAL), new FormalParameter("datetime2", (Object)TemporalType.TEMPORAL)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "minute", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)TimeType.TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "minute", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "minutesDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)TemporalType.TEMPORAL), new FormalParameter("datetime2", (Object)TemporalType.TEMPORAL)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "month", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "month", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthAdd", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE), new FormalParameter("months_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthAdd", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("months_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "monthDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "now", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[0]));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "today", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[0]));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "weekday", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "weekday", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "year", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "year", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearAdd", new BuiltinFunctionType((Type)DateType.DATE, new FormalParameter[]{new FormalParameter("datetime", (Object)DateType.DATE), new FormalParameter("years_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearAdd", new BuiltinFunctionType((Type)DateTimeType.DATE_AND_TIME, new FormalParameter[]{new FormalParameter("datetime", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("years_to_add", (Object)NumberType.NUMBER)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateType.DATE), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateType.DATE)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "yearDiff", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("datetime1", (Object)DateTimeType.DATE_AND_TIME), new FormalParameter("datetime2", (Object)DateTimeType.DATE_AND_TIME)}));
    }

    private static void addListFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "append", StandardEnvironmentFactory.makeSignavioAppendBuiltinFunctionType((Type)ListType.ANY_LIST, (Type)AnyType.ANY));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "appendAll", StandardEnvironmentFactory.makeSignavioAppendAllBuiltinFunctionType((Type)ListType.ANY_LIST));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "remove", StandardEnvironmentFactory.makeSignavioRemoveBuiltinFunctionType((Type)ListType.ANY_LIST, (Type)AnyType.ANY));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "removeAll", StandardEnvironmentFactory.makeSignavioRemoveAllBuiltinFunctionType((Type)ListType.ANY_LIST));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "zip", StandardEnvironmentFactory.makeSignavioZipBuiltinFunctionType((Type)ListType.ANY_LIST, (Type)ListType.ANY_LIST, (Type)ListType.ANY_LIST));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "notContainsAny", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("list1", (Object)ListType.ANY_LIST), new FormalParameter("list2", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "containsOnly", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("list1", (Object)ListType.ANY_LIST), new FormalParameter("list2", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "areElementsOf", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("list1", (Object)ListType.ANY_LIST), new FormalParameter("list2", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "elementOf", new BuiltinFunctionType((Type)BooleanType.BOOLEAN, new FormalParameter[]{new FormalParameter("list1", (Object)AnyType.ANY), new FormalParameter("list2", (Object)ListType.ANY_LIST)}));
    }

    private static void addStatisticalFunctions(Environment environment) {
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "avg", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "max", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "median", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "min", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
        SignavioEnvironmentFactory.addFunctionDeclaration(environment, "mode", new BuiltinFunctionType((Type)NumberType.NUMBER, new FormalParameter[]{new FormalParameter("list", (Object)ListType.ANY_LIST)}));
    }

    private static void addFunctionDeclaration(Environment environment, String name, BuiltinFunctionType functionType) {
        environment.addDeclaration(INSTANCE.makeVariableDeclaration(name, (Type)functionType));
    }

    static {
        Environment environment = INSTANCE.emptyEnvironment();
        RuntimeEnvironment runtimeEnvironment = RuntimeEnvironment.of();
        SignavioEnvironmentFactory.addSignavioFunctions(environment);
        for (Map.Entry entry : environment.getVariablesTable().entrySet()) {
            runtimeEnvironment.bind((String)entry.getKey(), (Object)BuiltinFunction.of((List)((List)entry.getValue())));
        }
        BUILT_IN_CONTEXT = DMNContext.of(null, (DMNContextKind)DMNContextKind.BUILT_IN, null, (Environment)environment, (RuntimeEnvironment)runtimeEnvironment);
    }
}

