/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.runtime.interpreter;

import com.gs.dmn.DRGElementReference;
import com.gs.dmn.NameUtils;
import com.gs.dmn.ast.TBinding;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInvocable;
import com.gs.dmn.ast.TInvocation;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.interpreter.TypeConverter;
import com.gs.dmn.feel.lib.FEELLib;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.interpreter.AbstractDMNInterpreter;
import com.gs.dmn.runtime.interpreter.Result;
import com.gs.dmn.runtime.listener.DRGElement;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.extension.Aggregator;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.feel.lib.SignavioLib;
import com.gs.dmn.signavio.transformation.basic.BasicSignavioDMNToJavaTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class SignavioDMNInterpreter<NUMBER, DATE, TIME, DATE_TIME, DURATION>
extends AbstractDMNInterpreter<NUMBER, DATE, TIME, DATE_TIME, DURATION> {
    private final SignavioDMNModelRepository dmnModelRepository = (SignavioDMNModelRepository)this.getBasicDMNTransformer().getDMNModelRepository();

    public SignavioDMNInterpreter(BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer, FEELLib<NUMBER, DATE, TIME, DATE_TIME, DURATION> feelLib, TypeConverter typeConverter) {
        super(dmnTransformer, feelLib, typeConverter);
    }

    public SignavioLib<NUMBER, DATE, TIME, DATE_TIME, DURATION> getFeelLib() {
        return (SignavioLib)this.feelLib;
    }

    protected Result evaluateExpression(TDRGElement element, TExpression expression, DMNContext context, DRGElement elementAnnotation) {
        if (element instanceof TDecision && this.dmnModelRepository.isMultiInstanceDecision(element)) {
            return this.evaluateMultipleInstanceDecision((TDecision)element, context, elementAnnotation);
        }
        return super.evaluateExpression(element, expression, context, elementAnnotation);
    }

    private Result evaluateMultipleInstanceDecision(TDecision decision, DMNContext parentContext, DRGElement elementAnnotation) {
        Object output;
        MultiInstanceDecisionLogic multiInstanceDecision = ((BasicSignavioDMNToJavaTransformer)this.getBasicDMNTransformer()).multiInstanceDecisionLogic(decision);
        String iterationExpression = multiInstanceDecision.getIterationExpression();
        TDRGElement iterator = multiInstanceDecision.getIterator();
        Aggregator aggregator = multiInstanceDecision.getAggregator();
        TDecision topLevelDecision = multiInstanceDecision.getTopLevelDecision();
        String lambdaParamName = this.getBasicDMNTransformer().namedElementVariableName((TNamedElement)iterator);
        String topLevelVariableName = this.getBasicDMNTransformer().namedElementVariableName((TNamedElement)topLevelDecision);
        Result result = this.evaluateLiteralExpression((TDRGElement)decision, iterationExpression, parentContext);
        List sourceList = (List)Result.value((Result)result);
        ArrayList<Object> outputList = new ArrayList<Object>();
        DMNContext loopContext = this.getBasicDMNTransformer().makeGlobalContext((TDRGElement)decision, parentContext);
        for (Object obj : sourceList) {
            loopContext.bind(lambdaParamName, obj);
            Result decisionResult = this.evaluateDecisionInContext(this.dmnModelRepository.makeDRGElementReference((TDRGElement)topLevelDecision), loopContext);
            outputList.add(Result.value((Result)decisionResult));
        }
        if (aggregator == Aggregator.COLLECT) {
            output = outputList;
        } else {
            SignavioLib<NUMBER, DATE, TIME, DATE_TIME, DURATION> feelLib = this.getFeelLib();
            if (aggregator == Aggregator.SUM) {
                output = feelLib.sum(outputList);
            } else if (aggregator == Aggregator.MIN) {
                output = feelLib.min(outputList);
            } else if (aggregator == Aggregator.MAX) {
                output = feelLib.max(outputList);
            } else if (aggregator == Aggregator.COUNT) {
                output = feelLib.count(outputList);
            } else if (aggregator == Aggregator.ALLTRUE) {
                output = outputList.stream().allMatch(o -> o == Boolean.TRUE);
            } else if (aggregator == Aggregator.ANYTRUE) {
                output = outputList.stream().anyMatch(o -> o == Boolean.TRUE);
            } else if (aggregator == Aggregator.ALLFALSE) {
                output = outputList.stream().anyMatch(o -> o == Boolean.FALSE);
            } else {
                this.errorHandler.reportError(String.format("'%s' is not implemented yet", new Object[]{aggregator}));
                output = null;
            }
        }
        return Result.of(output, (Type)this.getBasicDMNTransformer().drgElementOutputFEELType((TDRGElement)decision));
    }

    protected Result evaluateInvocationExpression(TDRGElement element, TInvocation invocation, DMNContext parentContext, DRGElement elementAnnotation) {
        LinkedHashMap argBinding = new LinkedHashMap();
        for (TBinding binding : invocation.getBinding()) {
            String argName = binding.getParameter().getName();
            TExpression argExpression = binding.getExpression();
            Result argResult = this.evaluateExpression(element, argExpression, parentContext, elementAnnotation);
            Iterator argJava = Result.value((Result)argResult);
            argBinding.put(argName, argJava);
        }
        TExpression functionExp = invocation.getExpression();
        if (functionExp instanceof TLiteralExpression) {
            String invocableName = NameUtils.invocableName((String)((TLiteralExpression)functionExp).getText());
            TInvocable invocable = this.dmnModelRepository.findInvocableByName(invocableName);
            if (invocable == null) {
                throw new DMNRuntimeException(String.format("Cannot find BKM for '%s'", invocableName));
            }
            ArrayList argList = new ArrayList();
            List formalParameterList = this.dmnTransformer.invocableFEELParameterNames((TDRGElement)invocable);
            for (String paramName : formalParameterList) {
                if (argBinding.containsKey(paramName)) {
                    Object argValue = argBinding.get(paramName);
                    argList.add(argValue);
                    continue;
                }
                throw new DMNRuntimeException(String.format("Cannot find binding for parameter '%s'", paramName));
            }
            DRGElementReference reference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)invocable);
            return this.evaluateInvocableInContext(reference, argList, parentContext);
        }
        throw new DMNRuntimeException(String.format("Not supported '%s'", functionExp.getClass().getSimpleName()));
    }

    protected boolean dagOptimisation() {
        return false;
    }
}

