/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab;

import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.signavio.testlab.InputParameterDefinition;
import com.gs.dmn.signavio.testlab.NopTestLabVisitor;
import com.gs.dmn.signavio.testlab.OutputParameterDefinition;
import com.gs.dmn.signavio.testlab.TestCase;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.testlab.TestLabUtil;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.ComplexExpression;
import com.gs.dmn.signavio.testlab.expression.Expression;
import com.gs.dmn.signavio.testlab.expression.ListExpression;
import com.gs.dmn.signavio.testlab.expression.Slot;
import java.util.LinkedHashMap;
import java.util.List;

public class TestLabEnhancer
extends NopTestLabVisitor
implements TestLabVisitor {
    private final TestLabUtil testLabUtil;

    public TestLabEnhancer(TestLabUtil testLabUtil) {
        this.testLabUtil = testLabUtil;
    }

    public void enhance(TestLab testLab) {
        testLab.accept(this, new LinkedHashMap());
    }

    @Override
    public Object visit(TestLab testLab, Object ... params) {
        List<TestCase> testCases = testLab.getTestCases();
        for (int i = 0; i < testCases.size(); ++i) {
            TestCase tc = testCases.get(i);
            tc.accept(this, testLab, i);
        }
        return testLab;
    }

    @Override
    public Object visit(TestCase testCase, Object ... params) {
        List<Expression> expectedValues;
        TestLab testLab = this.getTestLab(params);
        int testCaseIndex = this.getTestCaseIndex(params);
        List<Expression> inputValues = testCase.getInputValues();
        if (inputValues != null) {
            for (int i = 0; i < inputValues.size(); ++i) {
                Expression expression = inputValues.get(i);
                if (expression == null) continue;
                InputParameterDefinition parameterDefinition = testLab.getInputParameterDefinitions().get(i);
                try {
                    TItemDefinition itemDefinition = this.testLabUtil.lookupItemDefinition(parameterDefinition);
                    expression.accept(this, testLab, itemDefinition);
                    continue;
                }
                catch (Exception e) {
                    String requirementName = parameterDefinition.getRequirementName();
                    throw new DMNRuntimeException(String.format("Error in TestCase '%d' for '%s'", testCaseIndex + 1, requirementName), (Throwable)e);
                }
            }
        }
        if ((expectedValues = testCase.getExpectedValues()) != null) {
            for (int i = 0; i < expectedValues.size(); ++i) {
                Expression expression = expectedValues.get(i);
                if (expression == null) continue;
                OutputParameterDefinition parameterDefinition = testLab.getOutputParameterDefinitions().get(i);
                TItemDefinition itemDefinition = this.testLabUtil.lookupItemDefinition(parameterDefinition);
                expression.accept(this, testLab, itemDefinition);
            }
        }
        return testCase;
    }

    @Override
    public Object visit(ListExpression element, Object ... params) {
        TestLab testLab = this.getTestLab(params);
        TItemDefinition listType = this.getType(params);
        List<Expression> elements = element.getElements();
        if (elements != null) {
            TItemDefinition elementType = this.testLabUtil.elementType(listType);
            for (Expression e : elements) {
                if (e == null) continue;
                e.accept(this, testLab, elementType);
            }
        }
        return element;
    }

    @Override
    public Object visit(ComplexExpression expression, Object ... params) {
        TestLab testLab = this.getTestLab(params);
        TItemDefinition complexType = this.getType(params);
        List<Slot> slots = expression.getSlots();
        if (slots != null) {
            slots.forEach(s -> s.accept(this, testLab, this.testLabUtil.memberType(complexType, (Slot)s)));
        }
        return expression;
    }

    @Override
    public Object visit(Slot slot, Object ... params) {
        TItemDefinition type = this.getType(params);
        String name = type.getName();
        slot.setItemComponentName(name);
        slot.getValue().accept(this, params);
        return slot;
    }

    private TestLab getTestLab(Object ... params) {
        return (TestLab)params[0];
    }

    private int getTestCaseIndex(Object[] params) {
        return (Integer)params[1];
    }

    private TItemDefinition getType(Object ... params) {
        return (TItemDefinition)params[1];
    }
}

