/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.gs.dmn.signavio.testlab.TestLab;
import java.io.File;
import java.io.IOException;
import java.io.Reader;

public class TestLabSerializer {
    public static final String TEST_LAB_FILE_EXTENSION = ".json";
    public static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.NONE)).build();

    public static boolean isTestLabFile(File file) {
        return file != null && file.isFile() && file.getName().endsWith(TEST_LAB_FILE_EXTENSION);
    }

    public TestLab read(File inputFile) throws IOException {
        TestLab testLab = (TestLab)MAPPER.readValue(inputFile, TestLab.class);
        testLab.setSource(inputFile.getName());
        return testLab;
    }

    public TestLab read(Reader reader) throws IOException {
        TestLab testLab = (TestLab)MAPPER.readValue(reader, TestLab.class);
        testLab.setSource(reader.getClass().getSimpleName());
        return testLab;
    }

    public void write(TestLab testLab, File file) throws IOException {
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, (Object)testLab);
    }
}

