/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.serialization.DMNSerializer;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.testlab.OutputParameterDefinition;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.testlab.TestLabEnhancer;
import com.gs.dmn.signavio.testlab.TestLabSerializer;
import com.gs.dmn.signavio.testlab.TestLabUtil;
import com.gs.dmn.signavio.testlab.TestLabValidator;
import com.gs.dmn.transformation.AbstractTestCasesToJUnitTransformer;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.DMNValidator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class TestLabToJavaJUnitTransformer<NUMBER, DATE, TIME, DATE_TIME, DURATION>
extends AbstractTestCasesToJUnitTransformer<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestLab> {
    private final TestLabSerializer testLabReader = new TestLabSerializer();
    private final TestLabValidator testLabValidator = new TestLabValidator();
    private final String schemaNamespace;
    private final BasicDMNToNativeTransformer<Type, DMNContext> basicTransformer;
    private final TestLabUtil testLabUtil;
    private final TestLabEnhancer testLabEnhancer;

    public TestLabToJavaJUnitTransformer(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestLab> dialectDefinition, DMNValidator dmnValidator, DMNTransformer<TestLab> dmnTransformer, TemplateProvider templateProvider, LazyEvaluationDetector lazyEvaluationDetector, TypeDeserializationConfigurer typeDeserializationConfigurer, Path inputModelPath, InputParameters inputParameters, BuildLogger logger) {
        super(dialectDefinition, dmnValidator, dmnTransformer, templateProvider, lazyEvaluationDetector, typeDeserializationConfigurer, inputParameters, logger);
        String schemaNamespace = inputParameters.getSchemaNamespace();
        this.schemaNamespace = StringUtils.isBlank((CharSequence)schemaNamespace) ? "http://www.signavio.com/schema/dmn/1.1/" : schemaNamespace;
        DMNModelRepository repository = this.readModels(inputModelPath.toFile());
        this.basicTransformer = this.dialectDefinition.createBasicTransformer(repository, lazyEvaluationDetector, inputParameters);
        DMNModelRepository dmnModelRepository = this.basicTransformer.getDMNModelRepository();
        this.dmnValidator.validate(dmnModelRepository);
        this.testLabUtil = new TestLabUtil(this.basicTransformer);
        this.testLabEnhancer = new TestLabEnhancer(this.testLabUtil);
    }

    protected boolean shouldTransformFile(File inputFile) {
        if (inputFile == null) {
            return false;
        }
        if (inputFile.isDirectory()) {
            return !inputFile.getName().endsWith(".svn");
        }
        return TestLabSerializer.isTestLabFile(inputFile);
    }

    protected void transformFile(File file, File root, Path outputPath) {
        try {
            this.logger.info(String.format("Processing TestLab file '%s'", file.getPath()));
            StopWatch watch = new StopWatch();
            watch.start();
            List<TestLab> testLabList = new ArrayList<TestLab>();
            if (file.isFile()) {
                TestLab testLab = this.testLabReader.read(file);
                this.testLabValidator.validate(testLab);
                this.testLabEnhancer.enhance(testLab);
                testLabList.add(testLab);
            } else {
                for (File child : file.listFiles()) {
                    if (!this.shouldTransformFile(child)) continue;
                    TestLab testLab = this.testLabReader.read(child);
                    this.testLabValidator.validate(testLab);
                    this.testLabEnhancer.enhance(testLab);
                    testLabList.add(testLab);
                }
            }
            testLabList = (List)this.dmnTransformer.transform(this.basicTransformer.getDMNModelRepository(), testLabList).getRight();
            for (TestLab testLab : testLabList) {
                String javaClassName = this.testClassName(testLab, this.basicTransformer);
                this.processTemplate(testLab, this.templateProvider.testBaseTemplatePath(), this.templateProvider.testTemplateName(), this.basicTransformer, outputPath, javaClassName);
            }
            watch.stop();
            this.logger.info("TestLab processing time: " + watch);
        }
        catch (IOException e) {
            throw new DMNRuntimeException(String.format("Error during transforming %s.", file.getName()), (Throwable)e);
        }
    }

    protected DMNModelRepository readModels(File file) {
        if (DMNSerializer.isDMNFile((File)file)) {
            TDefinitions result = this.dmnSerializer.readModel(file);
            return new SignavioDMNModelRepository(result, this.schemaNamespace);
        }
        throw new DMNRuntimeException(String.format("Invalid DMN file %s", file.getAbsoluteFile()));
    }

    private void processTemplate(TestLab testLab, String baseTemplatePath, String templateName, BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer, Path outputPath, String testClassName) {
        try {
            String javaPackageName = dmnTransformer.nativeModelPackageName(testLab.getModelName());
            Map<String, Object> params = this.makeTemplateParams(testLab, dmnTransformer);
            params.put("packageName", javaPackageName);
            params.put("testClassName", testClassName);
            params.put("decisionBaseClass", this.decisionBaseClass);
            String relativeFilePath = javaPackageName.replace('.', '/');
            String fileExtension = this.getFileExtension();
            File outputFile = this.makeOutputFile(outputPath, relativeFilePath, testClassName, fileExtension);
            this.processTemplate(baseTemplatePath, templateName, params, outputFile, true);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot process TestLab template '%s' for '%s'", templateName, testLab.getRootDecisionId()), (Throwable)e);
        }
    }

    private String testClassName(TestLab testLab, BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer) {
        List<OutputParameterDefinition> outputParameterDefinitions = testLab.getOutputParameterDefinitions();
        OutputParameterDefinition outputParameterDefinition = outputParameterDefinitions.get(0);
        return this.testClassName(dmnTransformer, outputParameterDefinition);
    }

    private String testClassName(BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer, OutputParameterDefinition outputParameterDefinition) {
        TDRGElement decision = this.testLabUtil.findDRGElement(outputParameterDefinition);
        if (decision instanceof TDecision) {
            String requirementName = decision.getName();
            return dmnTransformer.upperCaseFirst(requirementName + "Test");
        }
        throw new IllegalArgumentException(String.format("The DRGElement '%s' should be a decision, is output of TestLab.", outputParameterDefinition.getId()));
    }

    private Map<String, Object> makeTemplateParams(TestLab testLab, BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("testLab", testLab);
        params.put("testLabUtil", this.testLabUtil);
        return params;
    }

    protected String getFileExtension() {
        return ".java";
    }
}

