/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.analysis.semantics.type.CompositeDataType;
import com.gs.dmn.feel.analysis.semantics.type.ContextType;
import com.gs.dmn.feel.analysis.semantics.type.ItemDefinitionType;
import com.gs.dmn.feel.analysis.semantics.type.ListType;
import com.gs.dmn.feel.synthesis.type.NativeTypeFactory;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.testlab.InputParameterDefinition;
import com.gs.dmn.signavio.testlab.OutputParameterDefinition;
import com.gs.dmn.signavio.testlab.ParameterDefinition;
import com.gs.dmn.signavio.testlab.TestCase;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.testlab.expression.ComplexExpression;
import com.gs.dmn.signavio.testlab.expression.Expression;
import com.gs.dmn.signavio.testlab.expression.ListExpression;
import com.gs.dmn.signavio.testlab.expression.SimpleExpression;
import com.gs.dmn.signavio.testlab.expression.Slot;
import com.gs.dmn.signavio.transformation.basic.BasicSignavioDMNToJavaTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.native_.expression.NativeExpressionFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLabUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TestLabUtil.class);
    private final BasicDMNToNativeTransformer<Type, DMNContext> transformer;
    private final SignavioDMNModelRepository repository;
    private final NativeExpressionFactory nativeFactory;
    private final NativeTypeFactory typeFactory;

    public TestLabUtil(BasicDMNToNativeTransformer<Type, DMNContext> transformer) {
        DMNModelRepository dmnModelRepository = transformer.getDMNModelRepository();
        this.repository = dmnModelRepository instanceof SignavioDMNModelRepository ? (SignavioDMNModelRepository)dmnModelRepository : new SignavioDMNModelRepository(dmnModelRepository.getRootDefinitions());
        this.transformer = transformer;
        this.nativeFactory = transformer.getNativeFactory();
        this.typeFactory = transformer.getNativeTypeFactory();
    }

    public String drgElementClassName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.drgElementClassName((TDRGElement)decision);
    }

    public String drgElementVariableName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.namedElementVariableName((TNamedElement)decision);
    }

    public String drgElementOutputType(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.drgElementOutputType((TDRGElement)decision);
    }

    public String drgElementArgumentList(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.drgElementArgumentList((TDRGElement)decision);
    }

    public String drgElementOutputFieldName(TestLab testLab, int outputIndex) {
        TDecision decision = (TDecision)this.findDRGElement(testLab.getRootOutputParameter());
        return ((BasicSignavioDMNToJavaTransformer)this.transformer).drgElementOutputFieldName((TDRGElement)decision, outputIndex);
    }

    public String inputDataVariableName(InputParameterDefinition inputParameterDefinition) {
        TDRGElement element = this.findDRGElement(inputParameterDefinition);
        return this.transformer.namedElementVariableName((TNamedElement)element);
    }

    public String assertClassName() {
        return this.transformer.assertClassName();
    }

    public String executionContextClassName() {
        return this.transformer.executionContextClassName();
    }

    public String executionContextVariableName() {
        return this.transformer.executionContextVariableName();
    }

    public String annotationSetClassName() {
        return this.transformer.annotationSetClassName();
    }

    public String annotationSetVariableName() {
        return this.transformer.annotationSetVariableName();
    }

    public String eventListenerClassName() {
        return this.transformer.eventListenerClassName();
    }

    public String defaultEventListenerClassName() {
        return this.transformer.defaultEventListenerClassName();
    }

    public String eventListenerVariableName() {
        return this.transformer.eventListenerVariableName();
    }

    public String externalExecutorClassName() {
        return this.transformer.externalExecutorClassName();
    }

    public String externalExecutorVariableName() {
        return this.transformer.externalExecutorVariableName();
    }

    public String defaultExternalExecutorClassName() {
        return this.transformer.defaultExternalExecutorClassName();
    }

    public String cacheInterfaceName() {
        return this.transformer.cacheInterfaceName();
    }

    public String cacheVariableName() {
        return this.transformer.cacheVariableName();
    }

    public String defaultCacheClassName() {
        return this.transformer.defaultCacheClassName();
    }

    public boolean hasListType(ParameterDefinition parameterDefinition) {
        TDRGElement element = this.findDRGElement(parameterDefinition);
        return this.transformer.hasListType(element);
    }

    public boolean isSimple(Expression expression) {
        return expression instanceof SimpleExpression;
    }

    public boolean isComplex(Expression expression) {
        return expression instanceof ComplexExpression;
    }

    public boolean isList(Expression expression) {
        return expression instanceof ListExpression;
    }

    public String getter(String outputName) {
        return this.transformer.getter(outputName);
    }

    public String qualifiedName(TestLab testLab, OutputParameterDefinition rootOutputParameter) {
        String pkg = this.transformer.nativeModelPackageName(rootOutputParameter.getModelName());
        String cls = this.drgElementClassName(rootOutputParameter);
        return this.transformer.qualifiedName(pkg, cls);
    }

    public TDRGElement findDRGElement(ParameterDefinition parameterDefinition) {
        String id = parameterDefinition.getId();
        TDRGElement element = this.repository.findDRGElementById(id);
        if (element == null) {
            element = this.repository.findDRGElementByDiagramAndShapeIds(parameterDefinition.getDiagramId(), parameterDefinition.getShapeId());
        }
        if (element == null) {
            element = this.repository.findDRGElementByLabel(parameterDefinition.getRequirementName(), parameterDefinition.getDiagramId(), parameterDefinition.getShapeId());
        }
        return element;
    }

    public String toNativeType(InputParameterDefinition inputParameterDefinition) {
        Type feelType = this.toFEELType(inputParameterDefinition);
        String type = this.transformer.toNativeType(feelType);
        return this.typeFactory.nullableType(type);
    }

    public String toNativeExpression(TestLab testLab, TestCase testCase, int inputIndex) {
        Type inputType = this.toFEELType(testLab.getInputParameterDefinitions().get(inputIndex));
        Expression inputExpression = testCase.getInputValues().get(inputIndex);
        TDecision decision = (TDecision)this.findDRGElement(testLab.getRootOutputParameter());
        return this.toNativeExpression(inputType, inputExpression, decision);
    }

    public String toNativeExpression(TestLab testLab, Expression expression) {
        Type outputType = this.toFEELType(testLab.getRootOutputParameter());
        TDecision decision = (TDecision)this.findDRGElement(testLab.getRootOutputParameter());
        return this.toNativeExpression(outputType, expression, decision);
    }

    private String toNativeExpression(Type inputType, Expression inputExpression, TDecision decision) {
        if (inputExpression == null) {
            return "null";
        }
        if (this.isSimple(inputExpression)) {
            String feelExpression = inputExpression.toFEELExpression();
            return this.transformer.literalExpressionToNative((TDRGElement)decision, feelExpression);
        }
        if (this.isList(inputExpression)) {
            List<Expression> expressionList = ((ListExpression)inputExpression).getElements();
            if (expressionList != null) {
                Type elementType = this.elementType(inputType);
                List elements = expressionList.stream().map(e -> this.toNativeExpression(elementType, (Expression)e, decision)).collect(Collectors.toList());
                String exp = String.join((CharSequence)", ", elements);
                return this.nativeFactory.asList(elementType, exp);
            }
            return "null";
        }
        if (this.isComplex(inputExpression)) {
            List<Slot> slots = ((ComplexExpression)inputExpression).getSlots();
            if (slots != null) {
                Set<String> members = this.members(inputType);
                ArrayList<Pair<String, Expression>> pairs = new ArrayList<Pair<String, Expression>>();
                LinkedHashSet<String> present = new LinkedHashSet<String>();
                for (Slot slot : slots) {
                    ImmutablePair immutablePair = new ImmutablePair((Object)slot.getItemComponentName(), (Object)slot.getValue());
                    pairs.add((Pair<String, Expression>)immutablePair);
                    present.add((String)immutablePair.getLeft());
                }
                for (String string : members) {
                    if (present.contains(string)) continue;
                    ImmutablePair immutablePair = new ImmutablePair((Object)string, null);
                    pairs.add((Pair<String, Expression>)immutablePair);
                }
                this.sortParameters(pairs);
                ArrayList<String> args = new ArrayList<String>();
                for (Pair pair : pairs) {
                    Type memberType = this.memberType(inputType, (String)pair.getLeft());
                    String arg = this.toNativeExpression(memberType, (Expression)pair.getRight(), decision);
                    args.add(arg);
                }
                String string = String.join((CharSequence)", ", args);
                return this.transformer.constructor(this.transformer.itemDefinitionNativeClassName(this.transformer.toNativeType(inputType)), string);
            }
            return "null";
        }
        throw new UnsupportedOperationException(String.format("%s is not supported", inputExpression.getClass().getSimpleName()));
    }

    TItemDefinition elementType(TItemDefinition type) {
        TDefinitions model = this.repository.getModel((TNamedElement)type);
        if (type.isIsCollection()) {
            String typeRef = QualifiedName.toName((QName)type.getTypeRef());
            if (!this.repository.isNull(typeRef)) {
                return this.repository.lookupItemDefinition(model, QualifiedName.toQualifiedName((TDefinitions)model, (String)typeRef));
            }
            List itemComponent = type.getItemComponent();
            if (itemComponent.size() == 1) {
                return (TItemDefinition)itemComponent.get(0);
            }
            return type;
        }
        throw new DMNRuntimeException(String.format("Expected list type, found '%s'", type.getName()));
    }

    TItemDefinition memberType(TItemDefinition itemDefinition, Slot slot) {
        String id = slot.getId();
        String name = slot.getItemComponentName();
        String label = slot.getName();
        try {
            List itemComponent = itemDefinition.getItemComponent();
            if (itemComponent == null || itemComponent.isEmpty()) {
                itemDefinition = this.transformer.getDMNModelRepository().normalize(itemDefinition);
                itemComponent = itemDefinition.getItemComponent();
            }
            if (!StringUtils.isBlank((CharSequence)name)) {
                for (TItemDefinition child : itemComponent) {
                    if (!this.repository.sameName((TNamedElement)child, name)) continue;
                    return child;
                }
            }
            if (!StringUtils.isBlank((CharSequence)label)) {
                for (TItemDefinition child : itemComponent) {
                    if (!this.repository.sameLabel((TNamedElement)child, label)) continue;
                    return child;
                }
            }
            if (!StringUtils.isBlank((CharSequence)id)) {
                for (TItemDefinition child : itemComponent) {
                    if (!this.repository.sameId((TDMNElement)child, id)) continue;
                    return child;
                }
                for (TItemDefinition child : itemComponent) {
                    if (!this.repository.idEndsWith((TNamedElement)child, id)) continue;
                    return child;
                }
                for (TItemDefinition child : itemComponent) {
                    if (!this.sameSlotId(child, id)) continue;
                    return child;
                }
            }
            int index = Integer.parseInt(id);
            TItemDefinition memberType = (TItemDefinition)itemDefinition.getItemComponent().get(index);
            if (memberType != null) {
                return memberType;
            }
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot find member '(name='%s' label='%s' id='%s') in ItemDefinition '%s'", name, label, id, itemDefinition == null ? null : itemDefinition.getName()), (Throwable)e);
        }
        throw new DMNRuntimeException(String.format("Cannot find member '(name='%s' label='%s' id='%s') in ItemDefinition '%s'", name, label, id, itemDefinition.getName()));
    }

    private boolean sameSlotId(TItemDefinition child, String id) {
        child.getExtensionElements();
        return false;
    }

    private Type elementType(Type type) {
        if (type instanceof ListType) {
            return ((ListType)type).getElementType();
        }
        throw new DMNRuntimeException(String.format("Expected list type, found '%s'", type));
    }

    private Set<String> members(Type type) {
        if (type instanceof ItemDefinitionType) {
            return ((ItemDefinitionType)type).getMembers();
        }
        if (type instanceof ContextType) {
            return ((ContextType)type).getMembers();
        }
        return new LinkedHashSet<String>();
    }

    private Type memberType(Type type, String member) {
        Type memberType = null;
        if (type instanceof ItemDefinitionType) {
            memberType = ((ItemDefinitionType)type).getMemberType(member);
        } else if (type instanceof ContextType) {
            memberType = ((ContextType)type).getMemberType(member);
        }
        if (memberType == null) {
            throw new DMNRuntimeException(String.format("Cannot find member '%s' in type '%s'", member, type));
        }
        return memberType;
    }

    private List<Pair<String, Expression>> sortParameters(List<Pair<String, Expression>> parameters) {
        parameters.sort(Comparator.comparing(Pair::getLeft));
        return parameters;
    }

    private Type toFEELType(ParameterDefinition parameterDefinition) {
        try {
            TDRGElement element = this.findDRGElement(parameterDefinition);
            TDefinitions model = this.repository.getModel((TNamedElement)element);
            String typeRef = this.getTypeRef(parameterDefinition);
            return this.transformer.toFEELType(model, QualifiedName.toQualifiedName((TDefinitions)model, (String)typeRef));
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot resolve FEEL type for requirementId requirement '%s' in DM '%s'", parameterDefinition.getId(), parameterDefinition.getModelName()));
        }
    }

    TItemDefinition lookupItemDefinition(ParameterDefinition parameterDefinition) {
        String typeRef = this.getTypeRef(parameterDefinition);
        TDRGElement element = this.findDRGElement(parameterDefinition);
        TDefinitions model = this.repository.getModel((TNamedElement)element);
        return this.transformer.getDMNModelRepository().lookupItemDefinition(model, QualifiedName.toQualifiedName((TDefinitions)model, (String)typeRef));
    }

    private String getTypeRef(ParameterDefinition parameterDefinition) {
        String typeRef;
        TDRGElement element = this.findDRGElement(parameterDefinition);
        if (element instanceof TInputData) {
            typeRef = QualifiedName.toName((QName)((TInputData)element).getVariable().getTypeRef());
        } else if (element instanceof TDecision) {
            typeRef = QualifiedName.toName((QName)((TDecision)element).getVariable().getTypeRef());
        } else {
            throw new UnsupportedOperationException(String.format("Cannot resolve FEEL type for requirementId requirement '%s'. '%s' not supported", parameterDefinition.getId(), element.getClass().getSimpleName()));
        }
        return typeRef;
    }

    public boolean isSingletonDecision() {
        return this.transformer.isSingletonDecision();
    }

    public String singletonDecisionInstance(String decisionQName) {
        return this.transformer.singletonDecisionInstance(decisionQName);
    }

    public String defaultConstructor(String className) {
        return this.transformer.defaultConstructor(className);
    }

    public String constructor(String className, String arguments) {
        return this.transformer.constructor(className, arguments);
    }

    public boolean isGenerateProto() {
        return this.transformer.isGenerateProto();
    }

    public String toNativeExpressionProto(InputParameterDefinition inputParameterDefinition) {
        String inputName = this.inputDataVariableName(inputParameterDefinition);
        Type type = this.toFEELType(inputParameterDefinition);
        return this.transformer.getNativeFactory().convertValueToProtoNativeType(inputName, type, false);
    }

    public String toNativeExpressionProto(TestLab testLab, Expression expression) {
        Type outputType = this.toFEELType(testLab.getRootOutputParameter());
        TDecision decision = (TDecision)this.findDRGElement(testLab.getRootOutputParameter());
        String value = this.toNativeExpression(outputType, expression, decision);
        if (this.transformer.isDateTimeType(outputType) || this.transformer.isComplexType(outputType)) {
            return this.transformer.getNativeFactory().convertValueToProtoNativeType(value, outputType, false);
        }
        return value;
    }

    public String toNativeTypeProto(InputParameterDefinition inputParameterDefinition) {
        Type type = this.toFEELType(inputParameterDefinition);
        return this.transformer.getProtoFactory().toNativeProtoType(type);
    }

    public boolean isProtoReference(InputParameterDefinition inputParameterDefinition) {
        Type type = this.toFEELType(inputParameterDefinition);
        return this.transformer.isProtoReference(type);
    }

    public String drgElementVariableNameProto(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.getProtoFactory().namedElementVariableNameProto((TNamedElement)decision);
    }

    public String drgElementArgumentListProto(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.drgElementArgumentListProto((TDRGElement)decision);
    }

    public String qualifiedRequestMessageName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.getProtoFactory().qualifiedRequestMessageName((TDRGElement)decision);
    }

    public String qualifiedResponseMessageName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.getProtoFactory().qualifiedResponseMessageName((TDRGElement)decision);
    }

    public String drgElementOutputTypeProto(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.drgElementOutputTypeProto((TDRGElement)decision);
    }

    public String requestVariableName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.getProtoFactory().requestVariableName((TDRGElement)decision);
    }

    public String responseVariableName(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        return this.transformer.getProtoFactory().responseVariableName((TDRGElement)decision);
    }

    public String protoGetter(OutputParameterDefinition outputParameterDefinition) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        Type type = this.transformer.drgElementOutputFEELType((TDRGElement)decision);
        String name = this.drgElementVariableName(outputParameterDefinition);
        return this.transformer.getProtoFactory().protoGetter(name, type);
    }

    public String protoGetter(OutputParameterDefinition outputParameterDefinition, String memberName) {
        TDecision decision = (TDecision)this.findDRGElement(outputParameterDefinition);
        Type type = this.transformer.drgElementOutputFEELType((TDRGElement)decision);
        if (type instanceof ListType) {
            type = ((ListType)type).getElementType();
        }
        if (type instanceof CompositeDataType) {
            Type memberType = ((CompositeDataType)type).getMemberType(memberName);
            return this.transformer.getProtoFactory().protoGetter(memberName, memberType);
        }
        String protoName = this.transformer.getProtoFactory().protoName(memberName);
        return this.transformer.getter(protoName);
    }

    public String protoSetter(InputParameterDefinition inputParameterDefinition, String args) {
        String inputName = this.inputDataVariableName(inputParameterDefinition);
        Type type = this.toFEELType(inputParameterDefinition);
        return this.transformer.getProtoFactory().protoSetter(inputName, type, args);
    }
}

