/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab.expression;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.Expression;
import com.gs.dmn.signavio.testlab.expression.Slot;
import java.util.List;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"type", "slots"})
public class ComplexExpression
extends Expression {
    private List<Slot> slots;

    public List<Slot> getSlots() {
        return this.slots;
    }

    public ComplexExpression() {
    }

    public ComplexExpression(List<Slot> slots) {
        this.slots = slots;
    }

    @Override
    public String toFEELExpression() {
        if (this.slots == null) {
            return "null";
        }
        String context = this.slots.stream().map(Slot::toContextEntry).collect(Collectors.joining(", "));
        return String.format("{%s}", context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexExpression that = (ComplexExpression)o;
        return this.slots != null ? this.slots.equals(that.slots) : that.slots == null;
    }

    public int hashCode() {
        return this.slots != null ? this.slots.hashCode() : 0;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.slots);
    }

    @Override
    public Object accept(TestLabVisitor visitor, Object ... params) {
        return visitor.visit(this, params);
    }
}

