/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab.expression;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.SimpleExpression;

@JsonPropertyOrder(value={"type", "value", "name"})
public class EnumerationLiteral
extends SimpleExpression {
    private String name;
    private String value;

    public EnumerationLiteral() {
    }

    public EnumerationLiteral(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toFEELExpression() {
        if (this.name == null) {
            return "null";
        }
        return String.format("\"%s\"", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumerationLiteral that = (EnumerationLiteral)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.name, this.value);
    }

    @Override
    public Object accept(TestLabVisitor visitor, Object ... params) {
        return visitor.visit(this, params);
    }
}

