/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab.expression;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.Expression;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"type", "value"})
public class ListExpression
extends Expression {
    private List<Expression> value;

    public ListExpression() {
    }

    public ListExpression(List<Expression> value) {
        this.value = value;
    }

    public List<Expression> getElements() {
        return this.value;
    }

    @Override
    public String toFEELExpression() {
        if (this.value == null) {
            return "null";
        }
        ArrayList<String> elementsList = new ArrayList<String>();
        for (Expression e : this.value) {
            if (e != null) {
                elementsList.add(e.toFEELExpression());
                continue;
            }
            elementsList.add("null");
        }
        String elements = String.join((CharSequence)", ", elementsList);
        return String.format("[%s]", elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListExpression that = (ListExpression)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public Object accept(TestLabVisitor visitor, Object ... params) {
        return visitor.visit(this, params);
    }
}

