/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab.expression;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.gs.dmn.signavio.testlab.TestLabElement;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.Expression;

@JsonPropertyOrder(value={"id", "name", "value", "itemComponentName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Slot
extends TestLabElement {
    private String id;
    private String name;
    private Expression value;
    private String itemComponentName;

    public Slot() {
    }

    public Slot(String id, String name, Expression value, String itemComponentName) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.itemComponentName = itemComponentName;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Expression getValue() {
        return this.value;
    }

    public String getItemComponentName() {
        return this.itemComponentName;
    }

    public void setItemComponentName(String itemComponentName) {
        this.itemComponentName = itemComponentName;
    }

    public String toContextEntry() {
        if (this.value == null) {
            return String.format("%s : null", this.itemComponentName);
        }
        return String.format("%s : %s", this.itemComponentName, this.value.toFEELExpression());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slot slot = (Slot)o;
        if (this.id != null ? !this.id.equals(slot.id) : slot.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(slot.name) : slot.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(slot.value) : slot.value != null) {
            return false;
        }
        return this.itemComponentName != null ? this.itemComponentName.equals(slot.itemComponentName) : slot.itemComponentName == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.itemComponentName != null ? this.itemComponentName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s(%s, %s, %s, %s)", this.getClass().getSimpleName(), this.name, this.itemComponentName, this.id, this.value);
    }

    @Override
    public Object accept(TestLabVisitor visitor, Object ... params) {
        return visitor.visit(this, params);
    }
}

