/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.testlab.expression;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.gs.dmn.signavio.testlab.TestLabVisitor;
import com.gs.dmn.signavio.testlab.expression.SimpleExpression;

@JsonPropertyOrder(value={"type", "value"})
public class TimeLiteral
extends SimpleExpression {
    private String value;

    public TimeLiteral() {
    }

    public TimeLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toFEELExpression() {
        if (this.value == null) {
            return "null";
        }
        return String.format("time(\"%s\")", this.cleanValue(this.value));
    }

    private String cleanValue(String value) {
        return value != null && value.startsWith("T") ? value.substring(1) : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeLiteral that = (TimeLiteral)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public Object accept(TestLabVisitor visitor, Object ... params) {
        return visitor.visit(this, params);
    }
}

