/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInformationRequirement;
import com.gs.dmn.ast.TInputClause;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TOutputClause;
import com.gs.dmn.ast.TUnaryTests;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.testlab.InputParameterDefinition;
import com.gs.dmn.signavio.testlab.TestCase;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.testlab.expression.Expression;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMergeInputDataTransformer
extends SimpleDMNTransformer<TestLab> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMergeInputDataTransformer.class);
    private static final String FORCE_MERGE = "forceMerge";
    private final BuildLogger logger;
    private Map<String, Pair<TInputData, List<TInputData>>> inputDataClasses;
    private boolean forceMerge = true;

    protected AbstractMergeInputDataTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public AbstractMergeInputDataTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public void configure(Map<String, Object> configuration) {
        if (configuration != null && !configuration.isEmpty()) {
            Object forceMergeStr = configuration.get(FORCE_MERGE);
            if (forceMergeStr instanceof String && configuration.size() == 1) {
                this.forceMerge = Boolean.parseBoolean((String)forceMergeStr);
            } else {
                throw new DMNRuntimeException(String.format("Invalid transformer configuration: %s. Configuration does not have expected structure (expecting \"%s\" node)", configuration, FORCE_MERGE));
            }
        }
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        this.inputDataClasses = new LinkedHashMap<String, Pair<TInputData, List<TInputData>>>();
        return this.mergeInputData(repository, this.logger);
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test cases list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.inputDataClasses == null) {
            this.transform(repository);
        }
        for (TestLab testLab : testCasesList) {
            this.transform(testLab, (SignavioDMNModelRepository)repository);
        }
        return new Pair((Object)repository.copy(), testCasesList);
    }

    private void transform(TestLab testLab, SignavioDMNModelRepository repository) {
        if (!this.forceMerge) {
            List<TestCase> testCases = testLab.getTestCases();
            for (TestCase testCase : testCases) {
                List<Expression> inputValues = testCase.getInputValues();
                for (int i = 0; i < testLab.getInputParameterDefinitions().size() - 1; ++i) {
                    InputParameterDefinition firstParameter = testLab.getInputParameterDefinitions().get(i);
                    String firstRequirementName = this.equivalenceKey(firstParameter);
                    Expression firstExpression = inputValues.get(i);
                    for (int j = i + 1; j < testLab.getInputParameterDefinitions().size(); ++j) {
                        Expression secondExpression;
                        InputParameterDefinition secondParameter = testLab.getInputParameterDefinitions().get(j);
                        String secondRequirementName = this.equivalenceKey(secondParameter);
                        if (!firstRequirementName.equals(secondRequirementName) || Objects.equals(firstExpression, secondExpression = inputValues.get(j))) continue;
                        throw new DMNRuntimeException(String.format("Cannot merge, incompatible values for InputData '%s' '%s' and '%s'", firstRequirementName, firstExpression, secondExpression));
                    }
                }
            }
        }
        ArrayList<InputParameterDefinition> toRemove = new ArrayList<InputParameterDefinition>();
        ArrayList<Integer> indexToRemove = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < testLab.getInputParameterDefinitions().size(); ++i) {
            InputParameterDefinition ipd = testLab.getInputParameterDefinitions().get(i);
            String requirementName = this.equivalenceKey(ipd);
            if (labels.contains(requirementName)) {
                toRemove.add(ipd);
                indexToRemove.add(i);
                continue;
            }
            labels.add(requirementName);
            Pair<TInputData, List<TInputData>> pair = this.inputDataClasses.get(requirementName);
            if (pair == null) {
                throw new DMNRuntimeException(String.format("Cannot find InputData for input parameter with requirementName='%s'", requirementName));
            }
            TInputData representative = (TInputData)pair.getLeft();
            String representativeDiagramId = repository.getDiagramId((TDMNElement)representative);
            String representativeShapeId = repository.getShapeId((TDRGElement)representative);
            ipd.setDiagramId(representativeDiagramId);
            ipd.setShapeId(representativeShapeId);
        }
        testLab.getInputParameterDefinitions().removeAll(toRemove);
        List<TestCase> testCases = testLab.getTestCases();
        for (TestCase testCase : testCases) {
            List<Expression> inputValues = testCase.getInputValues();
            ArrayList<Expression> newList = new ArrayList<Expression>();
            for (int i = 0; i < inputValues.size(); ++i) {
                if (indexToRemove.contains(i)) continue;
                newList.add(inputValues.get(i));
            }
            inputValues.clear();
            inputValues.addAll(newList);
        }
    }

    private DMNModelRepository mergeInputData(DMNModelRepository repository, BuildLogger logger) {
        TInputData representative;
        this.inputDataClasses = this.inputDataEquivalenceClasses(repository);
        TDefinitions definitions = repository.getRootDefinitions();
        for (Pair<TInputData, List<TInputData>> pair : this.inputDataClasses.values()) {
            representative = (TInputData)pair.getLeft();
            List inputDataInClass = (List)pair.getRight();
            if (inputDataInClass.size() < 2) continue;
            List decisions = repository.findDecisions(definitions);
            for (TDecision decision : decisions) {
                List informationRequirementList = decision.getInformationRequirement();
                for (TInformationRequirement ir : informationRequirementList) {
                    String href;
                    TInputData referencedInputData;
                    if (ir.getRequiredInput() == null || !inputDataInClass.contains(referencedInputData = repository.findInputDataByRef((TDRGElement)decision, href = ir.getRequiredInput().getHref())) || referencedInputData == representative) continue;
                    String oldInputDataName = referencedInputData.getName();
                    String newInputDataName = representative.getName();
                    logger.info(String.format("Replacing input '%s' with '%s' in decision '%s'", oldInputDataName, newInputDataName, decision.getName()));
                    ir.getRequiredInput().setHref("#" + representative.getId());
                    TExpression expression = decision.getExpression();
                    if (expression instanceof TDecisionTable) {
                        TDecisionTable decisionTable = (TDecisionTable)expression;
                        List inputClauselist = decisionTable.getInput();
                        for (TInputClause ic : inputClauselist) {
                            this.replace(oldInputDataName, newInputDataName, ic.getInputExpression());
                        }
                        for (TOutputClause oc : decisionTable.getOutput()) {
                            this.replace(oldInputDataName, newInputDataName, oc.getDefaultOutputEntry());
                        }
                        for (TDecisionRule rule : decisionTable.getRule()) {
                            String description = rule.getDescription();
                            rule.setDescription(this.replace(oldInputDataName, newInputDataName, description));
                            for (TUnaryTests unaryTests : rule.getInputEntry()) {
                                unaryTests.setText(this.replace(oldInputDataName, newInputDataName, unaryTests.getText()));
                            }
                            for (TLiteralExpression literalExpression : rule.getOutputEntry()) {
                                this.replace(oldInputDataName, newInputDataName, literalExpression);
                            }
                        }
                        continue;
                    }
                    if (!(expression instanceof TLiteralExpression)) continue;
                    this.replace(oldInputDataName, newInputDataName, (TLiteralExpression)expression);
                }
            }
        }
        for (Pair<TInputData, List<TInputData>> pair : this.inputDataClasses.values()) {
            representative = (TInputData)pair.getLeft();
            List inputDataClass = (List)pair.getRight();
            for (TInputData inputData : inputDataClass) {
                if (inputData == representative) continue;
                this.removeDRGElement(definitions, (TDRGElement)inputData);
            }
        }
        return repository.copy();
    }

    private Map<String, Pair<TInputData, List<TInputData>>> inputDataEquivalenceClasses(DMNModelRepository repository) {
        LinkedHashMap<String, Pair<TInputData, List<TInputData>>> inputDataClasses = new LinkedHashMap<String, Pair<TInputData, List<TInputData>>>();
        TDefinitions definitions = repository.getRootDefinitions();
        List inputDataList = repository.findInputDatas(definitions);
        for (TInputData tInputData : inputDataList) {
            String key = this.equivalenceKey(tInputData, repository);
            Pair inputDataClass = inputDataClasses.computeIfAbsent(key, k -> new Pair(null, new ArrayList()));
            ((List)inputDataClass.getRight()).add(tInputData);
        }
        for (Map.Entry entry : inputDataClasses.entrySet()) {
            Pair inputDataClass = (Pair)entry.getValue();
            TInputData representative = this.shortestName((List)inputDataClass.getRight());
            inputDataClasses.put((String)entry.getKey(), (Pair<TInputData, List<TInputData>>)new Pair((Object)representative, (Object)((List)inputDataClass.getRight())));
        }
        return inputDataClasses;
    }

    private void replace(String oldName, String newName, TLiteralExpression expression) {
        if (expression != null) {
            String text = expression.getText();
            String newText = this.replace(oldName, newName, text);
            expression.setText(newText);
        }
    }

    protected String replace(String oldName, String newName, String text) {
        return text == null ? null : text.replaceAll("\\b" + oldName + "\\b", newName);
    }

    private void removeDRGElement(TDefinitions definitions, TDRGElement drgElement) {
        TDRGElement elementToRemove = null;
        for (TDRGElement element : definitions.getDrgElement()) {
            if (element != drgElement) continue;
            elementToRemove = element;
        }
        definitions.getDrgElement().remove(elementToRemove);
    }

    private TInputData shortestName(List<TInputData> inputDataClass) {
        int minLength = Integer.MAX_VALUE;
        TInputData representative = null;
        for (TInputData inputData : inputDataClass) {
            String name = inputData.getName();
            if (name.length() >= minLength) continue;
            minLength = name.length();
            representative = inputData;
        }
        return representative;
    }

    protected boolean isIterator(TInputData inputData, DMNModelRepository repository) {
        return repository instanceof SignavioDMNModelRepository && ((SignavioDMNModelRepository)repository).isIterator(inputData);
    }

    protected abstract String equivalenceKey(TInputData var1, DMNModelRepository var2);

    protected abstract String equivalenceKey(InputParameterDefinition var1);
}

