/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMissingItemDefinitionsTransformer
extends SimpleDMNTransformer<TestLab> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractMissingItemDefinitionsTransformer.class);
    protected final BuildLogger logger;
    protected boolean transformRepository = true;

    public AbstractMissingItemDefinitionsTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    protected AbstractMissingItemDefinitionsTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    protected void addNewDefinitions(DMNModelRepository repository, List<TItemDefinition> definitions) {
        TDefinitions model = repository.getRootDefinitions();
        for (TItemDefinition definition : definitions) {
            TItemDefinition existingDefinition = repository.lookupItemDefinition(definition.getName());
            if (existingDefinition != null) {
                if (this.definitionsAreEquivalent(definition, existingDefinition)) {
                    this.logger.warn(String.format("Matching definition already exists for \"%s\"; no definition will be generated", definition.getName()));
                    continue;
                }
                throw new DMNRuntimeException(String.format("Cannot generate item definition for \"%s\"; conflicting item definition already exists", definition.getName()));
            }
            ((SignavioDMNModelRepository)repository).addItemDefinition(model, definition);
            this.logger.info(String.format("Generated new item definition for \"%s\"", definition.getName()));
        }
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.transformRepository) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    protected TItemDefinition makeItemDefinition(int definitionsCount, String name, boolean isCollection, String typeRef) {
        TItemDefinition itemDefinition = new TItemDefinition();
        itemDefinition.setId(String.format("generated-definition-%d", definitionsCount));
        itemDefinition.setName(name);
        itemDefinition.setLabel(name);
        itemDefinition.setTypeRef(new QName(typeRef));
        itemDefinition.setIsCollection(Boolean.valueOf(isCollection));
        return itemDefinition;
    }

    private boolean definitionsAreEquivalent(TItemDefinition definition1, TItemDefinition definition2) {
        if (definition1 == null) {
            return definition2 == null;
        }
        if (definition2 == null) {
            return false;
        }
        return definition1.getName().equals(definition2.getName()) && definition1.getTypeRef().equals(definition2.getTypeRef()) && definition1.isIsCollection() == definition2.isIsCollection();
    }

    protected void reportInvalidConfig(String message) {
        throw new DMNRuntimeException(String.format("Invalid transformer configuration: %s", message));
    }
}

