/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInputClause;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.transformation.config.Correction;
import com.gs.dmn.signavio.transformation.config.DecisionTableCorrection;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectPathsInDecisionsTransformer
extends SimpleDMNTransformer<TestLab> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CorrectPathsInDecisionsTransformer.class);
    private static final String CORRECTIONS_TAG = "corrections";
    private static final String CORRECTION_TAG = "correction";
    private static final String NAME_TAG = "name";
    private static final String OLD_VALUE_TAG = "oldValue";
    private static final String NEW_VALUE_TAG = "newValue";
    private static final String INPUT_INDEXES_TAG = "inputClauseIndexes";
    private static final String RULE_INDEXES_TAG = "ruleIndexes";
    protected final BuildLogger logger;
    protected boolean transformRepository = true;
    protected List<Correction> corrections;

    public CorrectPathsInDecisionsTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    protected CorrectPathsInDecisionsTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public void configure(Map<String, Object> configuration) {
        this.corrections = this.parseConfigurationForCorrections(configuration);
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("Repository is empty; transformer will not run");
            return repository;
        }
        if (this.corrections == null || this.corrections.isEmpty()) {
            this.logger.warn("No definitions provided; transformer will not run");
            return repository;
        }
        this.correctDecisions(repository, this.corrections);
        this.transformRepository = false;
        return repository;
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.transformRepository) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    private List<Correction> parseConfigurationForCorrections(Map<String, Object> configuration) {
        ArrayList<Correction> result = new ArrayList<Correction>();
        List<Object> correctionObjList = this.extractCorrectionConfigurations(configuration);
        for (Object correctionObj : correctionObjList) {
            if (!(correctionObj instanceof Map)) {
                this.reportInvalidConfig(String.format("Incorrect or missing '%s' nodes", CORRECTION_TAG));
                continue;
            }
            Map def = (Map)correctionObj;
            Object name = def.get(NAME_TAG);
            Object oldValue = def.get(OLD_VALUE_TAG);
            Object newValue = def.get(NEW_VALUE_TAG);
            Object inputClauseIndexes = def.get(INPUT_INDEXES_TAG);
            Object ruleIndexes = def.get(RULE_INDEXES_TAG);
            Correction correction = this.makeCorrection(name, oldValue, newValue, inputClauseIndexes, ruleIndexes);
            result.add(correction);
        }
        return result;
    }

    private List<Object> extractCorrectionConfigurations(Map<String, Object> configuration) {
        List correctionList = null;
        if (configuration == null) {
            this.reportInvalidConfig(String.format("Incorrect or missing '%s' node", CORRECTIONS_TAG));
        } else {
            Object correctionsObj = configuration.get(CORRECTIONS_TAG);
            if (!(correctionsObj instanceof Map)) {
                this.reportInvalidConfig(String.format("Incorrect or missing '%s' node", CORRECTIONS_TAG));
            } else {
                Object correctionObj = ((Map)correctionsObj).get(CORRECTION_TAG);
                if (correctionObj instanceof List) {
                    correctionList = (List)correctionObj;
                } else if (correctionObj instanceof Map) {
                    correctionList = Collections.singletonList(correctionObj);
                } else {
                    this.reportInvalidConfig(String.format("Incorrect or missing '%s' nodes", CORRECTION_TAG));
                }
            }
        }
        return correctionList;
    }

    private Correction makeCorrection(Object name, Object oldValue, Object newValue, Object inputClauseIndexes, Object ruleIndexes) {
        DecisionTableCorrection correction = null;
        if (!(name instanceof String && oldValue instanceof String && newValue instanceof String)) {
            this.reportInvalidConfig(String.format("Incorrect fields in '%s' node", CORRECTION_TAG));
        } else {
            List<Integer> inputIndexesList = this.makeIndexList(inputClauseIndexes);
            List<Integer> ruleIndexesList = this.makeIndexList(ruleIndexes);
            correction = new DecisionTableCorrection((String)name, (String)oldValue, (String)newValue, inputIndexesList, ruleIndexesList);
        }
        return correction;
    }

    private List<Integer> makeIndexList(Object object) {
        if (object == null) {
            return new ArrayList<Integer>();
        }
        if (object instanceof String) {
            if (((String)object).isEmpty()) {
                return new ArrayList<Integer>();
            }
            return Arrays.stream(((String)object).split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        this.reportInvalidConfig(String.format("Unexpected comma separated list of indexes '%s'", object));
        return new ArrayList<Integer>();
    }

    private void correctDecisions(DMNModelRepository repository, List<Correction> corrections) {
        for (Correction cor : corrections) {
            String drgName = cor.getDrgName();
            TDRGElement drgElement = repository.findDRGElementByName(drgName);
            if (drgElement instanceof TDecision) {
                this.correctDecision((TDecision)drgElement, cor, repository);
                continue;
            }
            this.reportInvalidConfig(String.format("Cannot find decision '%s'", drgName));
        }
    }

    private void correctDecision(TDecision decision, Correction cor, DMNModelRepository repository) {
        TExpression expression = repository.expression((TDRGElement)decision);
        if (cor instanceof DecisionTableCorrection && expression instanceof TDecisionTable) {
            DecisionTableCorrection dtc = (DecisionTableCorrection)cor;
            String oldValue = dtc.getOldValue();
            String newValue = dtc.getNewValue();
            List<Integer> inputIndexes = dtc.getInputIndexes();
            List<Integer> ruleIndexes = dtc.getRuleIndexes();
            TDecisionTable dte = (TDecisionTable)expression;
            boolean correctAll = inputIndexes.isEmpty() && ruleIndexes.isEmpty();
            this.correctInputClauses(decision, oldValue, newValue, inputIndexes, correctAll, dte);
            this.correctRules(decision, oldValue, newValue, ruleIndexes, correctAll, dte);
        } else {
            this.reportInvalidConfig(String.format("Correction '%s' is not supported for decision '%s' yet", cor, decision));
        }
    }

    private void correctRules(TDecision decision, String oldValue, String newValue, List<Integer> ruleIndexes, boolean correctAll, TDecisionTable dte) {
        List ruleList = dte.getRule();
        for (int i = 0; i < ruleList.size(); ++i) {
            if (!correctAll && !ruleIndexes.contains(i + 1)) continue;
            TDecisionRule rule = (TDecisionRule)ruleList.get(i);
            for (TLiteralExpression outputEntry : rule.getOutputEntry()) {
                this.updateLiteralExpression(outputEntry, oldValue, newValue, decision);
            }
        }
    }

    private void correctInputClauses(TDecision decision, String oldValue, String newValue, List<Integer> inputIndexes, boolean correctAll, TDecisionTable dte) {
        List inputList = dte.getInput();
        for (int i = 0; i < inputList.size(); ++i) {
            if (!correctAll && !inputIndexes.contains(i + 1)) continue;
            TInputClause inputClause = (TInputClause)inputList.get(i);
            this.updateLiteralExpression(inputClause.getInputExpression(), oldValue, newValue, decision);
        }
    }

    private void updateLiteralExpression(TLiteralExpression expression, String oldValue, String newValue, TDecision decision) {
        String oldText = expression.getText();
        String newText = oldText.replace(oldValue, newValue);
        this.logger.info(String.format("Replacing expression '%s' with '%s' in decision '%s'", oldText, newText, decision.getName()));
        expression.setText(newText);
    }

    protected void reportInvalidConfig(String message) {
        throw new DMNRuntimeException(String.format("Invalid transformer configuration: %s", message));
    }
}

