/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.DRGElementReference;
import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDMNElementReference;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TImport;
import com.gs.dmn.ast.TInformationRequirement;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TKnowledgeRequirement;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.ast.TUnaryTests;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.metadata.BKM;
import com.gs.dmn.runtime.metadata.CompositeType;
import com.gs.dmn.runtime.metadata.DMNMetadata;
import com.gs.dmn.runtime.metadata.DRGElement;
import com.gs.dmn.runtime.metadata.Decision;
import com.gs.dmn.runtime.metadata.ExtensionElement;
import com.gs.dmn.runtime.metadata.InputData;
import com.gs.dmn.runtime.metadata.Type;
import com.gs.dmn.runtime.metadata.TypeReference;
import com.gs.dmn.serialization.DMNVersion;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.transformation.basic.BasicSignavioDMNToJavaTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;

public class DMNToManifestTransformer {
    private final BasicDMNToNativeTransformer<com.gs.dmn.el.analysis.semantics.type.Type, DMNContext> dmnTransformer;
    private final DMNModelRepository dmnModelRepository;

    public DMNToManifestTransformer(BasicDMNToNativeTransformer<com.gs.dmn.el.analysis.semantics.type.Type, DMNContext> dmnTransformer) {
        this.dmnModelRepository = dmnTransformer.getDMNModelRepository();
        this.dmnTransformer = dmnTransformer;
    }

    public DMNMetadata toManifest(String dmnNamespace, String nativeNamespace, String dmnVersion, String modelVersion, String platformVersion) {
        DMNMetadata manifest = new DMNMetadata(dmnNamespace, nativeNamespace, dmnVersion, modelVersion, platformVersion);
        for (TDefinitions definitions : this.dmnModelRepository.getAllDefinitions()) {
            InputData element;
            for (TItemDefinition itemDefinition : this.dmnModelRepository.findItemDefinitions(definitions)) {
                Type type = this.makeMetadataType(definitions, itemDefinition);
                manifest.addType(type);
            }
            for (TInputData inputData : this.dmnModelRepository.findInputDatas(definitions)) {
                element = this.makeMetadataInputData(definitions, inputData);
                manifest.addElement((DRGElement)element);
            }
            for (TBusinessKnowledgeModel bkm : this.dmnModelRepository.findBKMs(definitions)) {
                element = this.makeMetadataBKM(definitions, bkm);
                manifest.addElement((DRGElement)element);
            }
            for (TDecision decision : this.dmnModelRepository.findDecisions(definitions)) {
                element = this.makeMetadataDecision(definitions, decision);
                manifest.addElement((DRGElement)element);
            }
        }
        return manifest;
    }

    private Type makeMetadataType(TDefinitions model, TItemDefinition itemDefinition) {
        TypeReference type;
        String id = itemDefinition.getId();
        String name = itemDefinition.getName();
        String label = itemDefinition.getLabel();
        boolean isCollection = itemDefinition.isIsCollection();
        com.gs.dmn.runtime.metadata.QName typeRef = this.makeMetadataTypeRef(model, QualifiedName.toQualifiedName((TDefinitions)model, (QName)itemDefinition.getTypeRef()));
        String allowedValues = this.makeMetadataAllowedValues(itemDefinition.getAllowedValues());
        List children = itemDefinition.getItemComponent();
        if (children == null || children.isEmpty()) {
            type = new TypeReference(id, name, label, isCollection, typeRef, allowedValues);
        } else {
            ArrayList<Type> subTypes = new ArrayList<Type>();
            for (TItemDefinition child : children) {
                subTypes.add(this.makeMetadataType(model, child));
            }
            type = new CompositeType(id, name, label, isCollection, subTypes);
        }
        return type;
    }

    private com.gs.dmn.runtime.metadata.QName makeMetadataTypeRef(TDefinitions model, QualifiedName typeRef) {
        if (this.dmnModelRepository.isNull(typeRef)) {
            return null;
        }
        String importName = typeRef.getNamespace();
        String namespace = this.findNamespace(model, importName);
        return new com.gs.dmn.runtime.metadata.QName(namespace, typeRef.getLocalPart());
    }

    private String makeMetadataAllowedValues(TUnaryTests allowedValues) {
        return allowedValues == null ? null : allowedValues.getText();
    }

    private String findNamespace(TDefinitions model, String importName) {
        if (DMNVersion.DMN_11.getFeelPrefix().equals(importName)) {
            return DMNVersion.DMN_11.getFeelNamespace();
        }
        for (TImport import_ : model.getImport()) {
            if (!import_.getName().equals(importName) || (model = this.dmnModelRepository.getModel(import_.getNamespace())) != null) continue;
            throw new DMNRuntimeException(String.format("Cannot find model for import name '%s'", importName));
        }
        return model.getNamespace();
    }

    private InputData makeMetadataInputData(DRGElementReference<TInputData> reference) {
        TInputData inputData = (TInputData)reference.getElement();
        TDefinitions definitions = this.dmnModelRepository.getModel((TNamedElement)inputData);
        return this.makeMetadataInputData(definitions, inputData);
    }

    private InputData makeMetadataInputData(TDefinitions definitions, TInputData inputData) {
        String id = inputData.getId();
        String name = inputData.getName();
        String label = inputData.getLabel();
        String diagramId = ((SignavioDMNModelRepository)this.dmnModelRepository).getDiagramId((TDMNElement)inputData);
        String shapeId = ((SignavioDMNModelRepository)this.dmnModelRepository).getShapeId((TDRGElement)inputData);
        String javaParameterName = this.dmnTransformer.namedElementVariableName((TNamedElement)inputData);
        String javaTypeName = this.dmnTransformer.drgElementOutputType((TDRGElement)inputData);
        com.gs.dmn.runtime.metadata.QName typeRef = this.makeMetadataTypeRef(definitions, QualifiedName.toQualifiedName((TDefinitions)definitions, (QName)inputData.getVariable().getTypeRef()));
        return new InputData(id, name, label, diagramId, shapeId, javaParameterName, javaTypeName, typeRef);
    }

    private BKM makeMetadataBKM(TDefinitions definitions, TBusinessKnowledgeModel bkm) {
        String id = bkm.getId();
        String name = bkm.getName();
        String label = bkm.getLabel();
        String diagramId = ((SignavioDMNModelRepository)this.dmnModelRepository).getDiagramId((TDMNElement)bkm);
        String shapeId = ((SignavioDMNModelRepository)this.dmnModelRepository).getShapeId((TDRGElement)bkm);
        String javaParameterName = this.dmnTransformer.namedElementVariableName((TNamedElement)bkm);
        String javaTypeName = this.dmnTransformer.qualifiedName(this.dmnTransformer.nativeModelPackageName(definitions.getName()), this.dmnTransformer.drgElementClassName((TDRGElement)bkm));
        String javaOutputTypeName = this.dmnTransformer.drgElementOutputType((TDRGElement)bkm);
        com.gs.dmn.runtime.metadata.QName typeRef = this.makeMetadataTypeRef(definitions, this.dmnTransformer.drgElementOutputTypeRef((TDRGElement)bkm));
        List<com.gs.dmn.runtime.metadata.DRGElementReference> knowledgeReferences = this.makeMetadataKnowledgeReferences(bkm.getKnowledgeRequirement());
        return new BKM(id, name, label, diagramId, shapeId, javaParameterName, javaTypeName, javaOutputTypeName, typeRef, knowledgeReferences);
    }

    private Decision makeMetadataDecision(TDefinitions definitions, TDecision decision) {
        String id = decision.getId();
        String diagramId = ((SignavioDMNModelRepository)this.dmnModelRepository).getDiagramId((TDMNElement)decision);
        String shapeId = ((SignavioDMNModelRepository)this.dmnModelRepository).getShapeId((TDRGElement)decision);
        String name = decision.getName();
        String label = decision.getLabel();
        String nativeParameterName = this.dmnTransformer.namedElementVariableName((TNamedElement)decision);
        String nativeTypeName = this.dmnTransformer.qualifiedName(this.dmnTransformer.nativeModelPackageName(definitions.getName()), this.dmnTransformer.drgElementClassName((TDRGElement)decision));
        String nativeOutputTypeName = this.dmnTransformer.drgElementOutputType((TDRGElement)decision);
        com.gs.dmn.runtime.metadata.QName typeRef = this.makeMetadataTypeRef(definitions, QualifiedName.toQualifiedName((TDefinitions)definitions, (QName)decision.getVariable().getTypeRef()));
        List<com.gs.dmn.runtime.metadata.DRGElementReference> references = this.makeMetadataInformationReferences(decision);
        List<com.gs.dmn.runtime.metadata.DRGElementReference> knowledgeReferences = this.makeMetadataKnowledgeReferences(decision.getKnowledgeRequirement());
        List<ExtensionElement> extensions = ((BasicSignavioDMNToJavaTransformer)this.dmnTransformer).makeMetadataExtensions(decision);
        List<InputData> transitiveRequiredInputs = this.makeTransitiveRequiredInputs(decision);
        String protoRequestName = this.dmnTransformer.qualifiedRequestMessageName((TDRGElement)decision);
        String protoResponseName = this.dmnTransformer.qualifiedResponseMessageName((TDRGElement)decision);
        return new Decision(id, name, label, diagramId, shapeId, nativeParameterName, nativeTypeName, nativeOutputTypeName, typeRef, references, knowledgeReferences, extensions, transitiveRequiredInputs, protoRequestName, protoResponseName);
    }

    private List<com.gs.dmn.runtime.metadata.DRGElementReference> makeMetadataKnowledgeReferences(List<TKnowledgeRequirement> knowledgeRequirementList) {
        ArrayList<com.gs.dmn.runtime.metadata.DRGElementReference> references = new ArrayList<com.gs.dmn.runtime.metadata.DRGElementReference>();
        for (TKnowledgeRequirement knowledgeRequirement : knowledgeRequirementList) {
            this.addMetadataReference(references, knowledgeRequirement.getRequiredKnowledge());
            this.addMetadataReference(references, knowledgeRequirement.getRequiredKnowledge());
        }
        return references;
    }

    private List<com.gs.dmn.runtime.metadata.DRGElementReference> makeMetadataInformationReferences(TDecision decision) {
        ArrayList<com.gs.dmn.runtime.metadata.DRGElementReference> references = new ArrayList<com.gs.dmn.runtime.metadata.DRGElementReference>();
        List informationRequirementList = decision.getInformationRequirement();
        for (TInformationRequirement informationRequirement : informationRequirementList) {
            this.addMetadataReference(references, informationRequirement.getRequiredInput());
            this.addMetadataReference(references, informationRequirement.getRequiredDecision());
        }
        return references;
    }

    private List<InputData> makeTransitiveRequiredInputs(TDecision element) {
        DRGElementReference reference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)element);
        List drgElementReferences = this.dmnTransformer.inputDataClosure(reference);
        return drgElementReferences.stream().map(this::makeMetadataInputData).collect(Collectors.toList());
    }

    private void addMetadataReference(List<com.gs.dmn.runtime.metadata.DRGElementReference> references, TDMNElementReference elementReference) {
        String href;
        if (elementReference != null && (href = this.cleanMetadataReference(elementReference.getHref())) != null) {
            references.add(new com.gs.dmn.runtime.metadata.DRGElementReference(href));
        }
    }

    private String cleanMetadataReference(String href) {
        return href.startsWith("#") ? href.substring(1) : href;
    }
}

