/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.signavio.transformation.AbstractMissingItemDefinitionsTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GenerateMissingItemDefinitionsTransformer
extends AbstractMissingItemDefinitionsTransformer {
    private static final String ELEMENT_DEFINITIONS = "definitions";
    private static final String ELEMENT_DEFINITION = "definition";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_COLLECTION = "isCollection";
    private List<TItemDefinition> definitions;

    public GenerateMissingItemDefinitionsTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public GenerateMissingItemDefinitionsTransformer(BuildLogger logger) {
        super(logger);
    }

    public void configure(Map<String, Object> configuration) {
        this.definitions = this.parseConfigurationForDefinitions(configuration);
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("Repository is empty; transformer will not run");
            return repository;
        }
        if (this.definitions == null || this.definitions.isEmpty()) {
            this.logger.warn("No definitions provided; transformer will not run");
            return repository;
        }
        this.addNewDefinitions(repository, this.definitions);
        this.transformRepository = false;
        return repository;
    }

    private List<TItemDefinition> parseConfigurationForDefinitions(Map<String, Object> configuration) {
        ArrayList<TItemDefinition> result = new ArrayList<TItemDefinition>();
        List<Object> definitionList = this.extractDefinitionConfigurations(configuration);
        for (Object definitionObj : definitionList) {
            if (!(definitionObj instanceof Map)) {
                this.reportInvalidConfig("Definition entry does not have expected structure");
                continue;
            }
            Map def = (Map)definitionObj;
            Object name = def.get(FIELD_NAME);
            Object type = def.get(FIELD_TYPE);
            Object isCollection = def.get(FIELD_COLLECTION);
            if (!(name instanceof String) || !(type instanceof String)) {
                this.reportInvalidConfig("Definition entry does not contain mandatory fields");
                continue;
            }
            String typeRef = ((String)type).replace(':', '.');
            TItemDefinition itemDefinition = this.makeItemDefinition(result.size(), (String)name, Boolean.parseBoolean((String)isCollection), typeRef);
            result.add(itemDefinition);
        }
        return result;
    }

    private List<Object> extractDefinitionConfigurations(Map<String, Object> configuration) {
        List definitionList = null;
        if (configuration == null) {
            this.reportInvalidConfig("No configuration provided");
        } else {
            Object definitionsNode = configuration.get(ELEMENT_DEFINITIONS);
            if (!(definitionsNode instanceof Map)) {
                this.reportInvalidConfig(String.format("Configuration does not have expected structure (expecting \"%s\" node)", ELEMENT_DEFINITIONS));
            } else {
                Object definitionConfig = ((Map)definitionsNode).get(ELEMENT_DEFINITION);
                if (definitionConfig instanceof List) {
                    definitionList = (List)definitionConfig;
                } else if (definitionConfig instanceof Map) {
                    definitionList = Collections.singletonList(definitionConfig);
                } else {
                    this.reportInvalidConfig(String.format("Configuration does not have expected structure (expecting list of \"%s\" nodes)", ELEMENT_DEFINITION));
                }
            }
        }
        return definitionList;
    }
}

