/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.analysis.semantics.type.DataType;
import com.gs.dmn.feel.analysis.semantics.type.ListType;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.dialect.SignavioDMNDialectDefinition;
import com.gs.dmn.signavio.transformation.AbstractMissingItemDefinitionsTransformer;
import com.gs.dmn.validation.TypeRefValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class InferMissingItemDefinitionsTransformer
extends AbstractMissingItemDefinitionsTransformer {
    static final String DMN_DIALECT_NAME = "dmnDialect";
    private TypeRefValidator typeRefValidator;
    private DMNDialectDefinition<?, ?, ?, ?, ?, ?> dmnDialect;

    public InferMissingItemDefinitionsTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public InferMissingItemDefinitionsTransformer(BuildLogger logger) {
        super(logger);
    }

    public void configure(Map<String, Object> configuration) {
        this.parseConfigurationForDialect(configuration);
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        this.inferAndAddMissingDefinitions(repository);
        return repository;
    }

    private void inferAndAddMissingDefinitions(DMNModelRepository repository) {
        ArrayList<TDRGElement> resolvedElements = new ArrayList<TDRGElement>();
        int idSequence = 0;
        int iteration = 0;
        ArrayList<TItemDefinition> itemDefinitionsToAdd = new ArrayList<TItemDefinition>();
        do {
            this.logger.debug(String.format("Iteration: %d", iteration));
            itemDefinitionsToAdd.clear();
            List errorReport = this.typeRefValidator.makeErrorReport(repository);
            for (Pair pair : errorReport) {
                TDRGElement element = (TDRGElement)pair.getLeft();
                Type type = (Type)pair.getRight();
                if (Type.isNull((Type)type)) continue;
                if (this.isPrimitive(type) || this.isListOfPrimitive(type)) {
                    if (resolvedElements.contains(element)) continue;
                    String name = QualifiedName.toName((QName)repository.variable((TNamedElement)element).getTypeRef());
                    boolean isCollection = type instanceof ListType;
                    String typeRef = this.getTypeRef(type);
                    TItemDefinition itemDefinition = this.makeItemDefinition(idSequence, name, isCollection, typeRef);
                    ++idSequence;
                    itemDefinitionsToAdd.add(itemDefinition);
                    resolvedElements.add(element);
                    continue;
                }
                throw new DMNRuntimeException(String.format("Cannot infer type for '%s'. '%s' is not supported yet", element.getName(), type));
            }
            this.addNewDefinitions(repository, itemDefinitionsToAdd);
            ++iteration;
        } while (!itemDefinitionsToAdd.isEmpty());
    }

    private boolean isPrimitive(Type type) {
        return type instanceof DataType;
    }

    private boolean isListOfPrimitive(Type type) {
        return type instanceof ListType && this.isPrimitive(((ListType)type).getElementType());
    }

    private String getTypeRef(Type type) {
        if (this.isPrimitive(type)) {
            return ((DataType)type).getName();
        }
        if (this.isListOfPrimitive(type)) {
            return this.getTypeRef(((ListType)type).getElementType());
        }
        throw new DMNRuntimeException(String.format("'%s' is not supported yet", type));
    }

    private void parseConfigurationForDialect(Map<String, Object> configuration) {
        String dialectClassName = SignavioDMNDialectDefinition.class.getName();
        if (configuration != null && configuration.size() != 0) {
            Object dialectNode = configuration.get(DMN_DIALECT_NAME);
            if (dialectNode == null || configuration.values().size() != 1) {
                this.reportInvalidConfig(String.format("Configuration does not have expected structure (expecting only '%s' node)", DMN_DIALECT_NAME));
            } else if (dialectNode instanceof String) {
                dialectClassName = (String)dialectNode;
            } else {
                this.reportInvalidConfig(String.format("'%s' should be a string", DMN_DIALECT_NAME));
            }
        }
        try {
            Object object = Class.forName(dialectClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (object instanceof DMNDialectDefinition) {
                DMNDialectDefinition dmnDialect;
                this.dmnDialect = dmnDialect = (DMNDialectDefinition)object;
                this.typeRefValidator = new TypeRefValidator(this.dmnDialect);
            } else {
                this.reportInvalidConfig(String.format("Incorrect DMN dialect name '%s'", dialectClassName));
            }
        }
        catch (Exception e) {
            this.reportInvalidConfig(String.format("Incorrect DMN dialect name '%s'", dialectClassName));
        }
    }
}

