/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInputClause;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TOutputClause;
import com.gs.dmn.ast.TUnaryTests;
import com.gs.dmn.feel.analysis.syntax.antlrv4.FEELLexer;
import com.gs.dmn.feel.lib.MixedJavaTimeFEELLib;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizeDateTimeLiteralsTransformer
extends SimpleDMNTransformer<TestLab> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizeDateTimeLiteralsTransformer.class);
    private final BuildLogger logger;
    private boolean transformRepository = true;
    private MixedJavaTimeFEELLib feelLib = new MixedJavaTimeFEELLib();

    public NormalizeDateTimeLiteralsTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public NormalizeDateTimeLiteralsTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        for (TDefinitions definitions : repository.getAllDefinitions()) {
            for (TDecision decision : repository.findDecisions(definitions)) {
                TExpression expression = repository.expression((TDRGElement)decision);
                if (expression instanceof TDecisionTable) {
                    this.logger.debug(String.format("Process decision table in decision '%s'", decision.getName()));
                    this.transform((TDecisionTable)expression);
                    continue;
                }
                if (!(expression instanceof TLiteralExpression)) continue;
                this.logger.debug(String.format("Process literal expression in decision '%s'", decision.getName()));
                this.transform((TLiteralExpression)expression);
            }
        }
        this.transformRepository = false;
        return repository;
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test cases list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.transformRepository) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    private void transform(TLiteralExpression literalExpression) {
        this.normalize(literalExpression);
    }

    private void transform(TDecisionTable decisionTable) {
        for (TInputClause input : decisionTable.getInput()) {
            if (input == null) continue;
            this.normalize(input.getInputExpression());
        }
        for (TOutputClause output : decisionTable.getOutput()) {
            if (output == null) continue;
            this.normalize(output.getOutputValues());
            this.normalize(output.getDefaultOutputEntry());
        }
        for (TDecisionRule rule : decisionTable.getRule()) {
            for (TUnaryTests test : rule.getInputEntry()) {
                this.normalize(test);
            }
            for (TLiteralExpression exp : rule.getOutputEntry()) {
                this.normalize(exp);
            }
        }
    }

    private void normalize(TLiteralExpression exp) {
        if (exp != null) {
            String newText = this.normalize(exp.getText());
            exp.setText(newText);
        }
    }

    private void normalize(TUnaryTests test) {
        if (test != null) {
            String newText = this.normalize(test.getText());
            test.setText(newText);
        }
    }

    String normalize(String text) {
        Token token;
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        Lexer lexer = this.makeLexer(text);
        ArrayList<Token> tokens = new ArrayList<Token>();
        do {
            token = lexer.nextToken();
            tokens.add(token);
        } while (token.getType() != -1);
        if (!this.containsDateTimeLiterals(tokens)) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        int size = tokens.size();
        int i = 0;
        while (i < size - 1) {
            token = (Token)tokens.get(i);
            String tokenText = token.getText();
            if (this.isDateTimeLiteralStart(i, tokens)) {
                int textIndex = i + 2;
                if (textIndex < size && ((Token)tokens.get(textIndex)).getType() == 4) {
                    newText.append(((Token)tokens.get(i)).getText());
                    newText.append("(");
                    String newTokenText = this.normalizeLiteral(tokenText, ((Token)tokens.get(textIndex)).getText());
                    newText.append(newTokenText);
                    newText.append(")");
                    i += 4;
                } else {
                    newText.append(tokenText);
                    ++i;
                }
            } else {
                newText.append(tokenText);
                ++i;
            }
            newText.append(" ");
        }
        return newText.toString().trim();
    }

    private boolean containsDateTimeLiterals(List<Token> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            if (!this.isDateTimeLiteralStart(i, tokens)) continue;
            return true;
        }
        return false;
    }

    private boolean isDateTimeLiteralStart(int index, List<Token> tokens) {
        if (!this.isToken(index, tokens, 48) || !tokens.get(index).getText().equals("date and time") && !tokens.get(index).getText().equals("time")) {
            return false;
        }
        if (!this.isToken(index + 1, tokens, 21)) {
            return false;
        }
        if (!this.isToken(index + 2, tokens, 4)) {
            return false;
        }
        return this.isToken(index + 3, tokens, 22);
    }

    private boolean isToken(int index, List<Token> tokens, int kind) {
        return index < tokens.size() && tokens.get(index).getType() == kind;
    }

    private String normalizeLiteral(String feelFunctionName, String literalText) {
        try {
            String rawText = literalText.replaceAll("\"", "");
            Comparable<ChronoZonedDateTime<?>> temporal = "date and time".equals(feelFunctionName) ? ((ZonedDateTime)this.feelLib.dateAndTime(rawText)).withZoneSameInstant(ZoneOffset.UTC) : ((OffsetTime)this.feelLib.time(rawText)).withOffsetSameInstant(ZoneOffset.UTC);
            return String.format("\"%s\"", this.feelLib.string((Object)temporal));
        }
        catch (Exception e) {
            return literalText;
        }
    }

    private Lexer makeLexer(String text) {
        CodePointCharStream cs = CharStreams.fromString((String)text);
        return new FEELLexer((CharStream)cs);
    }
}

