/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleDescriptionTransformer
extends SimpleDMNTransformer<TestLab> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleDescriptionTransformer.class);
    private static final Map<String, String> PATTERNS = new LinkedHashMap<String, String>();
    private final BuildLogger logger;
    private Map<String, Pair<TInputData, List<TInputData>>> inputDataClasses;

    public RuleDescriptionTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public RuleDescriptionTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        this.inputDataClasses = new LinkedHashMap<String, Pair<TInputData, List<TInputData>>>();
        return this.cleanRuleDescription(repository, this.logger);
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test cases list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.inputDataClasses == null) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    private DMNModelRepository cleanRuleDescription(DMNModelRepository repository, BuildLogger logger) {
        for (TDefinitions definitions : repository.getAllDefinitions()) {
            for (TDecision decision : repository.findDecisions(definitions)) {
                TExpression expression = repository.expression((TDRGElement)decision);
                if (!(expression instanceof TDecisionTable)) continue;
                logger.debug(String.format("Cleaning descriptions for '%s'", decision.getName()));
                List rules = ((TDecisionTable)expression).getRule();
                for (TDecisionRule rule : rules) {
                    this.cleanRuleDescription(rule);
                }
            }
        }
        return repository;
    }

    void cleanRuleDescription(TDecisionRule rule) {
        String description = rule.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            for (Map.Entry<String, String> entry : PATTERNS.entrySet()) {
                description = description.replace(entry.getKey(), entry.getValue());
            }
            rule.setDescription(description);
        }
    }

    static {
        PATTERNS.put("[ ,", "[");
        PATTERNS.put(",  ,", ",");
        PATTERNS.put(", ]", "]");
        PATTERNS.put("string(-)", "\"\"");
        PATTERNS.put("\u00a0", " ");
    }
}

