/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.metadata.DMNMetadata;
import com.gs.dmn.serialization.DMNSerializer;
import com.gs.dmn.serialization.JsonSerializer;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.signavio.transformation.DMNToManifestTransformer;
import com.gs.dmn.transformation.AbstractDMNToNativeTransformer;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.DMNValidator;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;

public class SignavioDMNToJavaTransformer<NUMBER, DATE, TIME, DATE_TIME, DURATION>
extends AbstractDMNToNativeTransformer<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestLab> {
    private static final String DMN_METADATA_FILE_NAME = "DMNMetadata";
    private final String schemaNamespace;

    public SignavioDMNToJavaTransformer(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestLab> dialectDefinition, DMNValidator dmnValidator, DMNTransformer<TestLab> dmnTransformer, TemplateProvider templateProvider, LazyEvaluationDetector lazyEvaluationDetector, TypeDeserializationConfigurer typeDeserializationConfigurer, InputParameters inputParameters, BuildLogger logger) {
        super(dialectDefinition, dmnValidator, dmnTransformer, templateProvider, lazyEvaluationDetector, typeDeserializationConfigurer, inputParameters, logger);
        String schemaNamespace = inputParameters.getSchemaNamespace();
        this.schemaNamespace = StringUtils.isBlank((CharSequence)schemaNamespace) ? "http://www.signavio.com/schema/dmn/1.1/" : schemaNamespace;
    }

    protected String getFileExtension() {
        return ".java";
    }

    protected DMNModelRepository readModels(File file) {
        if (DMNSerializer.isDMNFile((File)file)) {
            TDefinitions result = this.dmnSerializer.readModel(file);
            SignavioDMNModelRepository repository = new SignavioDMNModelRepository(result, this.schemaNamespace);
            return repository;
        }
        throw new DMNRuntimeException(String.format("Invalid DMN file %s", file.getAbsoluteFile()));
    }

    protected void transform(BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer, DMNModelRepository dmnModelRepository, Path outputPath) {
        super.transform(dmnTransformer, dmnModelRepository, outputPath);
        this.processManifest(dmnTransformer, DMN_METADATA_FILE_NAME, outputPath);
    }

    private void processManifest(BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer, String jsonFileName, Path outputPath) {
        String javaPackageName = dmnTransformer.nativeRootPackageName();
        String filePath = javaPackageName.replace('.', '/');
        String fileExtension = ".json";
        try {
            DMNToManifestTransformer dmnToManifestTransformer = new DMNToManifestTransformer(dmnTransformer);
            String dmnNamespace = dmnTransformer.getDMNModelRepository().getRootDefinitions().getNamespace();
            String nativeNamespace = dmnTransformer.nativeRootPackageName();
            String dmnVersion = this.inputParameters.getDmnVersion();
            String modelVersion = this.inputParameters.getModelVersion();
            String platformVersion = this.inputParameters.getPlatformVersion();
            DMNMetadata manifest = dmnToManifestTransformer.toManifest(dmnNamespace, nativeNamespace, dmnVersion, modelVersion, platformVersion);
            File resultFile = this.makeOutputFile(outputPath, filePath, jsonFileName, fileExtension);
            JsonSerializer.OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValue(resultFile, (Object)manifest);
        }
        catch (Exception e) {
            throw new DMNRuntimeException("Cannot process manifest file", (Throwable)e);
        }
    }
}

