/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.feel.analysis.semantics.type.ListType;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.dialect.SignavioDMNDialectDefinition;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToJavaTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.lazy.NopLazyEvaluationDetector;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifyTypesForMIDTransformer
extends SimpleDMNTransformer<TestLab> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifyTypesForMIDTransformer.class);
    private static final DMNDialectDefinition<?, ?, ?, ?, ?, ?> SIGNAVIO_DIALECT = new SignavioDMNDialectDefinition();
    private final BuildLogger logger;
    private Map<String, Pair<TInputData, List<TInputData>>> inputDataClasses;

    public SimplifyTypesForMIDTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public SimplifyTypesForMIDTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        this.inputDataClasses = new LinkedHashMap<String, Pair<TInputData, List<TInputData>>>();
        return this.removeDuplicateInformationRequirements(repository, this.logger);
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test cases list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.inputDataClasses == null) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    private DMNModelRepository removeDuplicateInformationRequirements(DMNModelRepository repository, BuildLogger logger) {
        SignavioDMNModelRepository signavioRepository;
        BasicDMNToJavaTransformer basicTransformer = SIGNAVIO_DIALECT.createBasicTransformer(repository, (LazyEvaluationDetector)new NopLazyEvaluationDetector(), this.makeInputParameters());
        if (repository instanceof SignavioDMNModelRepository) {
            signavioRepository = (SignavioDMNModelRepository)repository;
        } else {
            TDefinitions definitions = repository.getRootDefinitions();
            signavioRepository = new SignavioDMNModelRepository(definitions);
        }
        for (TDefinitions definitions : signavioRepository.getAllDefinitions()) {
            for (TDecision decision : signavioRepository.findDecisions(definitions)) {
                Type midElementType;
                TDefinitions decisionModel = repository.getModel((TNamedElement)decision);
                if (!signavioRepository.isMultiInstanceDecision((TDRGElement)decision)) continue;
                MultiInstanceDecisionLogic midLogic = signavioRepository.getExtension().multiInstanceDecisionLogic((TDRGElement)decision);
                TDecision bodyDecision = midLogic.getTopLevelDecision();
                TDefinitions bodyDecisionModel = repository.getModel((TNamedElement)bodyDecision);
                QualifiedName midDecisionTypeRef = signavioRepository.outputTypeRef(decisionModel, (TDRGElement)decision);
                QualifiedName bodyDecisionTypeRef = signavioRepository.outputTypeRef(bodyDecisionModel, (TDRGElement)bodyDecision);
                Type midType = basicTransformer.toFEELType(decisionModel, midDecisionTypeRef);
                Type bodyDecisionType = basicTransformer.toFEELType(bodyDecisionModel, bodyDecisionTypeRef);
                if (!(midType instanceof ListType) || !Type.equivalentTo((Type)(midElementType = ((ListType)midType).getElementType()), (Type)bodyDecisionType) || !basicTransformer.isComplexType(bodyDecisionType)) continue;
                TItemDefinition midItemDefinitionType = signavioRepository.lookupItemDefinition(decisionModel, midDecisionTypeRef);
                String importName = bodyDecisionTypeRef.getNamespace();
                if (StringUtils.isEmpty((CharSequence)importName)) {
                    midItemDefinitionType.setTypeRef(new QName(String.format("%s", bodyDecisionTypeRef.getLocalPart())));
                } else {
                    midItemDefinitionType.setTypeRef(new QName(String.format("%s.%s", importName, bodyDecisionTypeRef.getLocalPart())));
                }
                midItemDefinitionType.getItemComponent().clear();
            }
        }
        return repository;
    }

    private InputParameters makeInputParameters() {
        return new InputParameters(new LinkedHashMap());
    }
}

