/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDMNElementReference;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TInformationRequirement;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.signavio.testlab.TestLab;
import com.gs.dmn.transformation.SimpleDMNTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueInformationRequirementTransformer
extends SimpleDMNTransformer<TestLab> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueInformationRequirementTransformer.class);
    private final BuildLogger logger;
    private Map<String, Pair<TInputData, List<TInputData>>> inputDataClasses;

    public UniqueInformationRequirementTransformer() {
        this((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public UniqueInformationRequirementTransformer(BuildLogger logger) {
        this.logger = logger;
    }

    public DMNModelRepository transform(DMNModelRepository repository) {
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; transformer will not run");
            return repository;
        }
        this.inputDataClasses = new LinkedHashMap<String, Pair<TInputData, List<TInputData>>>();
        return this.removeDuplicateInformationRequirements(repository, this.logger);
    }

    public Pair<DMNModelRepository, List<TestLab>> transform(DMNModelRepository repository, List<TestLab> testCasesList) {
        if (this.isEmpty(repository, testCasesList)) {
            this.logger.warn("DMN repository or test cases list is empty; transformer will not run");
            return new Pair((Object)repository, testCasesList);
        }
        if (this.inputDataClasses == null) {
            this.transform(repository);
        }
        return new Pair((Object)repository, testCasesList);
    }

    private DMNModelRepository removeDuplicateInformationRequirements(DMNModelRepository repository, BuildLogger logger) {
        for (TDefinitions definitions : repository.getAllDefinitions()) {
            for (TDecision decision : repository.findDecisions(definitions)) {
                ArrayList<String> hrefs = new ArrayList<String>();
                ArrayList<TInformationRequirement> newList = new ArrayList<TInformationRequirement>();
                for (TInformationRequirement ir : decision.getInformationRequirement()) {
                    String href = null;
                    TDMNElementReference requiredInput = ir.getRequiredInput();
                    TDMNElementReference requiredDecision = ir.getRequiredDecision();
                    if (requiredInput != null) {
                        href = requiredInput.getHref();
                    }
                    if (requiredDecision != null) {
                        href = requiredDecision.getHref();
                    }
                    if (hrefs.contains(href)) continue;
                    newList.add(ir);
                    hrefs.add(href);
                }
                decision.getInformationRequirement().clear();
                decision.getInformationRequirement().addAll(newList);
            }
        }
        return repository;
    }
}

