/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation.basic;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.DRGElementReference;
import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TFunctionDefinition;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.ast.TOutputClause;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.context.environment.EnvironmentFactory;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.el.analysis.syntax.ast.expression.Expression;
import com.gs.dmn.feel.analysis.semantics.type.FEELFunctionType;
import com.gs.dmn.feel.analysis.syntax.ast.expression.context.Context;
import com.gs.dmn.feel.analysis.syntax.ast.expression.function.FormalParameter;
import com.gs.dmn.feel.analysis.syntax.ast.expression.function.FunctionDefinition;
import com.gs.dmn.feel.analysis.syntax.ast.expression.literal.StringLiteral;
import com.gs.dmn.feel.lib.StringEscapeUtil;
import com.gs.dmn.feel.synthesis.type.NativeTypeFactory;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.Pair;
import com.gs.dmn.runtime.metadata.ExtensionElement;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.transformation.basic.SignavioDMNEnvironmentFactory;
import com.gs.dmn.signavio.transformation.basic.SignavioDMNExpressionToNativeTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.basic.BasicDMNToJavaTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.native_.statement.ExpressionStatement;
import com.gs.dmn.transformation.native_.statement.Statement;
import com.gs.dmn.transformation.proto.ProtoBufferJavaFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BasicSignavioDMNToJavaTransformer
extends BasicDMNToJavaTransformer {
    private static final String DECISION_OUTPUT_FIELD_NAME = "value";
    private final SignavioDMNModelRepository dmnModelRepository = (SignavioDMNModelRepository)super.getDMNModelRepository();

    public BasicSignavioDMNToJavaTransformer(DMNDialectDefinition<?, ?, ?, ?, ?, ?> dialect, DMNModelRepository dmnModelRepository, EnvironmentFactory environmentFactory, NativeTypeFactory feelTypeTranslator, LazyEvaluationDetector lazyEvaluationDetector, InputParameters inputParameters) {
        super(dialect, dmnModelRepository, environmentFactory, feelTypeTranslator, lazyEvaluationDetector, inputParameters);
    }

    protected void setProtoBufferFactory(BasicDMNToJavaTransformer transformer) {
        this.protoFactory = new ProtoBufferJavaFactory((BasicDMNToJavaTransformer)this);
    }

    protected void setDMNEnvironmentFactory(BasicDMNToNativeTransformer<Type, DMNContext> transformer) {
        this.dmnEnvironmentFactory = new SignavioDMNEnvironmentFactory(transformer);
    }

    protected void setExpressionToNativeTransformer(BasicDMNToNativeTransformer<Type, DMNContext> transformer) {
        this.expressionToNativeTransformer = new SignavioDMNExpressionToNativeTransformer(transformer);
    }

    public String drgElementOutputType(TDRGElement element) {
        String outputType;
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            outputType = super.drgElementOutputType((TDRGElement)outputDecision);
        } else if (element instanceof TDecision && this.dmnModelRepository.isFreeTextLiteralExpression(element)) {
            Type type = this.drgElementOutputFEELType(element);
            outputType = this.toNativeType(type);
        } else {
            outputType = super.drgElementOutputType(element);
        }
        return this.nativeTypeFactory.nullableType(outputType);
    }

    public String drgElementOutputFieldName(TDRGElement element, int outputIndex) {
        if (this.dmnModelRepository.isDecisionTableExpression(element)) {
            TDecisionTable decisionTable = (TDecisionTable)this.dmnModelRepository.expression(element);
            return this.nativeFriendlyVariableName(this.dmnModelRepository.outputClauseName(element, (TOutputClause)decisionTable.getOutput().get(outputIndex)));
        }
        if (this.dmnModelRepository.isLiteralExpression(element)) {
            return DECISION_OUTPUT_FIELD_NAME;
        }
        TExpression value = this.dmnModelRepository.expression(element);
        throw new UnsupportedOperationException(String.format("'%s' is not supported yet ", value.getClass().getSimpleName()));
    }

    public String externalFunctionClassName(Expression<Type, DMNContext> body) {
        com.gs.dmn.feel.analysis.syntax.ast.expression.Expression returnTypeExp;
        com.gs.dmn.feel.analysis.syntax.ast.expression.Expression javaExpression;
        if (body instanceof Context && (javaExpression = ((Context)body).entry("java").getExpression()) instanceof Context && (returnTypeExp = ((Context)javaExpression).entry("class").getExpression()) instanceof StringLiteral) {
            String lexeme = ((StringLiteral)returnTypeExp).getLexeme();
            return StringEscapeUtil.stripQuotes((String)lexeme);
        }
        throw new DMNRuntimeException(String.format("Missing class in '%s'", body));
    }

    public String externalFunctionMethodName(Expression<Type, DMNContext> body) {
        com.gs.dmn.feel.analysis.syntax.ast.expression.Expression returnTypeExp;
        com.gs.dmn.feel.analysis.syntax.ast.expression.Expression javaExpression;
        if (body instanceof Context && (javaExpression = ((Context)body).entry("java").getExpression()) instanceof Context && (returnTypeExp = ((Context)javaExpression).entry("methodSignature").getExpression()) instanceof StringLiteral) {
            String lexeme = ((StringLiteral)returnTypeExp).getLexeme();
            String signature = StringEscapeUtil.stripQuotes((String)lexeme);
            int index = signature.indexOf(40);
            if (index != -1) {
                signature = signature.substring(0, index);
            }
            return signature;
        }
        throw new DMNRuntimeException(String.format("Missing methodName in '%s'", body));
    }

    public String drgElementSignature(DRGElementReference<? extends TDRGElement> reference) {
        TDRGElement element = reference.getElement();
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            DRGElementReference outputReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)outputDecision);
            List parameters = this.inputDataParametersClosure(outputReference);
            String decisionSignature = parameters.stream().map(p -> this.nativeFactory.nullableParameter(this.toNativeType((Type)p.getRight()), (String)p.getLeft())).collect(Collectors.joining(", "));
            return this.augmentSignature(decisionSignature);
        }
        return super.drgElementSignature(reference);
    }

    protected List<Pair<String, Type>> bkmParameters(DRGElementReference<TBusinessKnowledgeModel> reference, Function<Object, String> nameProducer) {
        TBusinessKnowledgeModel bkm = (TBusinessKnowledgeModel)reference.getElement();
        TFunctionDefinition encapsulatedLogic = bkm.getEncapsulatedLogic();
        if (encapsulatedLogic == null) {
            ArrayList parameters = new ArrayList();
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision(bkm);
            DRGElementReference outputReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)outputDecision);
            List paramaters = this.drgElementTypeSignature((TDRGElement)outputDecision);
            return paramaters;
        }
        return super.bkmParameters(reference, nameProducer);
    }

    public String drgElementArgumentList(DRGElementReference<? extends TDRGElement> reference) {
        TDRGElement element = reference.getElement();
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            DRGElementReference outputReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)outputDecision);
            List parameters = this.inputDataParametersClosure(outputReference);
            String arguments = parameters.stream().map(p -> String.format("%s", p.getLeft())).collect(Collectors.joining(", "));
            return this.augmentArgumentList(arguments);
        }
        return super.drgElementArgumentList(reference);
    }

    public String drgElementConvertedArgumentList(DRGElementReference<? extends TDRGElement> reference) {
        TDRGElement element = reference.getElement();
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            DRGElementReference outputReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)outputDecision);
            List parameters = this.inputDataParametersClosure(outputReference);
            String arguments = parameters.stream().map(p -> String.format("%s", this.convertDecisionArgument((String)p.getLeft(), (Type)p.getRight()))).collect(Collectors.joining(", "));
            return this.augmentArgumentList(arguments);
        }
        return super.drgElementConvertedArgumentList(reference);
    }

    public List<String> drgElementArgumentNameList(DRGElementReference<? extends TDRGElement> reference) {
        TDRGElement element = reference.getElement();
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return super.drgElementArgumentNameList((TDRGElement)outputDecision);
        }
        return super.drgElementArgumentNameList(reference);
    }

    public List<String> drgElementArgumentDisplayNameList(DRGElementReference<? extends TDRGElement> reference) {
        TDRGElement element = reference.getElement();
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return super.drgElementArgumentDisplayNameList((TDRGElement)outputDecision);
        }
        return super.drgElementArgumentDisplayNameList(reference);
    }

    public String bkmLinkedToDecisionToNative(TBusinessKnowledgeModel bkm) {
        TDecision outputDecision = this.dmnModelRepository.getOutputDecision(bkm);
        String decisionClassName = this.drgElementClassName((TDRGElement)outputDecision);
        List argNameList = this.drgElementArgumentNameList((TDRGElement)outputDecision);
        String decisionArgList = String.join((CharSequence)", ", argNameList);
        decisionArgList = this.augmentArgumentList(decisionArgList);
        return String.format("%s.apply(%s)", this.defaultConstructor(decisionClassName), decisionArgList);
    }

    public List<FormalParameter<Type, DMNContext>> bkmFEELParameters(TBusinessKnowledgeModel bkm) {
        TFunctionDefinition encapsulatedLogic = bkm.getEncapsulatedLogic();
        if (encapsulatedLogic == null) {
            ArrayList<FormalParameter<Type, DMNContext>> parameters = new ArrayList<FormalParameter<Type, DMNContext>>();
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision(bkm);
            DRGElementReference outputReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)outputDecision);
            List allInputDataReferences = this.dmnModelRepository.inputDataClosure(outputReference, this.drgElementFilter);
            this.dmnModelRepository.sortNamedElementReferences(allInputDataReferences);
            for (DRGElementReference reference : allInputDataReferences) {
                TInputData id = (TInputData)reference.getElement();
                parameters.add((FormalParameter<Type, DMNContext>)new FormalParameter(id.getName(), (Object)this.drgElementOutputFEELType((TDRGElement)id)));
            }
            return parameters;
        }
        return super.bkmFEELParameters(bkm);
    }

    public QualifiedName drgElementOutputTypeRef(TDRGElement element) {
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return this.drgElementOutputTypeRef((TDRGElement)outputDecision);
        }
        return super.drgElementOutputTypeRef(element);
    }

    public List<ExtensionElement> makeMetadataExtensions(TDecision decision) {
        ArrayList<ExtensionElement> extensions = new ArrayList<ExtensionElement>();
        if (this.dmnModelRepository.isMultiInstanceDecision((TDRGElement)decision)) {
            ExtensionElement extensionElement = this.dmnModelRepository.getExtension().makeMultiInstanceExtension(decision);
            extensions.add(extensionElement);
        }
        return extensions;
    }

    public MultiInstanceDecisionLogic multiInstanceDecisionLogic(TDecision decision) {
        return this.dmnModelRepository.getExtension().multiInstanceDecisionLogic((TDRGElement)decision);
    }

    public String iterationExpressionToNative(TDecision decision, String iterationExpression) {
        return this.literalExpressionToNative((TDRGElement)decision, iterationExpression);
    }

    private String iterationSignature(TDecision decision) {
        List<DRGElementReference<? extends TDRGElement>> dmnReferences = this.collectIterationInputs(decision);
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        for (DRGElementReference<? extends TDRGElement> reference : dmnReferences) {
            TDRGElement element = reference.getElement();
            String parameterName = this.iterationParameterName(element);
            String parameterNativeType = this.lazyEvaluationType(element, this.parameterNativeType(element));
            parameters.add(new Pair((Object)parameterName, (Object)parameterNativeType));
        }
        String signature = parameters.stream().map(p -> this.nativeFactory.nullableParameter((String)p.getRight(), (String)p.getLeft())).collect(Collectors.joining(", "));
        return this.augmentSignature(signature);
    }

    private String iterationArgumentList(TDecision decision) {
        List<DRGElementReference<? extends TDRGElement>> dmnReferences = this.collectIterationInputs(decision);
        ArrayList<String> arguments = new ArrayList<String>();
        for (DRGElementReference<? extends TDRGElement> reference : dmnReferences) {
            TDRGElement element = reference.getElement();
            String argumentName = this.iterationArgumentName(element);
            arguments.add(argumentName);
        }
        String argumentList = String.join((CharSequence)", ", arguments);
        return this.augmentArgumentList(argumentList);
    }

    private List<DRGElementReference<? extends TDRGElement>> collectIterationInputs(TDecision decision) {
        LinkedHashSet elementSet = new LinkedHashSet();
        DRGElementReference decisionReference = this.dmnModelRepository.makeDRGElementReference((TDRGElement)decision);
        elementSet.addAll(this.dmnModelRepository.inputDataClosure(decisionReference, this.drgElementFilter));
        elementSet.addAll(this.dmnModelRepository.directSubDecisions((TDRGElement)decision));
        ArrayList<DRGElementReference<? extends TDRGElement>> elements = new ArrayList<DRGElementReference<? extends TDRGElement>>(elementSet);
        this.dmnModelRepository.sortNamedElementReferences(elements);
        return elements;
    }

    private String iterationParameterName(TDRGElement element) {
        return this.namedElementVariableName((TNamedElement)element);
    }

    private String iterationArgumentName(TDRGElement element) {
        return this.namedElementVariableName((TNamedElement)element);
    }

    public String freeTextLiteralExpressionToNative(TDRGElement element) {
        TLiteralExpression expression = (TLiteralExpression)this.dmnModelRepository.expression(element);
        DMNContext globalContext = this.makeGlobalContext(element);
        Expression literalExpression = this.feelTranslator.analyzeExpression(expression.getText(), (Object)globalContext);
        if (literalExpression instanceof FunctionDefinition) {
            String javaCode;
            com.gs.dmn.feel.analysis.syntax.ast.expression.Expression body = ((FunctionDefinition)literalExpression).getBody();
            if (((FunctionDefinition)literalExpression).isExternal()) {
                Type type = (Type)literalExpression.getType();
                if (type instanceof FEELFunctionType) {
                    type = ((FEELFunctionType)type).getReturnType();
                }
                String returnNativeType = this.toNativeType(type);
                String className = this.externalFunctionClassName((Expression<Type, DMNContext>)body);
                String methodName = this.externalFunctionMethodName((Expression<Type, DMNContext>)body);
                String arguments = this.drgElementArgumentList(element);
                javaCode = this.nativeFactory.makeExternalExecutorCall(this.externalExecutorVariableName(), className, methodName, arguments, returnNativeType);
            } else {
                javaCode = this.feelTranslator.expressionToNative((Expression)body, (Object)globalContext);
            }
            Type expressionType = (Type)body.getType();
            ExpressionStatement statement = this.nativeFactory.makeExpressionStatement(javaCode, expressionType);
            Type expectedType = this.drgElementOutputFEELType(element);
            Statement result = this.convertExpression((Statement)statement, expectedType);
            return result.getText();
        }
        return super.literalExpressionToNative(element, expression.getText());
    }
}

