/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation.basic;

import com.gs.dmn.QualifiedName;
import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionService;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TFunctionDefinition;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TInvocable;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.context.environment.Declaration;
import com.gs.dmn.context.environment.Environment;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.el.analysis.syntax.ast.expression.Expression;
import com.gs.dmn.feel.analysis.semantics.type.FEELFunctionType;
import com.gs.dmn.feel.analysis.syntax.ast.expression.function.FunctionDefinition;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.transformation.basic.BasicSignavioDMNToJavaTransformer;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.basic.StandardDMNEnvironmentFactory;
import javax.xml.namespace.QName;

public class SignavioDMNEnvironmentFactory
extends StandardDMNEnvironmentFactory {
    private final SignavioDMNModelRepository dmnModelRepository;

    public SignavioDMNEnvironmentFactory(BasicDMNToNativeTransformer<Type, DMNContext> basicDMNToNativeTransformer) {
        super(basicDMNToNativeTransformer);
        this.dmnModelRepository = (SignavioDMNModelRepository)((StandardDMNEnvironmentFactory)this).dmnModelRepository;
    }

    public Type drgElementOutputFEELType(TDRGElement element) {
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return super.drgElementOutputFEELType((TDRGElement)outputDecision);
        }
        if (element instanceof TDecision && this.dmnModelRepository.isFreeTextLiteralExpression(element)) {
            Expression<Type, DMNContext> feelExpression = this.analyzeExpression(element);
            if (feelExpression instanceof FunctionDefinition) {
                Type type = (Type)feelExpression.getType();
                if (type instanceof FEELFunctionType) {
                    type = ((FEELFunctionType)type).getReturnType();
                }
                return type;
            }
            return (Type)feelExpression.getType();
        }
        return super.drgElementOutputFEELType(element);
    }

    public Type drgElementOutputFEELType(TDRGElement element, DMNContext context) {
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return super.drgElementOutputFEELType((TDRGElement)outputDecision);
        }
        if (element instanceof TDecision && this.dmnModelRepository.isFreeTextLiteralExpression(element)) {
            Expression<Type, DMNContext> feelExpression = this.analyzeExpression(element);
            if (feelExpression instanceof FunctionDefinition) {
                if (((FunctionDefinition)feelExpression).isExternal()) {
                    com.gs.dmn.feel.analysis.syntax.ast.expression.Expression body = ((FunctionDefinition)feelExpression).getBody();
                    return this.externalFunctionReturnFEELType((TNamedElement)element, (Expression)body);
                }
                Type type = (Type)feelExpression.getType();
                if (type instanceof FEELFunctionType) {
                    type = ((FEELFunctionType)type).getReturnType();
                }
                return type;
            }
            return (Type)feelExpression.getType();
        }
        return super.drgElementOutputFEELType(element, context);
    }

    private Expression<Type, DMNContext> analyzeExpression(TDRGElement element) {
        TLiteralExpression expression = (TLiteralExpression)this.dmnModelRepository.expression(element);
        DMNContext globalContext = this.dmnTransformer.makeGlobalContext(element);
        return this.feelTranslator.analyzeExpression(expression.getText(), (Object)globalContext);
    }

    public Type expressionType(TDRGElement element, TExpression expression, DMNContext context) {
        if (this.dmnModelRepository.isMultiInstanceDecision(element)) {
            TDecision decision = (TDecision)element;
            MultiInstanceDecisionLogic multiInstanceDecision = ((BasicSignavioDMNToJavaTransformer)this.dmnTransformer).multiInstanceDecisionLogic(decision);
            TDecision topLevelDecision = multiInstanceDecision.getTopLevelDecision();
            return super.drgElementVariableFEELType((TDRGElement)topLevelDecision);
        }
        if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)element)) {
            TDecision outputDecision = this.dmnModelRepository.getOutputDecision((TBusinessKnowledgeModel)element);
            return super.drgElementVariableFEELType((TDRGElement)outputDecision);
        }
        return super.expressionType(element, expression, context);
    }

    public Declaration makeDeclaration(TDRGElement parent, Environment parentEnvironment, TDRGElement child) {
        Declaration declaration;
        TDefinitions childModel = this.dmnModelRepository.getModel((TNamedElement)child);
        if (child instanceof TInputData) {
            declaration = this.makeVariableDeclaration(child, ((TInputData)child).getVariable());
        } else if (child instanceof TBusinessKnowledgeModel) {
            TBusinessKnowledgeModel bkm = (TBusinessKnowledgeModel)child;
            if (this.dmnModelRepository.isBKMLinkedToDecision((TNamedElement)bkm)) {
                TDecision outputDecision = this.dmnModelRepository.getOutputDecision(bkm);
                declaration = this.makeVariableDeclaration(child, outputDecision.getVariable());
            } else {
                TFunctionDefinition functionDefinition = bkm.getEncapsulatedLogic();
                functionDefinition.getFormalParameter().forEach(p -> parentEnvironment.addDeclaration(this.environmentFactory.makeVariableDeclaration(p.getName(), this.dmnTransformer.toFEELType(childModel, QualifiedName.toQualifiedName((TDefinitions)childModel, (QName)p.getTypeRef())))));
                declaration = this.makeInvocableDeclaration((TInvocable)bkm);
            }
        } else if (child instanceof TDecision) {
            declaration = this.makeVariableDeclaration(child, ((TDecision)child).getVariable());
        } else if (child instanceof TDecisionService) {
            declaration = this.makeInvocableDeclaration((TInvocable)((TDecisionService)child));
        } else {
            throw new UnsupportedOperationException(String.format("'%s' is not supported yet", child.getClass().getSimpleName()));
        }
        return declaration;
    }
}

