/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.transformation.basic;

import com.gs.dmn.NameUtils;
import com.gs.dmn.ast.TBinding;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.TInvocable;
import com.gs.dmn.ast.TInvocation;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.basic.DMNExpressionToNativeTransformer;
import com.gs.dmn.transformation.native_.statement.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class SignavioDMNExpressionToNativeTransformer
extends DMNExpressionToNativeTransformer {
    protected SignavioDMNExpressionToNativeTransformer(BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer) {
        super(dmnTransformer);
    }

    protected Statement invocationExpressionToNative(TDRGElement element, TInvocation invocation, DMNContext parentContext) {
        LinkedHashMap<String, Statement> argBinding = new LinkedHashMap<String, Statement>();
        for (TBinding binding : invocation.getBinding()) {
            String argName = binding.getParameter().getName();
            TExpression argExpression = binding.getExpression();
            Statement argJava = this.dmnTransformer.expressionToNative(element, argExpression, parentContext);
            argBinding.put(argName, argJava);
        }
        TExpression body = invocation.getExpression();
        if (body instanceof TLiteralExpression) {
            String invocableName = NameUtils.invocableName((String)((TLiteralExpression)body).getText());
            TInvocable invocable = this.dmnModelRepository.findInvocableByName(invocableName);
            if (invocable == null) {
                throw new DMNRuntimeException(String.format("Cannot find BKM for '%s'", invocableName));
            }
            ArrayList<Statement> argList = new ArrayList<Statement>();
            List formalParameterList = this.dmnTransformer.invocableFEELParameterNames((TDRGElement)invocable);
            for (String paramName : formalParameterList) {
                if (argBinding.containsKey(paramName)) {
                    Statement argValue = (Statement)argBinding.get(paramName);
                    argList.add(argValue);
                    continue;
                }
                throw new UnsupportedOperationException(String.format("Cannot find binding for parameter '%s'", paramName));
            }
            String invocableInstance = this.dmnTransformer.singletonInvocableInstance(invocable);
            String argListString = argList.stream().map(Statement::getText).collect(Collectors.joining(", "));
            String expressionText = String.format("%s.apply(%s)", invocableInstance, this.dmnTransformer.augmentArgumentList(argListString));
            Type expressionType = this.dmnTransformer.drgElementOutputFEELType((TDRGElement)invocable);
            return this.nativeFactory.makeExpressionStatement(expressionText, expressionType);
        }
        throw new DMNRuntimeException(String.format("Not supported '%s'", body.getClass().getSimpleName()));
    }
}

