/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.validation;

import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.validation.SimpleDMNValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class LabelDuplicationValidator
extends SimpleDMNValidator {
    void validateElements(List<? extends TDMNElement> elements, List<String> errors) {
        List elementList;
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (TDMNElement tDMNElement : elements) {
            String label = tDMNElement.getLabel();
            if (label == null) {
                throw new RuntimeException(String.format("%s has no label", tDMNElement.getId()));
            }
            elementList = map.computeIfAbsent(label, k -> new ArrayList());
            elementList.add(tDMNElement);
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            elementList = (List)entry.getValue();
            if (StringUtils.isBlank((CharSequence)key) || elementList.size() <= 1) continue;
            String elementKind = ((TDMNElement)elementList.get(0)).getClass().getSimpleName().substring(1);
            errors.add(String.format("Found %d %s with duplicated label '%s'", elementList.size(), elementKind, key));
            for (TDMNElement e : elementList) {
                if (!(e instanceof TDRGElement)) continue;
                errors.add(String.format("Label = '%s' Id = '%s' kind = '%s'", key, e.getId(), e.getClass().getSimpleName()));
            }
        }
    }
}

