/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.validation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.log.Slf4jBuildLogger;
import com.gs.dmn.validation.SimpleDMNValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RuleDescriptionValidator
extends SimpleDMNValidator {
    private static final Map<String, String> PATTERNS = new LinkedHashMap<String, String>();

    public RuleDescriptionValidator() {
        super((BuildLogger)new Slf4jBuildLogger(LOGGER));
    }

    public RuleDescriptionValidator(BuildLogger logger) {
        super(logger);
    }

    public List<String> validate(DMNModelRepository repository) {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.isEmpty(repository)) {
            this.logger.warn("DMN repository is empty; validator will not run");
            return errors;
        }
        for (TDefinitions definitions : repository.getAllDefinitions()) {
            for (TDecision decision : repository.findDecisions(definitions)) {
                TExpression expression = repository.expression((TDRGElement)decision);
                if (!(expression instanceof TDecisionTable)) continue;
                List rules = ((TDecisionTable)expression).getRule();
                for (int i = 0; i < rules.size(); ++i) {
                    TDecisionRule rule = (TDecisionRule)rules.get(i);
                    this.validate(repository, definitions, decision, i, rule.getDescription(), errors);
                }
            }
        }
        return errors;
    }

    protected void validate(DMNModelRepository repository, TDefinitions definitions, TDecision decision, int ruleIndex, String description, List<String> errors) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            for (Map.Entry<String, String> entry : PATTERNS.entrySet()) {
                if (!description.contains(entry.getKey())) continue;
                String errorMessage = String.format("Description of rule %d in decision '%s' contains illegal sequence '%s'", ruleIndex, decision.getName(), entry.getValue());
                errors.add(this.makeError(repository, definitions, (TDMNElement)decision, errorMessage));
            }
        }
    }

    static {
        PATTERNS.put("[ ,", "[ ,");
        PATTERNS.put(",  ,", ",  ,");
        PATTERNS.put(", ]", ", ]");
        PATTERNS.put("string(-)", "string(-)");
        PATTERNS.put("\u00a0", "NO-BREAK SPACE");
    }
}

