/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.validation;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TFunctionDefinition;
import com.gs.dmn.validation.DefaultDMNValidator;
import java.util.List;
import org.w3c.dom.Element;

public class SignavioDMNValidator
extends DefaultDMNValidator {
    protected void validateBusinessKnowledgeModel(DMNModelRepository repository, TDefinitions definitions, TBusinessKnowledgeModel knowledgeModel, List<String> errors) {
        super.validateBusinessKnowledgeModel(repository, definitions, knowledgeModel, errors);
        TFunctionDefinition encapsulatedLogic = knowledgeModel.getEncapsulatedLogic();
        TDMNElement.ExtensionElements extensionElements = knowledgeModel.getExtensionElements();
        if (encapsulatedLogic == null && extensionElements == null) {
            String errorMessage = "Missing encapsulatedLogic";
            errors.add(this.makeError(repository, definitions, (TDMNElement)knowledgeModel, errorMessage));
        }
    }

    protected void validateDecision(DMNModelRepository repository, TDefinitions definitions, TDecision decision, List<String> errors) {
        super.validateDecision(repository, definitions, decision, errors);
        this.validateExtensionElements(repository, definitions, decision, errors);
    }

    private void validateExtensionElements(DMNModelRepository repository, TDefinitions definitions, TDecision decision, List<String> errors) {
        List any;
        TDMNElement.ExtensionElements extensionElements = decision.getExtensionElements();
        if (extensionElements != null && (any = extensionElements.getAny()) != null) {
            for (Object obj : any) {
                if (obj instanceof Element) {
                    String nodeName = ((Element)obj).getNodeName();
                    if ("MultiInstanceDecisionLogic".equals(nodeName)) continue;
                    String errorMessage = String.format("Extension '%s' not supported", obj);
                    errors.add(this.makeError(repository, definitions, (TDMNElement)decision, errorMessage));
                    continue;
                }
                String errorMessage = String.format("Extension '%s' not supported", obj);
                errors.add(this.makeError(repository, definitions, (TDMNElement)decision, errorMessage));
            }
        }
    }
}

