/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.AsOfAttribute;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.MithraGenerator;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.IndexInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.MithraObjectXmlGenerator;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseIndexValidator
extends Task {
    private final MithraObjectXmlGenerator xmlGenerator;
    private String xml;
    private boolean ignorePackageNamingConvention = false;
    private boolean executed = false;
    private List<MithraGeneratorImport> imports = new ArrayList<MithraGeneratorImport>();
    private final SortedMap<String, String> tablesMissingFromDb = new TreeMap<String, String>();
    private final SortedMap<String, String> missingKeyViolations = new TreeMap<String, String>();

    public DatabaseIndexValidator() {
        this.xmlGenerator = new MithraObjectXmlGenerator();
        this.xmlGenerator.setExcludeAsOfAttributesFromDbIndex(false);
    }

    public void addImport(String dir, String fileName) {
        MithraGeneratorImport anImport = new MithraGeneratorImport();
        anImport.setDir(dir);
        anImport.setFilename(fileName);
        this.addConfiguredMithraImport(anImport);
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void setIgnorePackageNamingConvention(boolean ignorePackageNamingConvention) {
        this.ignorePackageNamingConvention = ignorePackageNamingConvention;
    }

    public Map<String, String> getTablesMissingFromDb() {
        return this.tablesMissingFromDb;
    }

    public Map<String, String> getMissingKeyViolations() {
        return this.missingKeyViolations;
    }

    public void execute() throws BuildException {
        if (!this.executed) {
            this.validateIndices();
            if (!this.tablesMissingFromDb.isEmpty()) {
                this.log("The following tables are not found: " + this.tablesMissingFromDb.values(), 0);
            }
            if (!this.missingKeyViolations.isEmpty()) {
                throw new RuntimeException("The following violations are reported: " + this.missingKeyViolations.values());
            }
            this.executed = true;
        }
    }

    public void validateIndices(Collection<MithraObjectTypeWrapper> wrappers) {
        List<MithraObjectTypeWrapper> typesForValidation = this.selectNotPureNotImported(wrappers);
        if (!typesForValidation.isEmpty()) {
            Map<String, TableInfo> tableInfo = this.generateTableInfo(typesForValidation);
            this.validate(typesForValidation, tableInfo);
        }
    }

    public void validateIndices() {
        Map<String, MithraObjectTypeWrapper> parsed = this.parseXmlAndGetMithraObjects(this.xml);
        this.validateIndices(parsed.values());
    }

    public void addConfiguredMithraImport(MithraGeneratorImport imp) {
        this.imports.add(imp);
    }

    private Map<String, TableInfo> generateTableInfo(List<MithraObjectTypeWrapper> wrappers) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < wrappers.size(); ++i) {
            tableNames.add(wrappers.get(i).getDefaultTable());
        }
        this.xmlGenerator.setIncludeList(tableNames);
        this.xmlGenerator.setGeneratedPackageName("test");
        return this.xmlGenerator.processTableInfo();
    }

    private void validate(List<MithraObjectTypeWrapper> typeWrappers, Map<String, TableInfo> tableInfo) {
        for (int i = 0; i < typeWrappers.size(); ++i) {
            Iterable<Set<String>> dbPkCandidates;
            MithraObjectTypeWrapper typeWrapper = typeWrappers.get(i);
            String tableName = typeWrapper.getDefaultTable();
            TableInfo tableDetails = tableInfo.get(tableName);
            String mithraObjectClassName = typeWrapper.getClassName();
            if (tableDetails == null) {
                this.tablesMissingFromDb.put(mithraObjectClassName, "Mithra object: " + mithraObjectClassName + ", missing table: " + tableName);
                continue;
            }
            Set<String> pkColumnNamesInMithra = this.extractMithraPrimaryKey(typeWrapper);
            if (this.matchFound(pkColumnNamesInMithra, dbPkCandidates = this.createPkCandidates(tableDetails))) continue;
            this.missingKeyViolations.put(mithraObjectClassName, "\n" + mithraObjectClassName + ": DB table: " + tableName + ", mithra pk: " + this.toDisplayString((Collection<String>)pkColumnNamesInMithra) + ", pk candidates from db: " + this.toDisplayString(dbPkCandidates));
        }
    }

    private boolean matchFound(Set<String> pkColumnNamesInMithra, Iterable<Set<String>> dbPkCandidates) {
        boolean matchFound = false;
        Iterator<Set<String>> iterator = dbPkCandidates.iterator();
        while (iterator.hasNext() && !matchFound) {
            matchFound = iterator.next().containsAll(pkColumnNamesInMithra);
        }
        return matchFound;
    }

    private String toDisplayString(Iterable<Set<String>> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Set<String>> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("[");
            stringBuilder.append(this.toDisplayString((Collection<String>)iterator.next()));
            stringBuilder.append("] ");
        }
        return stringBuilder.toString();
    }

    private Iterable<Set<String>> createPkCandidates(TableInfo tableInfo) {
        HashSet<Set<String>> pkCandidates = new HashSet<Set<String>>();
        pkCandidates.add(this.getPkCandidateColumnList(tableInfo));
        for (IndexInfo indexInfo : tableInfo.getIndexMap().values()) {
            if (!indexInfo.isUnique()) continue;
            ArrayList<ColumnInfo> columnInfoList = indexInfo.getColumnInfoList();
            HashSet<String> indexColumns = new HashSet<String>();
            for (ColumnInfo aColumnInfoList : columnInfoList) {
                indexColumns.add(aColumnInfoList.getColumnName());
            }
            pkCandidates.add(indexColumns);
        }
        return pkCandidates;
    }

    private Set<String> getPkCandidateColumnList(TableInfo tableInfo) {
        List<ColumnInfo> columnInfos = tableInfo.getPkList();
        HashSet<String> pkColumnNamesInDb = new HashSet<String>();
        for (int k = 0; k < columnInfos.size(); ++k) {
            pkColumnNamesInDb.add(columnInfos.get(k).getColumnName());
        }
        return pkColumnNamesInDb;
    }

    private Set<String> extractMithraPrimaryKey(MithraObjectTypeWrapper typeWrapper) {
        Attribute[] pkAttributes = typeWrapper.getPrimaryKeyAttributes();
        HashSet<String> pkColumnNamesInMithra = new HashSet<String>();
        for (int j = 0; j < pkAttributes.length; ++j) {
            pkColumnNamesInMithra.add(pkAttributes[j].getColumnName());
        }
        this.addAsOfAttributes(pkColumnNamesInMithra, typeWrapper);
        return pkColumnNamesInMithra;
    }

    private void addAsOfAttributes(Set<String> pkColumnNames, MithraObjectTypeWrapper typeWrapper) {
        AsOfAttribute[] asOfAttribute = typeWrapper.getAsOfAttributes();
        for (int i = 0; i < asOfAttribute.length; ++i) {
            pkColumnNames.add(asOfAttribute[i].getToColumnName());
        }
    }

    private String toDisplayString(Collection<String> collection) {
        if (collection.isEmpty()) {
            return "<NONE!>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String aCollection : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(aCollection);
        }
        return stringBuilder.toString();
    }

    private Map<String, MithraObjectTypeWrapper> parseXmlAndGetMithraObjects(String xml) {
        MithraGenerator mithraGenerator = new MithraGenerator();
        mithraGenerator.setXml(xml);
        mithraGenerator.setIgnorePackageNamingConvention(this.ignorePackageNamingConvention);
        for (MithraGeneratorImport anImport : this.imports) {
            mithraGenerator.addConfiguredMithraImport(anImport);
        }
        try {
            mithraGenerator.parseAndValidate();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return mithraGenerator.getMithraObjects();
    }

    private List<MithraObjectTypeWrapper> selectNotPureNotImported(Collection<MithraObjectTypeWrapper> values) {
        ArrayList<MithraObjectTypeWrapper> list = new ArrayList<MithraObjectTypeWrapper>();
        for (MithraObjectTypeWrapper wrapper : values) {
            if (wrapper.isPure() || wrapper.isImported() || wrapper.isTablePerSubclassSuperClass()) continue;
            list.add(wrapper);
        }
        return list;
    }

    public String getUserName() {
        return this.xmlGenerator.getUserName();
    }

    public void setUserName(String userName) {
        this.xmlGenerator.setUserName(userName);
    }

    public String getPassword() {
        return this.xmlGenerator.getPassword();
    }

    public void setPassword(String password) {
        this.xmlGenerator.setPassword(password);
    }

    public String getDatabaseType() {
        return this.xmlGenerator.getDatabaseType();
    }

    public void setDatabaseType(String databaseType) throws BuildException {
        this.xmlGenerator.setDatabaseType(databaseType);
    }

    public String getDriver() {
        return this.xmlGenerator.getDriver();
    }

    public void setDriver(String driver) {
        this.xmlGenerator.setDriver(driver);
    }

    public void setLdapName(String ldapName) {
        this.xmlGenerator.setLdapName(ldapName);
    }

    public String getLdapName() {
        return this.xmlGenerator.getLdapName();
    }

    public String getUrl() {
        return this.xmlGenerator.getUrl();
    }

    public void setUrl(String url) {
        this.xmlGenerator.setUrl(url);
    }

    public void setSchema(String schema) {
        this.xmlGenerator.setSchema(schema);
    }

    public String getSchema() {
        return this.xmlGenerator.getSchema();
    }
}

