/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.MithraGenerator;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.MithraObjectXmlGenerator;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import com.gs.fw.common.mithra.generator.type.StringJavaType;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTableValidator
extends Task {
    private static final double TEXT_DATA_SIZE = 2.147483647E9;
    private final MithraObjectXmlGenerator xmlGenerator;
    private final Map<String, String> tablesMissingFromDb = new HashMap<String, String>();
    private final Map<String, String> missingColumnsViolations = new HashMap<String, String>();
    private final Map<String, String> columnTypeViolations = new HashMap<String, String>();
    private final Map<String, String> columnSizeViolations = new HashMap<String, String>();
    private final List<MithraObjectTypeWrapper> mithraObjectsWithNoTableInfo = new ArrayList<MithraObjectTypeWrapper>();
    private String xml;
    private boolean executed = false;
    private HashMap<Integer, Integer> equivalentSqlTypeMap = new HashMap();

    public DatabaseTableValidator() {
        this.initEquivalentSqlTypeMap();
        this.xmlGenerator = new MithraObjectXmlGenerator();
        this.xmlGenerator.setExcludeAsOfAttributesFromDbIndex(false);
    }

    private void initEquivalentSqlTypeMap() {
        this.equivalentSqlTypeMap.put(-5, 2);
        this.equivalentSqlTypeMap.put(4, 2);
        this.equivalentSqlTypeMap.put(5, 2);
        this.equivalentSqlTypeMap.put(-6, 2);
        this.equivalentSqlTypeMap.put(-7, 2);
        this.equivalentSqlTypeMap.put(6, 2);
        this.equivalentSqlTypeMap.put(7, 2);
        this.equivalentSqlTypeMap.put(8, 2);
        this.equivalentSqlTypeMap.put(3, 2);
        this.equivalentSqlTypeMap.put(1, 12);
        this.equivalentSqlTypeMap.put(-1, 12);
        this.equivalentSqlTypeMap.put(91, 93);
        this.equivalentSqlTypeMap.put(92, 93);
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void execute() throws BuildException {
        if (!this.executed) {
            this.validateTables();
            if (!this.tablesMissingFromDb.isEmpty()) {
                this.log("The following tables are not found: " + this.tablesMissingFromDb.values(), 0);
            }
            if (!this.missingColumnsViolations.isEmpty()) {
                this.log("Missing columns: " + this.missingColumnsViolations.values(), 0);
            }
            if (!this.columnTypeViolations.isEmpty()) {
                this.log("Unmatched column type: " + this.columnTypeViolations.values(), 0);
            }
            if (!this.columnSizeViolations.isEmpty()) {
                this.log("Unmatched column size: " + this.columnSizeViolations.values(), 0);
            }
            this.executed = true;
        }
    }

    public void validateTables() {
        Map<String, MithraObjectTypeWrapper> parsed = this.parseXmlAndGetMithraObjects(this.xml);
        this.validate(parsed.values());
    }

    public void validate(Collection<MithraObjectTypeWrapper> mithraObjectTypeWrapperList) {
        if (!mithraObjectTypeWrapperList.isEmpty()) {
            ArrayList<MithraObjectTypeWrapper> typesForValidation = new ArrayList<MithraObjectTypeWrapper>(mithraObjectTypeWrapperList);
            Map<String, TableInfo> tableInfo = this.generateTableInfo(typesForValidation);
            this.validateTable(typesForValidation, tableInfo);
            if (this.mithraObjectsWithNoTableInfo.size() > 0) {
                this.validateView(this.mithraObjectsWithNoTableInfo);
            }
        }
    }

    private Map<String, MithraObjectTypeWrapper> parseXmlAndGetMithraObjects(String xml) {
        MithraGenerator mithraGenerator = new MithraGenerator();
        mithraGenerator.setXml(xml);
        try {
            mithraGenerator.parseAndValidate();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return mithraGenerator.getMithraObjects();
    }

    private void validateTable(List<MithraObjectTypeWrapper> typeWrappers, Map<String, TableInfo> tableInfo) {
        for (int i = 0; i < typeWrappers.size(); ++i) {
            MithraObjectTypeWrapper typeWrapper = typeWrappers.get(i);
            String tableName = typeWrapper.getDefaultTable();
            TableInfo tableDetails = tableInfo.get(tableName);
            if (tableDetails == null) {
                this.mithraObjectsWithNoTableInfo.add(typeWrapper);
                continue;
            }
            this.validateColumns(typeWrapper, tableDetails);
        }
    }

    private void validateView(List<MithraObjectTypeWrapper> typeWrappers) {
        Map<String, TableInfo> viewInfo = this.xmlGenerator.processViewInfo();
        for (MithraObjectTypeWrapper typeWrapper : typeWrappers) {
            String tableName = typeWrapper.getDefaultTable();
            String mithraObjectClassName = typeWrapper.getClassName();
            TableInfo viewDetails = viewInfo.get(tableName);
            if (viewDetails == null) {
                this.tablesMissingFromDb.put(mithraObjectClassName, "Mithra object: " + mithraObjectClassName + ", missing table/view: " + tableName);
                continue;
            }
            this.validateColumns(typeWrapper, viewDetails);
        }
    }

    private void validateColumns(MithraObjectTypeWrapper typeWrapper, TableInfo viewDetails) {
        String className = typeWrapper.getClassName();
        Attribute[] attributes = typeWrapper.getAttributes();
        Map<String, ColumnInfo> columnInfoMap = viewDetails.getColumnMap();
        for (Attribute attribute : attributes) {
            int equivalentDbSqlType;
            int equivalentMithraSqlType;
            int dbSqlType;
            String columnName = attribute.getColumnName();
            ColumnInfo columnInfo = columnInfoMap.get(columnName);
            if (columnInfo == null) {
                this.missingColumnsViolations.put(className + "-" + columnName, "Missing column in object " + typeWrapper.getClassName() + " column " + columnName + " in attribute " + attribute.getName());
                continue;
            }
            int mithraSqlType = attribute.getType().getSqlType();
            if (mithraSqlType != (dbSqlType = columnInfo.getSqlType()) && (equivalentMithraSqlType = this.normalizeType(mithraSqlType)) != (equivalentDbSqlType = this.normalizeType(dbSqlType))) {
                String mithraColumnType = attribute.getAttributeType().getJavaType();
                String dbColumnType = columnInfo.getJavaType();
                this.columnTypeViolations.put(className + "-" + columnName, "Unmatched column type on object " + className + " column " + columnName + ". mithra: " + mithraColumnType + " db: " + dbColumnType);
            }
            int maxLength = attribute.getMaxLength();
            int dbColumnSize = columnInfo.getColumnSize();
            if (attribute.getType() instanceof StringJavaType && maxLength == 0) {
                this.columnSizeViolations.put(className + "-" + columnName, "MaxLength is missing for object " + className + " column " + columnName + " db column size: " + dbColumnSize);
                continue;
            }
            if (maxLength <= 0 || ((double)dbColumnSize != 2.147483647E9 || maxLength <= dbColumnSize) && ((double)dbColumnSize == 2.147483647E9 || maxLength == dbColumnSize)) continue;
            this.columnSizeViolations.put(className + "-" + columnName, "Unmatched column size on object " + className + " column " + columnName + ". mithra: " + maxLength + " db: " + dbColumnSize);
        }
    }

    private int normalizeType(int mithraSqlType) {
        return this.equivalentSqlTypeMap.containsKey(mithraSqlType) ? this.equivalentSqlTypeMap.get(mithraSqlType) : mithraSqlType;
    }

    private Map<String, TableInfo> generateTableInfo(List<MithraObjectTypeWrapper> wrappers) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < wrappers.size(); ++i) {
            tableNames.add(wrappers.get(i).getDefaultTable());
        }
        this.xmlGenerator.setIncludeList(tableNames);
        this.xmlGenerator.setGeneratedPackageName("test");
        return this.xmlGenerator.processTableInfo();
    }

    public Map<String, String> getTablesMissingFromDb() {
        return this.tablesMissingFromDb;
    }

    public Map<String, String> getMissingColumnsViolations() {
        return this.missingColumnsViolations;
    }

    public Map<String, String> getColumnTypeViolations() {
        return this.columnTypeViolations;
    }

    public Map<String, String> getColumnSizeViolations() {
        return this.columnSizeViolations;
    }

    public String getUserName() {
        return this.xmlGenerator.getUserName();
    }

    public void setUserName(String userName) {
        this.xmlGenerator.setUserName(userName);
    }

    public String getPassword() {
        return this.xmlGenerator.getPassword();
    }

    public void setPassword(String password) {
        this.xmlGenerator.setPassword(password);
    }

    public String getDatabaseType() {
        return this.xmlGenerator.getDatabaseType();
    }

    public void setDatabaseType(String databaseType) {
        this.xmlGenerator.setDatabaseType(databaseType);
    }

    public String getDriver() {
        return this.xmlGenerator.getDriver();
    }

    public void setDriver(String driver) {
        this.xmlGenerator.setDriver(driver);
    }

    public void setLdapName(String ldapName) {
        this.xmlGenerator.setLdapName(ldapName);
    }

    public String getLdapName() {
        return this.xmlGenerator.getLdapName();
    }

    public String getUrl() {
        return this.xmlGenerator.getUrl();
    }

    public void setUrl(String url) {
        this.xmlGenerator.setUrl(url);
    }

    public void setSchema(String schema) {
        this.xmlGenerator.setSchema(schema);
    }

    public String getSchema() {
        return this.xmlGenerator.getSchema();
    }
}

