/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey {
    private String refTableName;
    private List<String> refColumnsAsString = new ArrayList<String>();
    private List<ColumnInfo> refColumns = new ArrayList<ColumnInfo>();
    private List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    private boolean multipleRelationsBetweenTables;
    private TableInfo tableA;
    private TableInfo tableB;
    private TableInfo tableAB;
    private String name;

    public ForeignKey(TableInfo table, String name, String refTable) {
        this.tableA = table;
        this.name = name;
        this.refTableName = refTable;
        this.multipleRelationsBetweenTables = false;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ColumnInfo> getRefColumns() {
        return this.refColumns;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public TableInfo getTableB() {
        return this.tableB;
    }

    public void setTableB(TableInfo tableB) {
        this.tableB = tableB;
        for (String colName : this.refColumnsAsString) {
            this.refColumns.add(tableB.getColumnMap().get(colName));
        }
    }

    public void setTableAB(TableInfo tableAB) {
        this.tableAB = tableAB;
    }

    public void initMultipleRelationsBetweenTables() {
        for (ForeignKey fk : this.tableA.getForeignKeys().values()) {
            if (fk == this || fk.getName().equals(this.getName()) || !fk.getRefTableName().equals(this.getRefTableName())) continue;
            this.multipleRelationsBetweenTables = true;
            break;
        }
    }

    public String getJoinOperation() {
        String ret = "";
        if (this.tableAB == null) {
            int fkColumns = this.getColumns().size();
            List<ColumnInfo> refColumns = this.getRefColumns();
            for (int i = 0; i < this.columns.size(); ++i) {
                ColumnInfo column = this.columns.get(i);
                ColumnInfo refColumn = refColumns.get(i);
                ret = ret + "this." + column.getAttributeName() + "=" + this.tableB.getClassName() + "." + refColumn.getAttributeName();
                if (i == fkColumns - 1) continue;
                ret = ret + " and ";
            }
        } else {
            ForeignKey[] fks = this.tableAB.getForeignKeys().values().toArray(new ForeignKey[2]);
            String ret1 = fks[0].getJoinOperation().replace("this.", this.tableAB.getClassName() + ".").replace(this.tableA.getClassName() + ".", "this.");
            String ret2 = fks[1].getJoinOperation().replace("this.", this.tableAB.getClassName() + ".");
            ret = ret1 + " and " + ret2;
        }
        return ret;
    }

    private static String concatenateColumnNames(ForeignKey fk) {
        String ret = "";
        List<ColumnInfo> columns = fk.getColumns();
        for (ColumnInfo col : columns) {
            String attributeName = col.getAttributeName();
            int idIndex = attributeName.lastIndexOf("Id");
            if (idIndex != -1) {
                attributeName = attributeName.substring(0, idIndex);
            }
            ret = ret + "_" + attributeName;
        }
        return ret;
    }

    public String getReverseRelationshipName() {
        String ret = "";
        if (this.tableAB == null) {
            if (this.multipleRelationsBetweenTables) {
                ret = ForeignKey.concatenateColumnNames(this);
                ret = ret.substring(1) + "_";
            }
            ret = ret + StringUtility.firstLetterToLower((String)this.tableA.getClassName());
        } else {
            ForeignKey[] fks = this.tableAB.getForeignKeys().values().toArray(new ForeignKey[2]);
            ret = ForeignKey.concatenateColumnNames(fks[0]).substring(1);
        }
        String multiplicity = this.getTableAMultiplicity();
        if (!multiplicity.equals("one")) {
            ret = StringUtility.englishPluralize((String)ret);
        }
        return ret;
    }

    public String getRelationshipName() {
        String ret;
        if (this.tableAB == null) {
            ret = ForeignKey.concatenateColumnNames(this);
            ret = ret.substring(1);
        } else {
            ForeignKey[] fks = this.tableAB.getForeignKeys().values().toArray(new ForeignKey[2]);
            ret = ForeignKey.concatenateColumnNames(fks[1]).substring(1);
        }
        String multiplicity = this.getTableBMultiplicity();
        if (!multiplicity.equals("one")) {
            ret = StringUtility.englishPluralize((String)ret);
        }
        return ret;
    }

    public String getTableAMultiplicity() {
        String ret = "many";
        List<ColumnInfo> tableAPKs = this.tableA.getPkList();
        if (tableAPKs.size() == 0 || this.tableA.getTableName().equals(this.tableB.getTableName())) {
            return ret;
        }
        if (this.tableAB == null) {
            List<ColumnInfo> fkColumns = this.getColumns();
            HashSet<ColumnInfo> columnSet = new HashSet<ColumnInfo>();
            columnSet.addAll(fkColumns);
            columnSet.removeAll(tableAPKs);
            if (fkColumns.size() == tableAPKs.size() && columnSet.isEmpty()) {
                ret = "one";
                return ret;
            }
        }
        for (ForeignKey tableBFK : this.tableB.getForeignKeys().values()) {
            if (!tableBFK.getTableB().getTableName().equals(this.tableA.getTableName())) continue;
            List<ColumnInfo> tableBRefCols = tableBFK.getRefColumns();
            HashSet<ColumnInfo> columns = new HashSet<ColumnInfo>();
            columns.addAll(tableBRefCols);
            columns.removeAll(tableAPKs);
            if (!columns.isEmpty()) continue;
            ret = "one";
            break;
        }
        return ret;
    }

    public String getTableBMultiplicity() {
        String ret = "one";
        if (this.tableAB != null) {
            ret = "many";
        }
        return ret;
    }

    public void addtRefColumnsAsString(String colName) {
        this.refColumnsAsString.add(colName);
    }
}

