/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.MithraGenerator;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.MithraObjectXmlGenerator;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullableColumnValidator
extends Task {
    private final MithraObjectXmlGenerator xmlGenerator;
    private String xml;
    private boolean executed = false;
    private List<MithraGeneratorImport> imports = new ArrayList<MithraGeneratorImport>();
    private final SortedMap<String, String> tablesMissingFromDb = new TreeMap<String, String>();
    private List<String> violations = new ArrayList<String>();
    private boolean autofixMithraNullableAttributes = false;

    public NullableColumnValidator() {
        this.xmlGenerator = new MithraObjectXmlGenerator();
        this.xmlGenerator.setExcludeAsOfAttributesFromDbIndex(false);
    }

    public boolean isAutofixMithraNullableAttributes() {
        return this.autofixMithraNullableAttributes;
    }

    public void setAutofixMithraNullableAttributes(boolean autofixMithraNullableAttributes) {
        this.autofixMithraNullableAttributes = autofixMithraNullableAttributes;
    }

    public void addImport(String dir, String fileName) {
        MithraGeneratorImport anImport = new MithraGeneratorImport();
        anImport.setDir(dir);
        anImport.setFilename(fileName);
        this.addConfiguredMithraImport(anImport);
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public Map<String, String> getTablesMissingFromDb() {
        return this.tablesMissingFromDb;
    }

    public void execute() throws BuildException {
        if (!this.executed) {
            try {
                this.validateNullableColumns();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.tablesMissingFromDb.isEmpty()) {
                this.log("The following tables are not found: " + this.tablesMissingFromDb.values(), 0);
            }
            if (!this.violations.isEmpty()) {
                throw new RuntimeException("The following violations are reported: " + this.violations);
            }
            this.executed = true;
        }
    }

    public void validateNullableColumns() throws IOException {
        Map<String, MithraObjectTypeWrapper> parsed = this.parseXmlAndGetMithraObjects(this.xml);
        this.validateNullableColumns(parsed.values());
    }

    public void validateNullableColumns(Collection<MithraObjectTypeWrapper> wrappers) throws IOException {
        List<MithraObjectTypeWrapper> typesForValidation = this.selectNotPureNotImported(wrappers);
        if (!typesForValidation.isEmpty()) {
            Map<String, TableInfo> tableInfo = this.generateTableInfo(typesForValidation);
            this.validate(typesForValidation, tableInfo);
        }
    }

    public void addConfiguredMithraImport(MithraGeneratorImport imp) {
        this.imports.add(imp);
    }

    private Map<String, TableInfo> generateTableInfo(List<MithraObjectTypeWrapper> wrappers) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < wrappers.size(); ++i) {
            tableNames.add(wrappers.get(i).getDefaultTable());
        }
        this.xmlGenerator.setIncludeList(tableNames);
        this.xmlGenerator.setGeneratedPackageName("test");
        return this.xmlGenerator.processTableInfo();
    }

    private void validate(List<MithraObjectTypeWrapper> typeWrappers, Map<String, TableInfo> tableInfo) throws IOException {
        for (int i = 0; i < typeWrappers.size(); ++i) {
            MithraObjectTypeWrapper typeWrapper = typeWrappers.get(i);
            String tableName = typeWrapper.getDefaultTable();
            TableInfo tableDetails = tableInfo.get(tableName);
            String mithraObjectClassName = typeWrapper.getClassName();
            if (tableDetails == null) {
                this.tablesMissingFromDb.put(mithraObjectClassName, "Mithra object: " + mithraObjectClassName + ", missing table: " + tableName);
                continue;
            }
            Attribute[] attributes = typeWrapper.getAttributes();
            for (int j = 0; j < attributes.length; ++j) {
                Attribute nextAttribute = attributes[j];
                ColumnInfo dbColumnInfo = tableDetails.findColumnInfo(nextAttribute.getColumnName());
                if (dbColumnInfo == null || dbColumnInfo.isNullable() == nextAttribute.isNullable()) continue;
                this.violations.add("Mithra xml: " + mithraObjectClassName + " db table: " + tableName + " column: " + dbColumnInfo.getColumnName() + " mithra col name: " + nextAttribute.getName() + " is db nullable? " + dbColumnInfo.isNullable() + " is mithra nullable? " + nextAttribute.isNullable() + "\n");
                if (!this.autofixMithraNullableAttributes || !nextAttribute.isNullable()) continue;
                String fileName = this.createFileName(nextAttribute);
                String text = this.readFile(fileName);
                String columnName = "\"" + dbColumnInfo.getColumnName() + "\"";
                text = text.replaceFirst(columnName, columnName + " nullable=\"" + dbColumnInfo.isNullable() + "\"");
                this.writeFile(fileName, text);
            }
        }
    }

    private Map<String, MithraObjectTypeWrapper> parseXmlAndGetMithraObjects(String xml) {
        MithraGenerator mithraGenerator = new MithraGenerator();
        mithraGenerator.setXml(xml);
        for (MithraGeneratorImport anImport : this.imports) {
            mithraGenerator.addConfiguredMithraImport(anImport);
        }
        try {
            mithraGenerator.parseAndValidate();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return mithraGenerator.getMithraObjects();
    }

    private List<MithraObjectTypeWrapper> selectNotPureNotImported(Collection<MithraObjectTypeWrapper> values) {
        ArrayList<MithraObjectTypeWrapper> list = new ArrayList<MithraObjectTypeWrapper>();
        for (MithraObjectTypeWrapper wrapper : values) {
            if (wrapper.isPure() || wrapper.isImported() || wrapper.isTablePerSubclassSuperClass()) continue;
            list.add(wrapper);
        }
        return list;
    }

    public String getUserName() {
        return this.xmlGenerator.getUserName();
    }

    public void setUserName(String userName) {
        this.xmlGenerator.setUserName(userName);
    }

    public String getPassword() {
        return this.xmlGenerator.getPassword();
    }

    public void setPassword(String password) {
        this.xmlGenerator.setPassword(password);
    }

    public String getDatabaseType() {
        return this.xmlGenerator.getDatabaseType();
    }

    public void setDatabaseType(String databaseType) throws BuildException {
        this.xmlGenerator.setDatabaseType(databaseType);
    }

    public String getDriver() {
        return this.xmlGenerator.getDriver();
    }

    public void setDriver(String driver) {
        this.xmlGenerator.setDriver(driver);
    }

    public void setLdapName(String ldapName) {
        this.xmlGenerator.setLdapName(ldapName);
    }

    public String getLdapName() {
        return this.xmlGenerator.getLdapName();
    }

    public String getUrl() {
        return this.xmlGenerator.getUrl();
    }

    public void setUrl(String url) {
        this.xmlGenerator.setUrl(url);
    }

    public void setSchema(String schema) {
        this.xmlGenerator.setSchema(schema);
    }

    public String getSchema() {
        return this.xmlGenerator.getSchema();
    }

    private String extractOwnerClassName(Attribute missingLenAttribute) {
        return missingLenAttribute.getOriginalOwner() == null ? missingLenAttribute.getOwner().getClassName() : missingLenAttribute.getOriginalOwner().getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String filename) throws IOException {
        BufferedReader in = null;
        try {
            String nextLine;
            in = new BufferedReader(new FileReader(filename));
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            while ((nextLine = in.readLine()) != null) {
                writer.println(nextLine);
            }
            writer.flush();
            String string = stringWriter.toString();
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private String createFileName(Attribute missingLenAttribute) {
        return new File(this.getXml()).getParent() + File.separator + this.extractOwnerClassName(missingLenAttribute) + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String filename, String text) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filename, false));
            writer.write(text);
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

