/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.AsOfAttributeNamePair;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ForeignKey;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.IndexInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.MithraObjectXmlGenerator;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfo {
    protected static final Logger logger = LoggerFactory.getLogger(MithraObjectXmlGenerator.class);
    private String tableName;
    private Map<String, ColumnInfo> columnMap = new HashMap<String, ColumnInfo>();
    private List<ColumnInfo> asOfList = new ArrayList<ColumnInfo>();
    private List<ColumnInfo> pkList = new ArrayList<ColumnInfo>();
    private Map<String, ForeignKey> foreignKeys = new HashMap<String, ForeignKey>();
    private Map<String, IndexInfo> indexMap = new HashMap<String, IndexInfo>();
    private List<AsOfAttributeNamePair> asOfNamePairs = new ArrayList<AsOfAttributeNamePair>();

    public TableInfo() {
        this.asOfNamePairs.add(new AsOfAttributeNamePair("IN_Z", "OUT_Z", "processingDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("FROM_Z", "THRU_Z", "businessDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("IN_TMSTMP", "OUT_TMSTMP", "processingDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("EFF_TMSTMP", "EXP_TMSTMP", "businessDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("FROM_DATE_Z", "THRU_DATE_Z", "businessDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("IN_DATE_Z", "OUT_DATE_Z", "processingDate"));
        this.asOfNamePairs.add(new AsOfAttributeNamePair("IN_UTC", "OUT_UTC", "processingDate"));
    }

    public String getTableName() {
        return this.tableName;
    }

    public void removeForeignKeysForMissingTables(Set<String> tableNames) {
        Iterator<Map.Entry<String, ForeignKey>> iterator = this.getForeignKeys().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ForeignKey> entry = iterator.next();
            if (tableNames.contains(entry.getValue().getRefTableName())) continue;
            iterator.remove();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ColumnInfo findColumnInfo(String columnName) {
        return this.columnMap.get(columnName);
    }

    public Map<String, ColumnInfo> getColumnMap() {
        return this.columnMap;
    }

    public List<ColumnInfo> getAsOfList() {
        return this.asOfList;
    }

    public List<ColumnInfo> getPkList() {
        if (this.pkList == null) {
            this.pkList = new ArrayList<ColumnInfo>();
        }
        return this.pkList;
    }

    public Map<String, IndexInfo> getIndexMap() {
        if (this.indexMap == null) {
            this.indexMap = new HashMap<String, IndexInfo>();
        }
        return this.indexMap;
    }

    public void addToColumnList(ColumnInfo columnInfo) {
        for (AsOfAttributeNamePair pair : this.asOfNamePairs) {
            if (pair.isAnAsOfAttribute(columnInfo)) {
                columnInfo.setAsOfAttribute(true);
            }
            if (!pair.completesPair(columnInfo)) continue;
            ColumnInfo startColumn = pair.getStartColumn();
            ColumnInfo endColumn = pair.getEndColumn();
            startColumn.setAsOfAttribute(true);
            startColumn.setRelatedAsOfColumn(endColumn);
            startColumn.setAsOfAttributeName(pair.getDateType());
            startColumn.setAsOfAttributeFrom(true);
            this.asOfList.add(startColumn);
        }
        this.columnMap.put(columnInfo.getColumnName(), columnInfo);
    }

    public void populateTableInfoWithMetaData(DatabaseMetaData metaData, String catalog, String schema, DatabaseType dbType, boolean excludeAsOfAttributesFromDbIndex) {
        this.populatePrimaryKey(metaData, catalog, schema);
        this.populateColumnList(metaData, catalog, schema, dbType);
        this.populateIndices(metaData, catalog, schema, excludeAsOfAttributesFromDbIndex);
        this.populateForeignKeys(metaData, catalog, schema);
    }

    public void populateColumnList(DatabaseMetaData metaData, String catalog, String schema, DatabaseType dbType) {
        ResultSet rs = null;
        try {
            rs = metaData.getColumns(catalog, schema, this.tableName, "%");
            ResultSetMetaData tableMetadata = this.getTableMetadata(metaData, dbType, catalog, schema);
            int columnCount = 1;
            while (rs.next()) {
                ColumnInfo columnInfo = this.generateColumnListing(rs);
                columnInfo.setIdentity(tableMetadata.isAutoIncrement(columnCount++));
                this.addToColumnList(columnInfo);
            }
            this.closeResultSet(rs);
        }
        catch (SQLException e) {
            try {
                logger.error("", (Throwable)e);
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        for (AsOfAttributeNamePair pair : this.asOfNamePairs) {
            pair.markIncompleteAsNormalAttribute();
        }
    }

    public String getClassName() {
        return StringUtility.toCamelCaseIgnoringLastChar((String)this.getTableName(), (String)"_", (boolean)true);
    }

    private void populateForeignKeys(DatabaseMetaData metaData, String catalog, String schema) {
        ResultSet rs = null;
        try {
            rs = metaData.getImportedKeys(catalog, schema, this.tableName);
            while (rs.next()) {
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColName = rs.getString("PKCOLUMN_NAME");
                String fkColName = rs.getString("FKCOLUMN_NAME");
                String name = rs.getString("FK_NAME");
                ForeignKey fk = this.foreignKeys.get(name);
                if (fk == null) {
                    fk = new ForeignKey(this, name, pkTableName);
                    this.foreignKeys.put(name, fk);
                }
                fk.addtRefColumnsAsString(pkColName);
                fk.getColumns().add(this.columnMap.get(fkColName));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not retrieve foreign keys", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void populateIndices(DatabaseMetaData metaData, String catalog, String schema, boolean excludeAsOfAttributesFromDbIndex) {
        ResultSet rs = null;
        try {
            IndexInfo indexInfo;
            rs = metaData.getIndexInfo(catalog, schema, this.tableName, false, false);
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null) continue;
                String columnName = rs.getString("COLUMN_NAME");
                boolean indexUnique = !rs.getBoolean("NON_UNIQUE");
                ColumnInfo columnInfo = this.columnMap.get(columnName);
                if (excludeAsOfAttributesFromDbIndex && columnInfo.isAsOfAttribute()) continue;
                if (this.indexMap.containsKey(indexName)) {
                    this.indexMap.get(indexName).getColumnInfoList().add(columnInfo);
                    continue;
                }
                IndexInfo indexInfo2 = new IndexInfo();
                indexInfo2.setName(indexName);
                indexInfo2.setUnique(indexUnique);
                ArrayList<ColumnInfo> indexColumnList = indexInfo2.getColumnInfoList();
                indexColumnList.add(columnInfo);
                if (this.alreadyInIndices(indexInfo2) || this.alreadyInPk(indexInfo2)) continue;
                this.indexMap.put(indexName, indexInfo2);
            }
            this.closeResultSet(rs);
            if (this.pkList.isEmpty()) {
                Iterator<IndexInfo> mapIt = this.indexMap.values().iterator();
                while (mapIt.hasNext()) {
                    indexInfo = mapIt.next();
                    if (!indexInfo.isUnique()) continue;
                    this.pkList = indexInfo.getColumnInfoList();
                    for (int i = 0; i < this.pkList.size(); ++i) {
                        this.pkList.get(i).setPartOfPk(true);
                    }
                    mapIt.remove();
                    break;
                }
            } else {
                Iterator<IndexInfo> indexIterator = this.indexMap.values().iterator();
                while (indexIterator.hasNext()) {
                    indexInfo = indexIterator.next();
                    ArrayList<ColumnInfo> indexColumns = indexInfo.getColumnInfoList();
                    if (indexColumns.size() != this.pkList.size()) continue;
                    boolean match = true;
                    for (int i = 0; i < this.pkList.size() && match; ++i) {
                        match = indexColumns.contains(this.pkList.get(i));
                    }
                    if (!match) continue;
                    indexIterator.remove();
                }
            }
            if (this.pkList.isEmpty()) {
                logger.error("No primary key for " + this.tableName + "!");
            }
            this.closeResultSet(rs);
        }
        catch (SQLException e) {
            try {
                logger.error("", (Throwable)e);
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    private void populatePrimaryKey(DatabaseMetaData metaData, String catalog, String schema) {
        ResultSet rs = null;
        try {
            rs = metaData.getPrimaryKeys(catalog, schema, this.tableName);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                ColumnInfo columnInfo = new ColumnInfo(columnName, this, true);
                this.pkList.add(columnInfo);
            }
            this.closeResultSet(rs);
            this.closeResultSet(rs);
        }
        catch (SQLException e) {
            try {
                logger.error("", (Throwable)e);
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    private boolean alreadyInList(IndexInfo indexInfo, List<ColumnInfo> list) {
        ArrayList<ColumnInfo> indexColumns = indexInfo.getColumnInfoList();
        if (list.size() != indexColumns.size()) {
            return false;
        }
        int matchCount = 0;
        Iterator<ColumnInfo> it = list.iterator();
        while (it.hasNext()) {
            if (!indexColumns.contains(it.next())) continue;
            ++matchCount;
        }
        return list.size() == matchCount;
    }

    private boolean alreadyInPk(IndexInfo indexInfo) {
        return this.alreadyInList(indexInfo, this.pkList);
    }

    private boolean alreadyInIndices(IndexInfo indexInfo) {
        Iterator<IndexInfo> it = this.indexMap.values().iterator();
        while (it.hasNext()) {
            if (!this.alreadyInList(indexInfo, it.next().getColumnInfoList())) continue;
            return true;
        }
        return false;
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error("", (Throwable)e);
                throw new BuildException();
            }
        }
    }

    private ColumnInfo generateColumnListing(ResultSet rs) throws SQLException {
        ColumnInfo columnInfo = new ColumnInfo(this);
        columnInfo.setResultSet(rs);
        if (this.pkList.contains(columnInfo)) {
            columnInfo.setPartOfPk(true);
        }
        return columnInfo;
    }

    private ResultSetMetaData getTableMetadata(DatabaseMetaData metaData, DatabaseType dt, String catalog, String schemaName) throws SQLException {
        Connection connection = metaData.getConnection();
        connection.setCatalog(catalog);
        PreparedStatement ps = connection.prepareStatement("select * from " + dt.getFullyQualifiedTableName(schemaName, this.tableName) + " where 1=2");
        ResultSet rs = ps.executeQuery();
        return rs.getMetaData();
    }

    public Map<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isManyToManyTable() {
        List<ColumnInfo> pk = this.getPkList();
        if (pk == null || pk.isEmpty() || pk.size() != this.getColumnMap().size()) {
            return false;
        }
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        for (ForeignKey fkey : this.getForeignKeys().values()) {
            foreignKeys.add(fkey);
            if (foreignKeys.size() <= 2) continue;
            return false;
        }
        if (foreignKeys.size() != 2) {
            return false;
        }
        HashSet<String> columns = new HashSet<String>();
        for (ColumnInfo column : this.getColumnMap().values()) {
            columns.add(column.getColumnName());
        }
        for (ForeignKey foreignKey : this.getForeignKeys().values()) {
            for (ColumnInfo fkColumn : foreignKey.getColumns()) {
                columns.remove(fkColumn.getColumnName());
            }
            if (!columns.isEmpty()) continue;
            break;
        }
        return columns.isEmpty();
    }
}

