/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.dbgenerator;

import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.databasetype.OracleDatabaseType;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.Index;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.AbstractGeneratorDatabaseType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class OracleGeneratorDatabaseType
extends AbstractGeneratorDatabaseType {
    private static final int ORACLE_MAX_INDEX_NAME = 30;

    @Override
    protected DatabaseType getDatabaseType() {
        return OracleDatabaseType.getInstance();
    }

    @Override
    protected CommonDatabaseType getGeneratorDatabaseType() {
        return com.gs.fw.common.mithra.generator.databasetype.OracleDatabaseType.getInstance();
    }

    @Override
    public void generateDdlFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        String tableName = wrapper.getDefaultTable();
        PrintWriter writer = this.getDdlPrintWriter(wrapper, outDir);
        writer.println("create table " + tableName);
        writer.println("(");
        Attribute[] attributes = wrapper.getAttributes();
        this.generateDdlColumnList(attributes, writer);
        writer.println(")");
        writer.println("/");
        writer.close();
    }

    @Override
    public void generateIdxFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        PrintWriter writer = this.getIdxPrintWriter(wrapper, outDir);
        ArrayList indices = wrapper.getPrefixFreeIndices();
        String tableName = wrapper.getDefaultTable();
        boolean firstPk = true;
        for (int i = 0; i < indices.size(); ++i) {
            Index index = (Index)indices.get(i);
            if (index.isPk() && firstPk) {
                writer.println("alter table " + tableName + " add constraint " + this.getFixedIndexName(index) + " primary key (" + index.getIndexColumns() + ")");
                firstPk = false;
            } else {
                writer.println("create " + (index.isUnique() ? "unique " : "") + "index " + this.getFixedIndexName(index) + " on " + tableName + "(" + index.getIndexColumns() + ")");
            }
            writer.println("/");
        }
        writer.close();
    }

    private String getFixedIndexName(Index index) {
        String name = index.getName();
        if (name.length() > 30) {
            int targetLength = 30;
            int idxIndex = name.toUpperCase().lastIndexOf("_IDX");
            if (idxIndex <= 0) {
                idxIndex = name.toUpperCase().lastIndexOf("_PK");
            }
            if (idxIndex > 0) {
                name = name.substring(0, idxIndex);
                targetLength = 30 - (index.getName().length() - idxIndex);
            }
            StringBuilder builder = this.fixStringLength(name, targetLength);
            if (idxIndex > 0) {
                builder.append(index.getName().substring(idxIndex));
            }
            name = builder.toString();
        }
        return name;
    }

    @Override
    public void generateFkFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        this.printFkFile(wrapper, outDir, this);
    }

    @Override
    public String getStatementTerminator() {
        return "\n/";
    }

    @Override
    protected void generateNullStatement(PrintWriter writer, Attribute[] attributes, String attributeSqlType, int i) {
        writer.println("    " + attributes[i].getColumnName() + " " + attributeSqlType + (attributes[i].isNullable() ? "" : " not null") + (i < attributes.length - 1 ? "," : ""));
    }

    @Override
    protected int getMaxConstraintLength() {
        return 30;
    }
}

