/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.dbgenerator;

import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.databasetype.SybaseDatabaseType;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.Index;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.AbstractGeneratorDatabaseType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class SybaseGeneratorDatabaseType
extends AbstractGeneratorDatabaseType {
    @Override
    protected DatabaseType getDatabaseType() {
        return SybaseDatabaseType.getInstance();
    }

    @Override
    protected CommonDatabaseType getGeneratorDatabaseType() {
        return com.gs.fw.common.mithra.generator.databasetype.SybaseDatabaseType.getInstance();
    }

    @Override
    public String getStatementTerminator() {
        return "\nGO";
    }

    @Override
    public void generateDdlFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        String tableName = wrapper.getDefaultTable();
        PrintWriter writer = this.getDdlPrintWriter(wrapper, outDir);
        writer.println("if exists (select * from sysobjects where name = '" + tableName + "' and type='U')");
        writer.println("    drop table " + tableName);
        writer.println("GO");
        writer.println();
        writer.println("create table " + tableName);
        writer.println("(");
        Attribute[] attributes = wrapper.getAttributes();
        this.generateDdlColumnList(attributes, writer);
        writer.println(")");
        writer.println("GO");
        writer.println();
        writer.close();
    }

    @Override
    public void generateIdxFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        PrintWriter writer = this.getIdxPrintWriter(wrapper, outDir);
        ArrayList indices = wrapper.getPrefixFreeIndices();
        String tableName = wrapper.getDefaultTable();
        for (int i = 0; i < indices.size(); ++i) {
            Index index = (Index)indices.get(i);
            writer.println("if exists (select * from sysindexes where name = '" + index.getName() + "' and id = object_id('" + tableName + "'))");
            writer.println("    drop index " + tableName + "." + index.getName());
            writer.println("GO");
            writer.println();
            writer.println("create " + (index.isUnique() ? "unique " : "") + "index " + index.getName() + " on " + tableName + "(" + index.getIndexColumns() + ")");
            writer.println("GO");
            writer.println();
        }
        writer.close();
    }

    @Override
    public void generateFkFile(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        this.printFkFile(wrapper, outDir, this);
    }

    @Override
    protected void generateNullStatement(PrintWriter writer, Attribute[] attributes, String attributeSqlType, int i) {
        writer.println("    " + attributes[i].getColumnName() + " " + attributeSqlType + (attributes[i].isNullable() ? " null" : " not null") + (i < attributes.length - 1 ? "," : ""));
    }

    @Override
    protected int getMaxConstraintLength() {
        return 255;
    }
}

