/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.MithraGenerator;
import com.gs.fw.common.mithra.generator.MithraGeneratorImport;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.MithraObjectXmlGenerator;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import com.gs.fw.common.mithra.generator.type.StringJavaType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MaxLenValidator
extends Task {
    private final MithraObjectXmlGenerator xmlGenerator = new MithraObjectXmlGenerator();
    private String xml;
    private boolean executed = false;
    private List<MithraGeneratorImport> imports = new ArrayList<MithraGeneratorImport>();

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public void execute() throws BuildException {
        if (!this.executed) {
            Map<String, MithraObjectTypeWrapper> parsed = this.parseXmlAndGetMithraObjects(this.xml);
            this.validateMaxLength(parsed.values());
            this.executed = true;
        }
    }

    public void validateMaxLength(Collection<MithraObjectTypeWrapper> wrappers) {
        List<MithraObjectTypeWrapper> typesWithMissingMaxLength = this.selectNotPureNotImportedWithMissingMaxLength(wrappers);
        if (!typesWithMissingMaxLength.isEmpty()) {
            Map<String, TableInfo> tableInfo = this.generateTableInfo(typesWithMissingMaxLength);
            this.fixMaxLengthAndAddTruncate(typesWithMissingMaxLength, tableInfo);
        }
    }

    public void addConfiguredMithraImport(MithraGeneratorImport imp) {
        this.imports.add(imp);
    }

    private Map<String, TableInfo> generateTableInfo(List<MithraObjectTypeWrapper> wrappers) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < wrappers.size(); ++i) {
            tableNames.add(wrappers.get(i).getDefaultTable());
        }
        this.xmlGenerator.setIncludeList(tableNames);
        this.xmlGenerator.setGeneratedPackageName("test");
        return this.xmlGenerator.processTableInfo();
    }

    private List<Attribute> validateForAmbiguousMaxLen(List<MithraObjectTypeWrapper> wrappersWithMissingMaxLength, Map<String, TableInfo> tableInfo) {
        HashMap<Attribute, Set<Integer>> superClassAttributeMaxLen = new HashMap<Attribute, Set<Integer>>();
        for (MithraObjectTypeWrapper wrapper : wrappersWithMissingMaxLength) {
            Attribute[] attributes = wrapper.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Attribute attribute = attributes[i];
                this.validateMaxLenForAttribute(wrapper, attribute, tableInfo, superClassAttributeMaxLen);
            }
        }
        return this.selectViolations(superClassAttributeMaxLen);
    }

    private Set<String> getDetailsForAttribute(Attribute attribute, List<MithraObjectTypeWrapper> wrappers) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < wrappers.size(); ++i) {
            MithraObjectTypeWrapper wrapper = wrappers.get(i);
            Attribute[] attributes = wrapper.getAttributes();
            for (int j = 0; j < attributes.length; ++j) {
                Attribute nextAttribute = attributes[j];
                if (!this.getKeyAttribute(nextAttribute).equals((Object)attribute)) continue;
                classNames.add(this.createDisplayString(wrapper.getClassName(), attribute.getName()));
            }
        }
        return classNames;
    }

    private void validateMaxLenForAttribute(MithraObjectTypeWrapper wrapper, Attribute attribute, Map<String, TableInfo> tableInfo, Map<Attribute, Set<Integer>> superClassAttributeMaxLen) {
        ColumnInfo columnInfo;
        TableInfo info;
        Attribute key = this.getKeyAttribute(attribute);
        if (this.isMissingMaxLen(attribute) && this.isDifferentOwner(attribute) && (info = tableInfo.get(wrapper.getDefaultTable())) != null && (columnInfo = info.findColumnInfo(attribute.getColumnName())) != null) {
            int columnLen = columnInfo.getColumnSize();
            Set<Integer> maxLen = superClassAttributeMaxLen.get(key);
            if (maxLen == null) {
                maxLen = new HashSet<Integer>();
                superClassAttributeMaxLen.put(key, maxLen);
            }
            maxLen.add(columnLen);
        }
    }

    private Attribute getKeyAttribute(Attribute attribute) {
        Attribute key = attribute;
        if (attribute.getOriginalOwner() != null) {
            key = attribute.getOriginalOwner().getAttributeByName(attribute.getName());
        }
        return key;
    }

    private boolean isDifferentOwner(Attribute attribute) {
        return !this.extractOwnerClassName(attribute).equals(attribute.getOwner().getClassName());
    }

    private List<Attribute> selectViolations(Map<Attribute, Set<Integer>> superClassAttributeMaxLen) {
        ArrayList<Attribute> violations = new ArrayList<Attribute>();
        for (Attribute attribute : superClassAttributeMaxLen.keySet()) {
            Set<Integer> maxLenFromDifferentTables = superClassAttributeMaxLen.get(attribute);
            if (maxLenFromDifferentTables.size() <= 1) continue;
            violations.add(attribute);
        }
        return violations;
    }

    private List<String> validateForMissingTables(List<MithraObjectTypeWrapper> wrappersWithMissingMaxLength, Collection<String> tableNames) {
        ArrayList<String> missingTableNames = new ArrayList<String>();
        for (int i = 0; i < wrappersWithMissingMaxLength.size(); ++i) {
            MithraObjectTypeWrapper nextWrapper = wrappersWithMissingMaxLength.get(i);
            if (tableNames.contains(nextWrapper.getDefaultTable())) continue;
            missingTableNames.add(nextWrapper.getClassName());
        }
        return missingTableNames;
    }

    private void fixMaxLengthAndAddTruncate(List<MithraObjectTypeWrapper> wrappersWithMissingMaxLength, Map<String, TableInfo> tableInfo) {
        List<Attribute> ambiguousMaxLenViolations = this.validateForAmbiguousMaxLen(wrappersWithMissingMaxLength, tableInfo);
        List<String> missingTablesViolations = this.validateForMissingTables(wrappersWithMissingMaxLength, tableInfo.keySet());
        AddMaxLenAndTruncateTrueBlock block = new AddMaxLenAndTruncateTrueBlock(tableInfo, ambiguousMaxLenViolations);
        for (int i = 0; i < wrappersWithMissingMaxLength.size(); ++i) {
            MithraObjectTypeWrapper wrapper = wrappersWithMissingMaxLength.get(i);
            if (missingTablesViolations.contains(wrapper.getClassName())) continue;
            List<Attribute> missingLenAttributes = this.selectMissingMaxLenAttributes(wrapper.getAttributes());
            for (int j = 0; j < missingLenAttributes.size(); ++j) {
                block.execute(missingLenAttributes.get(j), wrapper);
            }
        }
        this.checkForExceptions(ambiguousMaxLenViolations, missingTablesViolations, block.getAttributesNotFound(), block.getDbColumnNotFound(), wrappersWithMissingMaxLength);
    }

    private String createDisplayString(String one, String two) {
        return one + ";" + two;
    }

    private List<Attribute> selectMissingMaxLenAttributes(Attribute[] attributes) {
        ArrayList<Attribute> resultAttributes = new ArrayList<Attribute>();
        for (int i = 0; i < attributes.length; ++i) {
            Attribute nextAttribute = attributes[i];
            if (!this.isMissingMaxLen(nextAttribute)) continue;
            resultAttributes.add(nextAttribute);
        }
        return resultAttributes;
    }

    private void checkForExceptions(Collection<Attribute> ambiguousMaxLenViolations, Collection<String> missingTablesViolations, Collection<String> attributesNotFound, Collection<String> dbColumnNotFound, List<MithraObjectTypeWrapper> wrappersWithMissingMaxLength) {
        String errors = "";
        if (!ambiguousMaxLenViolations.isEmpty()) {
            ArrayList<String> formattedErrors = new ArrayList<String>();
            for (Attribute nextAttribute : ambiguousMaxLenViolations) {
                formattedErrors.add(this.createDisplayString("Problematic class: " + nextAttribute.getOwner().getClassName(), "Classes that might've contributed to conflicting len: " + this.getDetailsForAttribute(nextAttribute, wrappersWithMissingMaxLength).toString() + "\n"));
            }
            errors = errors + "The following objects are sourced from tables that have different max len for the same attribute.\n" + formattedErrors + "\n\n";
        }
        if (!missingTablesViolations.isEmpty()) {
            errors = errors + " Didn't find table(s) in database for the following object(s):\n " + missingTablesViolations + "\n\n";
        }
        if (!attributesNotFound.isEmpty()) {
            errors = errors + " Didn't find attributes in mithra xml for:\n" + attributesNotFound + "\n\n";
        }
        if (!dbColumnNotFound.isEmpty()) {
            errors = errors + " Didn't find db columns for:\n" + dbColumnNotFound;
        }
        if (errors.length() > 0) {
            throw new BuildException(errors);
        }
    }

    private Map<String, MithraObjectTypeWrapper> parseXmlAndGetMithraObjects(String xml) {
        MithraGenerator mithraGenerator = new MithraGenerator();
        mithraGenerator.setXml(xml);
        for (int i = 0; i < this.imports.size(); ++i) {
            mithraGenerator.addConfiguredMithraImport(this.imports.get(i));
        }
        try {
            mithraGenerator.parseAndValidate();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return mithraGenerator.getMithraObjects();
    }

    private List<MithraObjectTypeWrapper> selectNotPureNotImportedWithMissingMaxLength(Collection<MithraObjectTypeWrapper> values) {
        ArrayList<MithraObjectTypeWrapper> typesWithMissingMaxLen = new ArrayList<MithraObjectTypeWrapper>();
        for (MithraObjectTypeWrapper wrapper : values) {
            if (wrapper.isPure() || wrapper.isImported() || wrapper.isTablePerSubclassSuperClass() || !this.hasMissingLenType(wrapper.getAttributes())) continue;
            typesWithMissingMaxLen.add(wrapper);
        }
        return typesWithMissingMaxLen;
    }

    private boolean hasMissingLenType(Attribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!this.isMissingMaxLen(attribute)) continue;
            return true;
        }
        return false;
    }

    private boolean isMissingMaxLen(Attribute attribute) {
        return attribute.getType() instanceof StringJavaType && attribute.getMaxLength() == 0;
    }

    public String getUserName() {
        return this.xmlGenerator.getUserName();
    }

    public void setUserName(String userName) {
        this.xmlGenerator.setUserName(userName);
    }

    public String getPassword() {
        return this.xmlGenerator.getPassword();
    }

    public void setPassword(String password) {
        this.xmlGenerator.setPassword(password);
    }

    public String getDatabaseType() {
        return this.xmlGenerator.getDatabaseType();
    }

    public void setDatabaseType(String databaseType) throws BuildException {
        this.xmlGenerator.setDatabaseType(databaseType);
    }

    public String getDriver() {
        return this.xmlGenerator.getDriver();
    }

    public void setDriver(String driver) {
        this.xmlGenerator.setDriver(driver);
    }

    public void setLdapName(String ldapName) {
        this.xmlGenerator.setLdapName(ldapName);
    }

    public String getLdapName() {
        return this.xmlGenerator.getLdapName();
    }

    public String getUrl() {
        return this.xmlGenerator.getUrl();
    }

    public void setUrl(String url) {
        this.xmlGenerator.setUrl(url);
    }

    public void setSchema(String schema) {
        this.xmlGenerator.setSchema(schema);
    }

    public String getSchema() {
        return this.xmlGenerator.getSchema();
    }

    private String extractOwnerClassName(Attribute missingLenAttribute) {
        return missingLenAttribute.getOriginalOwner() == null ? missingLenAttribute.getOwner().getClassName() : missingLenAttribute.getOriginalOwner().getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String filename) throws IOException {
        try (BufferedReader in = null;){
            String nextLine;
            in = new BufferedReader(new FileReader(filename));
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            while ((nextLine = in.readLine()) != null) {
                writer.println(nextLine);
            }
            writer.flush();
            String string = stringWriter.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String filename, String text) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(filename, false));
            writer.write(text);
            writer.flush();
        }
    }

    private class AddMaxLenAndTruncateTrueBlock {
        private final Map<String, TableInfo> tableInfo;
        private final List<Attribute> ambiguousMaxLenViolations;
        final List<String> attributesNotFound = new ArrayList<String>();
        final List<String> dbColumnNotFound = new ArrayList<String>();
        final Set<Attribute> fixedAttributes = new HashSet<Attribute>();

        public AddMaxLenAndTruncateTrueBlock(Map<String, TableInfo> tableInfo, List<Attribute> ambiguousMaxLenViolations) {
            this.tableInfo = tableInfo;
            this.ambiguousMaxLenViolations = ambiguousMaxLenViolations;
        }

        public List<String> getAttributesNotFound() {
            return this.attributesNotFound;
        }

        public List<String> getDbColumnNotFound() {
            return this.dbColumnNotFound;
        }

        public void execute(Attribute attribute, MithraObjectTypeWrapper missingObjectTypeWrapper) {
            try {
                TableInfo info = this.tableInfo.get(missingObjectTypeWrapper.getDefaultTable());
                ColumnInfo columnInfo = info.findColumnInfo(attribute.getColumnName());
                String attributeName = attribute.getName();
                if (columnInfo == null) {
                    this.dbColumnNotFound.add(MaxLenValidator.this.createDisplayString(MaxLenValidator.this.extractOwnerClassName(attribute), attributeName));
                    return;
                }
                Attribute keyAttribute = MaxLenValidator.this.getKeyAttribute(attribute);
                if (!this.ambiguousMaxLenViolations.contains(keyAttribute) && !this.fixedAttributes.contains(keyAttribute)) {
                    this.fixedAttributes.add(keyAttribute);
                    String columnName = "\"" + columnInfo.getColumnName() + "\"";
                    String fileName = this.createFileName(attribute);
                    String fileAsString = MaxLenValidator.this.readFile(fileName);
                    if (fileAsString.contains(columnName)) {
                        fileAsString = fileAsString.replaceFirst(columnName, columnName + " maxLength=\"" + columnInfo.getColumnSize() + "\" truncate=\"true\"");
                        MaxLenValidator.this.writeFile(fileName, fileAsString);
                    } else {
                        this.attributesNotFound.add(MaxLenValidator.this.createDisplayString(MaxLenValidator.this.extractOwnerClassName(attribute), attributeName));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String createFileName(Attribute missingLenAttribute) {
            return new File(MaxLenValidator.this.getXml()).getParent() + File.separator + MaxLenValidator.this.extractOwnerClassName(missingLenAttribute) + ".xml";
        }
    }
}

