/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.dbgenerator;

import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.Cardinality;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.RelationshipAttribute;
import com.gs.fw.common.mithra.generator.databasetype.CommonDatabaseType;
import com.gs.fw.common.mithra.generator.mapper.Join;
import com.gs.fw.common.mithra.generator.mapper.RelationshipConversionVisitor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

public abstract class AbstractGeneratorDatabaseType {
    protected final int DEFAULT_VARCHAR_MAX_LENGTH = 255;
    private final HashMap<String, HashSet> foreignKeysByTable = new HashMap();

    protected AbstractGeneratorDatabaseType() {
    }

    protected abstract DatabaseType getDatabaseType();

    protected abstract CommonDatabaseType getGeneratorDatabaseType();

    public abstract void generateDdlFile(MithraObjectTypeWrapper var1, File var2) throws IOException;

    public abstract void generateIdxFile(MithraObjectTypeWrapper var1, File var2) throws IOException;

    public abstract void generateFkFile(MithraObjectTypeWrapper var1, File var2) throws IOException;

    public abstract String getStatementTerminator();

    protected PrintWriter getDdlPrintWriter(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        File outDdl = new File(outDir, wrapper.getDefaultTable() + ".ddl");
        return new PrintWriter(new BufferedWriter(new FileWriter(outDdl)));
    }

    protected PrintWriter getIdxPrintWriter(MithraObjectTypeWrapper wrapper, File outDir) throws IOException {
        File outIdx = new File(outDir, wrapper.getDefaultTable() + ".idx");
        return new PrintWriter(new BufferedWriter(new FileWriter(outIdx)));
    }

    protected void generateDdlColumnList(Attribute[] attributes, PrintWriter writer) {
        for (int i = 0; i < attributes.length; ++i) {
            String attributeSqlType = attributes[i].getType().getSqlDataType(this.getGeneratorDatabaseType(), attributes[i].isNullable());
            if (attributes[i].isIdentity()) {
                attributeSqlType = attributeSqlType + this.getDatabaseType().getIdentityTableCreationStatement();
            } else if (attributeSqlType.equalsIgnoreCase("varchar")) {
                int attributeMaxLength = attributes[i].getMaxLength();
                if (attributeMaxLength <= 0) {
                    attributeMaxLength = 255;
                }
                attributeSqlType = attributeSqlType + "(" + attributeMaxLength + ')';
            } else if (this.isNumericDataType(attributeSqlType)) {
                int scale = attributes[i].getScale();
                int precision = attributes[i].getPrecision();
                attributeSqlType = attributeSqlType + "(" + precision + "," + scale + ')';
            }
            this.generateNullStatement(writer, attributes, attributeSqlType, i);
        }
    }

    protected boolean isNumericDataType(String attributeSqlType) {
        return attributeSqlType.equalsIgnoreCase("numeric") || attributeSqlType.equalsIgnoreCase("number") || attributeSqlType.equalsIgnoreCase("decimal");
    }

    protected void generateNullStatement(PrintWriter writer, Attribute[] attributes, String attributeSqlType, int i) {
        writer.println("    " + attributes[i].getColumnNameWithEscapedQuote() + " " + attributeSqlType + (attributes[i].isNullable() ? "" : " not null") + (i < attributes.length - 1 ? "," : ""));
    }

    protected void printFkFile(MithraObjectTypeWrapper wrapper, File outDir, AbstractGeneratorDatabaseType generatorDatabaseType) throws IOException {
        RelationshipAttribute[] relationshipAttributes = wrapper.getRelationshipAttributes();
        if (wrapper.isPure()) {
            return;
        }
        for (int i = 0; i < relationshipAttributes.length; ++i) {
            int j;
            Attribute[] attributesReference;
            Attribute[] attributesFk;
            HashSet<ForeignKey> relationships;
            boolean doAppend;
            File outFk;
            Cardinality cardinality;
            RelationshipConversionVisitor visitor;
            boolean isFkInFrom = true;
            MithraObjectTypeWrapper relatedObject = relationshipAttributes[i].getRelatedObject();
            if (relatedObject.isPure() || !(visitor = relationshipAttributes[i].getMapperVisitor()).isNextObjectInJoinRelatedObject() || relationshipAttributes[i].hasParameters() || relationshipAttributes[i].hasFilters() || (!(cardinality = relationshipAttributes[i].getCardinality()).isFromMany() || cardinality.isToMany()) && (cardinality.isFromMany() || !cardinality.isToMany()) || relatedObject.hasAsOfAttributes()) continue;
            if (cardinality.isToMany()) {
                isFkInFrom = false;
                outFk = new File(outDir, relatedObject.getDefaultTable() + ".fk");
                doAppend = !relatedObject.isFirstFkFileWrite();
                relatedObject.setNotFirstFkFileWrite();
                relationships = this.foreignKeysByTable.get(relatedObject.getDefaultTable());
                if (relationships == null) {
                    relationships = new HashSet();
                    this.foreignKeysByTable.put(relatedObject.getDefaultTable(), relationships);
                }
            } else {
                outFk = new File(outDir, wrapper.getDefaultTable() + ".fk");
                doAppend = !wrapper.isFirstFkFileWrite();
                wrapper.setNotFirstFkFileWrite();
                relationships = this.foreignKeysByTable.get(wrapper.getDefaultTable());
                if (relationships == null) {
                    relationships = new HashSet<ForeignKey>();
                    this.foreignKeysByTable.put(wrapper.getDefaultTable(), relationships);
                }
            }
            Join join = visitor.getJoinedToThis();
            if (isFkInFrom) {
                attributesFk = join.getLeftRelationshipAttributesAsArray();
                attributesReference = join.getRightRelationshipAttributesAsArray();
            } else {
                attributesFk = join.getRightRelationshipAttributesAsArray();
                attributesReference = join.getLeftRelationshipAttributesAsArray();
            }
            if (attributesFk.length <= 0) continue;
            boolean illegalFk = false;
            for (int j2 = 0; j2 < attributesReference.length; ++j2) {
                if (attributesReference[j2].isAsOfAttribute()) {
                    illegalFk = true;
                    break;
                }
                if (attributesFk[j2].isAsOfAttribute()) {
                    illegalFk = true;
                    break;
                }
                if (attributesReference[j2].isSourceAttribute() && !attributesFk[j2].isSourceAttribute()) {
                    illegalFk = true;
                    break;
                }
                if (attributesReference[j2].isSourceAttribute() || !attributesFk[j2].isSourceAttribute()) continue;
                illegalFk = true;
                break;
            }
            if (illegalFk) continue;
            ForeignKey fk = null;
            fk = isFkInFrom ? new ForeignKey(relatedObject, wrapper) : new ForeignKey(wrapper, relatedObject);
            for (j = 0; j < attributesFk.length; ++j) {
                if (attributesFk[j].isSourceAttribute()) continue;
                fk.addFromColumn(attributesFk[j].getPlainColumnName());
            }
            for (j = 0; j < attributesReference.length; ++j) {
                if (attributesReference[j].isSourceAttribute()) continue;
                fk.addToColumn(attributesReference[j].getPlainColumnName());
            }
            if (relationships.contains(fk)) continue;
            relationships.add(fk);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outFk, doAppend)));
            fk.printAlterTable(writer, generatorDatabaseType);
            writer.println(" foreign key (");
            fk.printFromColumns(writer);
            writer.println("\n)");
            fk.printReferences(writer);
            fk.printToColumns(writer);
            writer.print("\n)");
            writer.println(generatorDatabaseType.getStatementTerminator());
            writer.println();
            writer.close();
        }
    }

    protected StringBuilder fixStringLength(String name, int targetLength) {
        char c;
        StringBuilder builder = new StringBuilder(name);
        int i = 0;
        while (i < builder.length() && builder.length() > targetLength) {
            c = builder.charAt(i);
            if (this.isVowel(c) && i != 0) {
                builder.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < builder.length() && builder.length() > targetLength) {
            c = builder.charAt(i);
            if (c == '_') {
                builder.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        if (builder.length() > targetLength && targetLength > 8) {
            String soFar = builder.toString();
            builder.setLength(0);
            int stair = soFar.length() / (targetLength -= 8);
            if (soFar.length() % targetLength > 0) {
                ++stair;
            }
            for (int i2 = 0; i2 < soFar.length(); ++i2) {
                if (builder.length() * stair > i2) continue;
                builder.append(soFar.charAt(i2));
            }
            if (builder.length() < targetLength) {
                builder.append(soFar.charAt(soFar.length() - 1));
            }
            builder.append(Integer.toHexString(name.hashCode()).toUpperCase());
        }
        return builder;
    }

    private boolean isVowel(char c) {
        return (c = Character.toUpperCase(c)) == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U';
    }

    private String fixConstraint(String name, int extrasNeeded) {
        int target = this.getMaxConstraintLength() - extrasNeeded;
        if (name.length() < target) {
            return name;
        }
        return this.fixStringLength(name, target).toString();
    }

    protected abstract int getMaxConstraintLength();

    private static class ForeignKey {
        private MithraObjectTypeWrapper fromObject;
        private MithraObjectTypeWrapper toObject;
        private LinkedHashSet fromColumns;
        private LinkedHashSet toColumns;

        private ForeignKey(MithraObjectTypeWrapper fromObject, MithraObjectTypeWrapper toObject) {
            this.fromObject = fromObject;
            this.toObject = toObject;
            this.fromColumns = new LinkedHashSet();
            this.toColumns = new LinkedHashSet();
        }

        public void addFromColumn(String col) {
            this.fromColumns.add(col);
        }

        public void addToColumn(String col) {
            this.toColumns.add(col);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForeignKey that = (ForeignKey)o;
            if (!this.toObject.getDefaultTable().equals(that.toObject.getDefaultTable())) {
                return false;
            }
            if (!this.fromColumns.equals(that.fromColumns)) {
                return false;
            }
            return this.toColumns.equals(that.toColumns);
        }

        public int hashCode() {
            int result = this.toObject.getDefaultTable().hashCode();
            result = 31 * result + this.fromColumns.hashCode();
            result = 31 * result + this.toColumns.hashCode();
            return result;
        }

        public void printAlterTable(PrintWriter writer, AbstractGeneratorDatabaseType generatorDatabaseType) {
            writer.print("alter table " + this.toObject.getDefaultTable());
            String fk = "_fk_" + this.toObject.getFkCounterAndIncrement();
            writer.print(" add constraint " + generatorDatabaseType.fixConstraint(this.toObject.getDefaultTable(), fk.length()) + fk);
        }

        public void printColumns(PrintWriter writer, LinkedHashSet columns) {
            writer.print("    ");
            boolean wrote = false;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                if (wrote) {
                    writer.print(",");
                }
                writer.print(it.next());
                wrote = true;
            }
        }

        public void printToColumns(PrintWriter writer) {
            this.printColumns(writer, this.toColumns);
        }

        public void printFromColumns(PrintWriter writer) {
            this.printColumns(writer, this.fromColumns);
        }

        public void printReferences(PrintWriter writer) {
            writer.println("references " + this.fromObject.getDefaultTable() + '(');
        }
    }
}

