/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.dbgenerator;

import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.databasetype.SybaseDatabaseType;
import com.gs.fw.common.mithra.databasetype.Udb82DatabaseType;
import com.gs.fw.common.mithra.generator.BaseMithraGenerator;
import com.gs.fw.common.mithra.generator.Logger;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.StdOutLogger;
import com.gs.fw.common.mithra.generator.dbgenerator.AbstractGeneratorDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.MariaGeneratorDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.OracleGeneratorDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.PostgresGeneratorDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.SybaseGeneratorDatabaseType;
import com.gs.fw.common.mithra.generator.dbgenerator.Udb82GeneratorDatabaseType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CoreMithraDbDefinitionGenerator
extends BaseMithraGenerator {
    private String databaseType;
    private boolean executed = false;
    private boolean generateConcreteClasses = true;
    private String buildList;
    private ArrayList buildListArray = null;
    private AbstractGeneratorDatabaseType abstractGeneratorDatabaseType;
    private final String DB_NAME_SYBASE = "sybase";
    private final String DB_NAME_UDB82 = "udb82";
    private final String DB_NAME_MSSQL = "mssql";
    private final String DB_NAME_POSTGRES = "postgres";
    private final String DB_NAME_ORACLE = "oracle";
    private final String DB_NAME_MARIA = "maria";

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) throws MithraGeneratorException {
        this.databaseType = databaseType;
        if (databaseType == null) {
            this.logger.error("No database type specified.");
            throw new MithraGeneratorException((Throwable)new Exception("No database type specified."));
        }
        if (databaseType.equalsIgnoreCase("sybase") || databaseType.equalsIgnoreCase("mssql")) {
            this.abstractGeneratorDatabaseType = new SybaseGeneratorDatabaseType();
        } else if (databaseType.equalsIgnoreCase("udb82")) {
            this.abstractGeneratorDatabaseType = new Udb82GeneratorDatabaseType();
        } else if (databaseType.equalsIgnoreCase("postgres")) {
            this.abstractGeneratorDatabaseType = new PostgresGeneratorDatabaseType();
        } else if (databaseType.equalsIgnoreCase("oracle")) {
            this.abstractGeneratorDatabaseType = new OracleGeneratorDatabaseType();
        } else if (databaseType.equalsIgnoreCase("maria")) {
            this.abstractGeneratorDatabaseType = new MariaGeneratorDatabaseType();
        } else {
            this.logger.error("No database type specified.");
            throw new MithraGeneratorException((Throwable)new Exception("Invalid database type specified."));
        }
    }

    public void setBuildList(String buildList) {
        this.buildList = buildList;
        if (buildList != null) {
            String[] buildListString = buildList.split(",");
            this.buildListArray = new ArrayList();
            for (int i = 0; i < buildListString.length; ++i) {
                buildListString[i] = buildListString[i].trim();
                this.buildListArray.add(buildListString[i]);
            }
        } else {
            this.buildListArray = null;
        }
    }

    public String getBuildList() {
        return this.buildList;
    }

    public List getBuildListArray() {
        return this.buildListArray;
    }

    public DatabaseType getDatabaseTypeObject() {
        if (this.databaseType.equalsIgnoreCase("sybase")) {
            return SybaseDatabaseType.getInstance();
        }
        if (this.databaseType.equalsIgnoreCase("udb82")) {
            return Udb82DatabaseType.getInstance();
        }
        return null;
    }

    public boolean generateDbDefinition(MithraObjectTypeWrapper wrapper, boolean replaceIfExists) throws MithraGeneratorException {
        try {
            String targetDir = replaceIfExists ? this.getGeneratedDir() : this.getNonGeneratedDir();
            File outDir = new File(targetDir);
            boolean outFileExists = false;
            if (!replaceIfExists) {
                return false;
            }
            if (!replaceIfExists && !this.generateConcreteClasses) {
                this.logger.warn("does not exist and generateConcreteClasses flag is turned off. This might lead to compilation errors");
                return false;
            }
            if (outFileExists && this.getGenerationLogger().getNewGenerationLog().isSame(this.getGenerationLogger().getOldGenerationLog())) {
                this.logger.debug("skipping " + wrapper.getDefaultTable());
                return false;
            }
            outDir.mkdirs();
            this.abstractGeneratorDatabaseType.generateDdlFile(wrapper, outDir);
            this.abstractGeneratorDatabaseType.generateIdxFile(wrapper, outDir);
            this.abstractGeneratorDatabaseType.generateFkFile(wrapper, outDir);
            return true;
        }
        catch (IOException e) {
            throw new MithraGeneratorException((Throwable)e);
        }
    }

    public void execute() throws MithraGeneratorException {
        if (!this.executed) {
            try {
                this.parseAndValidate();
                for (MithraObjectTypeWrapper mithraObjectTypeWrapper : this.getSortedMithraObjects()) {
                    if (this.buildListArray != null && !this.buildListArray.contains(mithraObjectTypeWrapper.getClassName()) || mithraObjectTypeWrapper.getDefaultTable() == null) continue;
                    this.generateDbDefinition(mithraObjectTypeWrapper, true);
                }
                this.executed = true;
            }
            catch (Exception e) {
                throw new MithraGeneratorException("Exception in mithra code generation", (Throwable)e);
            }
        } else {
            this.logger.info("skipped");
        }
    }

    public static void main(String[] args) {
        CoreMithraDbDefinitionGenerator gen = new CoreMithraDbDefinitionGenerator();
        gen.setLogger((Logger)new StdOutLogger());
        long startTime = System.currentTimeMillis();
        gen.setGeneratedDir("C:/users/proj/PARA4.0/generatedsrc/db");
        gen.setXml("C:/users/proj/PARA4.0/xml/mithra/para_config/ParaConfigClassList.xml");
        gen.setNonGeneratedDir("C:/users/proj/PARA4.0/src");
        gen.setDatabaseType("sybase");
        gen.execute();
        System.out.println("time: " + (System.currentTimeMillis() - startTime));
    }
}

