/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class ColumnInfo {
    private TableInfo parentTable = null;
    private ColumnInfo relatedAsOfColumn = null;
    private ColumnInfo asOfColumnFrom = null;
    private ColumnInfo asOfColumnTo = null;
    private String columnName;
    private String attributeName;
    private String javaType;
    private int sqlType;
    private int columnSize = -1;
    private int precision = 0;
    private int decimal = 0;
    private boolean nullable = false;
    private boolean asOfAttribute = false;
    private boolean partOfPk = false;
    private boolean identity = false;
    private static Set<String> objectIdNameSet = new HashSet<String>();
    private static Set<String> javaKeywordSet;
    private String asOfAttributeName;
    private boolean asOfAttributeFrom;

    public ColumnInfo(TableInfo parentTable) {
        this.parentTable = parentTable;
    }

    public ColumnInfo(String columnName, TableInfo parentTable) {
        this.columnName = columnName;
        this.attributeName = this.getAttributeName(columnName);
        this.parentTable = parentTable;
    }

    public ColumnInfo(String columnName, TableInfo parentTable, boolean partOfPk) {
        this.columnName = columnName;
        this.attributeName = this.getAttributeName(columnName);
        this.partOfPk = partOfPk;
        this.parentTable = parentTable;
    }

    public String getAsOfAttributeName() {
        return this.asOfAttributeName;
    }

    public boolean isAsOfAttributeFrom() {
        return this.asOfAttributeFrom;
    }

    public void setAsOfAttributeFrom(boolean asOfAttributeFrom) {
        this.asOfAttributeFrom = asOfAttributeFrom;
        if (asOfAttributeFrom) {
            this.asOfColumnFrom = this;
            this.asOfColumnTo = this.relatedAsOfColumn;
        } else {
            this.asOfColumnTo = this;
            this.asOfColumnFrom = this.relatedAsOfColumn;
        }
    }

    public void setAsOfAttributeName(String asOfAttributeName) {
        this.asOfAttributeName = asOfAttributeName;
    }

    public ColumnInfo getAsOfColumnFrom() {
        return this.asOfColumnFrom;
    }

    public ColumnInfo getAsOfColumnTo() {
        return this.asOfColumnTo;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public ColumnInfo getRelatedAsOfColumn() {
        return this.relatedAsOfColumn;
    }

    public void setRelatedAsOfColumn(ColumnInfo relatedAsOfColumn) {
        this.relatedAsOfColumn = relatedAsOfColumn;
    }

    public boolean isPartOfPk() {
        return this.partOfPk;
    }

    public void setPartOfPk(boolean partOfPk) {
        this.partOfPk = partOfPk;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isAsOfAttribute() {
        return this.asOfAttribute;
    }

    public void setAsOfAttribute(boolean asOfAttribute) {
        this.asOfAttribute = asOfAttribute;
    }

    public void setResultSet(ResultSet rs) throws SQLException {
        this.javaType = rs.getString("TYPE_NAME");
        this.columnName = rs.getString("COLUMN_NAME");
        this.attributeName = this.getAttributeName(this.columnName);
        this.sqlType = rs.getInt("DATA_TYPE");
        this.nullable = rs.getInt("NULLABLE") == 1;
        this.columnSize = rs.getInt("COLUMN_SIZE");
        this.precision = rs.getInt("COLUMN_SIZE");
        this.decimal = rs.getInt("DECIMAL_DIGITS");
        if (this.javaType.equalsIgnoreCase("int identity")) {
            this.javaType = "integer";
        }
    }

    private String getAttributeName(String columnName) {
        String tableName = this.parentTable == null ? null : this.parentTable.getTableName();
        return this.getAttributeName(columnName, tableName);
    }

    public String getAttributeName(String columnName, String tableName) {
        if (objectIdNameSet.contains(columnName) && tableName != null) {
            return StringUtility.toCamelCaseIgnoringLastChar((String)(tableName + "_Id"), (String)"_", (boolean)false);
        }
        String result = StringUtility.toCamelCaseIgnoringLastChar((String)columnName, (String)"_", (boolean)false);
        if (javaKeywordSet.contains(result)) {
            result = result + "_FIXME";
        }
        return result;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setParentTable(TableInfo tableInfo) {
        this.parentTable = tableInfo;
    }

    public boolean equals(Object o) {
        return this.columnName.equals(((ColumnInfo)o).getColumnName());
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    static {
        objectIdNameSet.add("OBJECTID");
        objectIdNameSet.add("OBJECT_ID");
        javaKeywordSet = new HashSet<String>();
        javaKeywordSet.add("abstract");
        javaKeywordSet.add("continue");
        javaKeywordSet.add("for");
        javaKeywordSet.add("new");
        javaKeywordSet.add("switch");
        javaKeywordSet.add("assert");
        javaKeywordSet.add("default");
        javaKeywordSet.add("goto");
        javaKeywordSet.add("package");
        javaKeywordSet.add("synchronized");
        javaKeywordSet.add("boolean");
        javaKeywordSet.add("do");
        javaKeywordSet.add("if");
        javaKeywordSet.add("private");
        javaKeywordSet.add("this");
        javaKeywordSet.add("break");
        javaKeywordSet.add("double");
        javaKeywordSet.add("implements");
        javaKeywordSet.add("protected");
        javaKeywordSet.add("throw");
        javaKeywordSet.add("byte");
        javaKeywordSet.add("else");
        javaKeywordSet.add("import");
        javaKeywordSet.add("public");
        javaKeywordSet.add("throws");
        javaKeywordSet.add("case");
        javaKeywordSet.add("enum");
        javaKeywordSet.add("instanceof");
        javaKeywordSet.add("return");
        javaKeywordSet.add("transient");
        javaKeywordSet.add("catch");
        javaKeywordSet.add("extends");
        javaKeywordSet.add("int");
        javaKeywordSet.add("short");
        javaKeywordSet.add("try");
        javaKeywordSet.add("char");
        javaKeywordSet.add("final");
        javaKeywordSet.add("interface");
        javaKeywordSet.add("static");
        javaKeywordSet.add("void");
        javaKeywordSet.add("class");
        javaKeywordSet.add("finally");
        javaKeywordSet.add("long");
        javaKeywordSet.add("strictfp");
        javaKeywordSet.add("volatile");
        javaKeywordSet.add("const");
        javaKeywordSet.add("float");
        javaKeywordSet.add("native");
        javaKeywordSet.add("super");
        javaKeywordSet.add("while");
    }
}

