/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator.objectxmlgenerator;

import com.gs.fw.common.mithra.MithraBusinessException;
import com.gs.fw.common.mithra.connectionmanager.LdapDataSourceProvider;
import com.gs.fw.common.mithra.databasetype.DatabaseType;
import com.gs.fw.common.mithra.databasetype.H2DatabaseType;
import com.gs.fw.common.mithra.databasetype.MariaDatabaseType;
import com.gs.fw.common.mithra.databasetype.MsSqlDatabaseType;
import com.gs.fw.common.mithra.databasetype.OracleDatabaseType;
import com.gs.fw.common.mithra.databasetype.PostgresDatabaseType;
import com.gs.fw.common.mithra.databasetype.SybaseDatabaseType;
import com.gs.fw.common.mithra.databasetype.SybaseIqDatabaseType;
import com.gs.fw.common.mithra.databasetype.Udb82DatabaseType;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ColumnInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.ForeignKey;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.IndexInfo;
import com.gs.fw.common.mithra.generator.objectxmlgenerator.TableInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MithraObjectXmlGenerator
extends Task {
    private static final String DB_NAME_POSTGRES = "postgres";
    private static final String DB_NAME_ORACLE = "oracle";
    private static final String DB_NAME_MARIA = "maria";
    private static final String DB_NAME_MSSQL = "mssql";
    private static final String DB_NAME_SYBASE = "sybase";
    private static final String DB_NAME_H2 = "h2";
    private static final String DB_NAME_UDB82 = "udb82";
    private static final String DB_NAME_SYBASEIQ = "sybaseiq";
    private static final Set<String> VALID_DBS = new HashSet<String>();
    private boolean executed = false;
    private boolean excludeAsOfAttributesFromDbIndex = true;
    private String userName;
    private String password;
    private String schemaName;
    private String schema;
    private String catalog = null;
    private String driver;
    private String url;
    private String outputDir;
    private String databaseType;
    private DatabaseType dbType;
    private String ldapName;
    private String ldapDataSourceProviderClassName = "com.gs.fw.common.mithra.connectionmanager.JndiJdbcLdapDataSourceProvider";
    private String generatedPackageName;
    private boolean toDateInclusive = true;
    private String infinityDateMethod = "com.gs.fw.common.mithra.util.DefaultInfinityTimestamp.getDefaultInfinity()";
    private String defaultIfNotSpecifiedMethod = "com.gs.fw.common.mithra.util.DefaultInfinityTimestamp.getDefaultInfinity()";
    private boolean generateTransactionalTables = true;
    private String processingDateTimezoneConversion = null;
    private String includeTables;
    private String includeTablesFromFile;
    private List<String> includeList = null;
    private Map<String, TableInfo> tables = new HashMap<String, TableInfo>();
    private Map<String, TableInfo> views = new HashMap<String, TableInfo>();

    public boolean isExcludeAsOfAttributesFromDbIndex() {
        return this.excludeAsOfAttributesFromDbIndex;
    }

    public void setExcludeAsOfAttributesFromDbIndex(boolean excludeAsOfAttributesFromDbIndex) {
        this.excludeAsOfAttributesFromDbIndex = excludeAsOfAttributesFromDbIndex;
    }

    public String getLdapDataSourceProviderClassName() {
        return this.ldapDataSourceProviderClassName;
    }

    public void setLdapDataSourceProviderClassName(String ldapDataSourceProviderClassName) {
        this.ldapDataSourceProviderClassName = ldapDataSourceProviderClassName;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType.toLowerCase();
    }

    public String getGeneratedPackageName() {
        return this.generatedPackageName;
    }

    public void setGeneratedPackageName(String generatedPackageName) {
        this.generatedPackageName = generatedPackageName;
    }

    public boolean isToDateInclusive() {
        return this.toDateInclusive;
    }

    public void setToDateInclusive(boolean toDateInclusive) {
        this.toDateInclusive = toDateInclusive;
    }

    public String getInfinityDateMethod() {
        return this.infinityDateMethod;
    }

    public void setInfinityDateMethod(String infinityDateMethod) {
        this.infinityDateMethod = infinityDateMethod;
    }

    public String getDefaultIfNotSpecifiedMethod() {
        return this.defaultIfNotSpecifiedMethod;
    }

    public void setDefaultIfNotSpecifiedMethod(String defaultIfNotSpecifiedMethod) {
        this.defaultIfNotSpecifiedMethod = defaultIfNotSpecifiedMethod;
    }

    public boolean isGenerateTransactionalTables() {
        return this.generateTransactionalTables;
    }

    public void setGenerateTransactionalTables(boolean generateTransactionalTables) {
        this.generateTransactionalTables = generateTransactionalTables;
    }

    public String getProcessingDateTimezoneConversion() {
        return this.processingDateTimezoneConversion;
    }

    public void setProcessingDateTimezoneConversion(String processingDateTimezoneConversion) {
        this.processingDateTimezoneConversion = processingDateTimezoneConversion;
    }

    public String getIncludeTablesFromFile() {
        return this.includeTablesFromFile;
    }

    public void setIncludeTablesFromFile(String includeTablesFromFile) {
        this.includeTablesFromFile = includeTablesFromFile;
        if (this.includeList != null) {
            return;
        }
        this.includeList = new ArrayList<String>();
        if (includeTablesFromFile != null) {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(new File(includeTablesFromFile)));
            }
            catch (FileNotFoundException e) {
                this.log("could not open file " + includeTablesFromFile, 0);
                this.includeTables = null;
                return;
            }
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.includeList.add(line);
                }
            }
            catch (IOException e) {
                this.log("could not read file", 0);
                this.includeTables = null;
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                this.log("could not close reader", 0);
            }
        }
    }

    public String getIncludeTables() {
        return this.includeTables;
    }

    public void setIncludeList(List<String> includeList) {
        this.includeList = includeList;
    }

    public void setIncludeTables(String includeTables) {
        if (this.includeList != null) {
            return;
        }
        this.includeList = new ArrayList<String>();
        this.includeTables = includeTables;
        String[] split = includeTables.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
            this.includeList.add(split[i]);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getLdapName() {
        return this.ldapName;
    }

    public void setLdapName(String ldapName) {
        this.ldapName = ldapName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void execute() throws BuildException {
        if (!this.executed) {
            this.processTableInfo();
            this.log("writing xml files.", 4);
            this.generateMithraObjectXml();
        }
    }

    private void checkOutputDirSpecified() {
        if (this.outputDir == null) {
            throw new MithraBusinessException("No outputDir specified. Please specify outputDir.");
        }
        if (!new File(this.outputDir).exists()) {
            throw new MithraBusinessException("Specified outputDir does not exist: " + this.outputDir);
        }
    }

    public Map<String, TableInfo> processTableInfo() {
        Connection connection = null;
        try {
            this.initialize();
            connection = this.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            this.log("getting table information.", 4);
            ArrayList<String> tableNameList = this.getTableNameListByTypes(metaData, this.includeList, new String[]{"TABLE"});
            this.populateTableInfoMap(metaData, tableNameList);
            Map<String, TableInfo> map = this.tables;
            return map;
        }
        catch (SQLException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException();
        }
        finally {
            this.closeConnection(connection);
        }
    }

    public Map<String, TableInfo> processViewInfo() {
        Connection connection = null;
        try {
            this.initialize();
            connection = this.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            this.log("getting view information.", 4);
            ArrayList<String> viewList = this.getTableNameListByTypes(metaData, this.includeList, new String[]{"VIEW"});
            this.populateViewInfoMap(metaData, viewList);
            Map<String, TableInfo> map = this.views;
            return map;
        }
        catch (SQLException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException();
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Connection getConnection() {
        this.log("establishing connection", 4);
        Connection connection = this.establishConnection(this.getDriver(), this.getUrl(), this.getUserName(), this.getPassword());
        if (connection == null) {
            throw new BuildException("Connection is null");
        }
        return connection;
    }

    private void initialize() {
        List<String> initializationErrors = this.checkForArguments();
        if (!initializationErrors.isEmpty()) {
            int size = initializationErrors.size();
            for (int i = 0; i < size; ++i) {
                this.log(initializationErrors.get(i), 0);
            }
            throw new MithraBusinessException("Could not initialize Mithra Object XML generator. See exceptions above.");
        }
        this.initializeObjectXmlGenerator();
    }

    private void initializeObjectXmlGenerator() {
        this.initializeDbType();
        this.initializeSchemaOrCatalog();
    }

    private void initializeSchemaOrCatalog() {
        if (this.databaseType.equalsIgnoreCase(DB_NAME_SYBASE) || this.databaseType.equalsIgnoreCase(DB_NAME_POSTGRES) || this.databaseType.equalsIgnoreCase(DB_NAME_MARIA) || this.databaseType.equalsIgnoreCase(DB_NAME_MSSQL)) {
            this.schemaName = null;
            this.catalog = this.schema;
        } else {
            this.schemaName = this.schema;
            this.catalog = null;
        }
    }

    private void initializeDbType() {
        if (!VALID_DBS.contains(this.databaseType)) {
            this.log("Invalid database type specified. The valid values for this attribute are: " + VALID_DBS.toString(), 0);
            throw new BuildException("Invalid database type specified.");
        }
        if (this.databaseType.equalsIgnoreCase(DB_NAME_SYBASE)) {
            this.dbType = SybaseDatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_UDB82)) {
            this.dbType = Udb82DatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_SYBASEIQ)) {
            this.dbType = SybaseIqDatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_H2)) {
            this.dbType = H2DatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_POSTGRES)) {
            this.dbType = PostgresDatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_MARIA)) {
            this.dbType = MariaDatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_ORACLE)) {
            this.dbType = OracleDatabaseType.getInstance();
        } else if (this.databaseType.equalsIgnoreCase(DB_NAME_MSSQL)) {
            this.dbType = MsSqlDatabaseType.getInstance();
        }
    }

    private List<String> checkForArguments() {
        ArrayList<String> initializationErrors = new ArrayList<String>(5);
        if (this.userName == null) {
            initializationErrors.add("No userName specified. Please specify database userName.");
        }
        if (this.password == null) {
            initializationErrors.add("No password specified. Please specify password.");
        }
        if ((this.driver == null || this.url == null) && this.ldapName == null) {
            initializationErrors.add("Either driver and url or ldapName must be specified.");
        }
        if (this.url != null && this.ldapName != null) {
            initializationErrors.add("Both url and ldapName are specified. Only one of two can be specified");
        }
        if (this.databaseType == null) {
            initializationErrors.add("No databaseType specified. Please specify databaseType. The valid values for this attribute are: " + VALID_DBS.toString());
        }
        return initializationErrors;
    }

    private void populateViewInfoMap(DatabaseMetaData metaData, ArrayList<String> tableNames) {
        for (String tableName : tableNames) {
            TableInfo tableInfo = this.views.get(tableName);
            if (tableInfo == null) {
                tableInfo = new TableInfo();
                tableInfo.setTableName(tableName);
                this.views.put(tableName, tableInfo);
            }
            tableInfo.populateColumnList(metaData, this.catalog, this.schemaName, this.dbType);
        }
    }

    private void populateTableInfoMap(DatabaseMetaData metaData, ArrayList<String> tableNames) {
        for (String tableName : tableNames) {
            TableInfo tableInfo = this.tables.get(tableName);
            if (tableInfo == null) {
                tableInfo = new TableInfo();
                tableInfo.setTableName(tableName);
                this.tables.put(tableName, tableInfo);
            }
            tableInfo.populateTableInfoWithMetaData(metaData, this.catalog, this.schemaName, this.dbType, this.excludeAsOfAttributesFromDbIndex);
        }
        this.buildCrossLinkingReferences();
    }

    private void buildCrossLinkingReferences() {
        Set<String> tableNames = this.tables.keySet();
        for (TableInfo t : this.tables.values()) {
            t.removeForeignKeysForMissingTables(tableNames);
            for (ForeignKey fk : t.getForeignKeys().values()) {
                String refTable = fk.getRefTableName();
                TableInfo tableB = this.tables.get(refTable);
                fk.setTableB(tableB);
                fk.initMultipleRelationsBetweenTables();
            }
            if (!t.isManyToManyTable()) continue;
            this.log("Table " + t.getTableName() + ": is Many-to-Many.");
            ForeignKey[] fks = t.getForeignKeys().values().toArray(new ForeignKey[2]);
            TableInfo tableA = fks[0].getTableB();
            TableInfo tableB = fks[1].getTableB();
            ForeignKey aToB = new ForeignKey(tableA, tableA.getTableName() + "-" + tableB.getTableName(), tableB.getTableName());
            aToB.setTableB(tableB);
            aToB.setTableAB(t);
            tableA.getForeignKeys().put(aToB.getName(), aToB);
        }
    }

    private ArrayList<String> getTableNameListByTypes(DatabaseMetaData metaData, List includeList, String[] types) {
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = metaData.getTables(this.catalog, this.schemaName, "%", types);
            while (rs.next()) {
                String str = rs.getString("TABLE_NAME");
                if (includeList != null && !includeList.contains(str)) continue;
                tables.add(str);
            }
            this.closeResultSet(rs);
        }
        catch (SQLException e) {
            try {
                this.log(e.getMessage(), 0);
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        return tables;
    }

    private Connection establishConnection(String driver, String url, String userName, String password) {
        try {
            LdapDataSourceProvider ldapDataSourceProvider;
            if (this.ldapName == null) {
                Class.forName(driver).newInstance();
                return DriverManager.getConnection(url, userName, password);
            }
            Properties env = new Properties();
            env.put("com.gs.fw.aig.jdbc.useConnectionPool", "false");
            env.put("user", userName);
            env.put("password", password);
            if (this.getDatabaseType().contains(DB_NAME_SYBASE)) {
                env.put("com.gs.fw.aig.jdbc.global.DataSourceImpl", "com.sybase.jdbc4.jdbc.SybDataSource");
            }
            try {
                ldapDataSourceProvider = (LdapDataSourceProvider)Class.forName(this.ldapDataSourceProviderClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("could not create LDAP data source ", e);
            }
            DataSource ds = ldapDataSourceProvider.createLdapDataSource(env, this.ldapName);
            return ds.getConnection(userName, password);
        }
        catch (SQLException e) {
            this.log(e.getClass().getName() + ": " + e.getMessage(), e, 0);
            return null;
        }
        catch (Exception e) {
            this.log(e.getClass().getName() + ": " + e.getMessage(), e, 0);
            return null;
        }
    }

    private void generateMithraObjectXml() throws BuildException {
        this.checkOutputDirSpecified();
        for (TableInfo table : this.tables.values()) {
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputDir + "/" + table.getClassName() + ".xml"))));
                if (this.generateTransactionalTables) {
                    writer.println("<MithraObject objectType= \"transactional\">");
                } else {
                    writer.println("<MithraObject>");
                }
                writer.println();
                String packageName = this.getGeneratedPackageName() != null ? this.getGeneratedPackageName() : "INSERT PACKAGE HERE";
                writer.print("    <PackageName>" + packageName);
                writer.println("</PackageName>");
                writer.print("    <ClassName>");
                writer.print(table.getClassName());
                writer.println("</ClassName>");
                writer.print("    <DefaultTable>");
                writer.print(table.getTableName());
                writer.println("</DefaultTable>");
                writer.println();
                if (table.getPkList().size() == 0) {
                    writer.println();
                    writer.println("NO PRIMARY KEY FOR THIS TABLE. BE SURE TO FIX DATABASE AND THIS FILE!");
                    writer.println();
                }
                this.printAttributes(writer, table);
                writer.println();
                this.printRelationships(writer, table);
                writer.println();
                this.printIndices(writer, table);
                writer.println();
                writer.println("</MithraObject>");
                writer.close();
            }
            catch (IOException e) {
                this.log(e.getMessage(), 0);
                throw new BuildException();
            }
        }
    }

    private void printRelationships(PrintWriter writer, TableInfo tableInfo) {
        if (tableInfo.isManyToManyTable()) {
            return;
        }
        for (ForeignKey fk : tableInfo.getForeignKeys().values()) {
            String relationshipName = fk.getRelationshipName();
            String reverseRelationshipName = fk.getReverseRelationshipName();
            String cardinality = fk.getTableAMultiplicity() + "-to-" + fk.getTableBMultiplicity();
            String joinOperation = fk.getJoinOperation();
            writer.println("    <Relationship name=\"" + relationshipName + "\" relatedObject=\"" + fk.getTableB().getClassName() + "\" cardinality=\"" + cardinality + "\" reverseRelationshipName=\"" + reverseRelationshipName + "\">");
            writer.println("        " + joinOperation);
            writer.println("    </Relationship>");
        }
    }

    public void printAttributes(PrintWriter writer, TableInfo tableInfo) {
        Map<String, ColumnInfo> columnList = tableInfo.getColumnMap();
        List<ColumnInfo> asOfList = tableInfo.getAsOfList();
        for (ColumnInfo anAsOfList : asOfList) {
            this.printAsOfAttribute(anAsOfList, writer);
        }
        for (ColumnInfo column : columnList.values()) {
            if (column.isAsOfAttribute()) continue;
            this.printAttribute(column, writer);
        }
    }

    private void printAttribute(ColumnInfo column, PrintWriter writer) {
        writer.print("    <Attribute name=\"" + column.getAttributeName() + "\" ");
        String javaType = this.dbType.getJavaTypeFromSql(column.getJavaType().trim().toLowerCase(), Integer.valueOf(column.getPrecision()), Integer.valueOf(column.getDecimal()));
        if (javaType == null) {
            writer.print("javaType=\"" + column.getJavaType() + "\" ");
        } else {
            writer.print("javaType=\"" + javaType + "\" ");
        }
        if ("String".equals(javaType) && column.getColumnSize() != -1) {
            writer.print("maxLength=\"" + column.getColumnSize() + "\" ");
        }
        if (column.isPartOfPk()) {
            writer.print("primaryKey=\"true\" ");
        }
        if (column.isIdentity()) {
            writer.print("identity=\"true\" ");
        }
        writer.print("columnName=\"" + column.getColumnName() + "\" ");
        if (!column.isNullable() && !column.isPartOfPk()) {
            writer.print("nullable=\"" + column.isNullable() + "\" ");
        }
        if ("BigDecimal".equals(javaType)) {
            writer.print("precision=\"" + column.getPrecision() + "\" ");
            writer.print("scale=\"" + column.getDecimal() + "\" ");
        }
        writer.println("/>");
    }

    private void printAsOfAttribute(ColumnInfo column, PrintWriter writer) {
        writer.print("    <AsOfAttribute name=\"" + column.getAsOfAttributeName() + "\" ");
        writer.print("fromColumnName=\"" + column.getAsOfColumnFrom().getColumnName() + "\" ");
        writer.print("toColumnName=\"" + column.getAsOfColumnTo().getColumnName() + "\" ");
        if (column.isPartOfPk()) {
            writer.print("primaryKey=\"true\" ");
        }
        if ("businessDate".equals(column.getAsOfAttributeName())) {
            writer.print("toIsInclusive=\"" + this.toDateInclusive + "\" ");
            writer.print("infinityDate=\"[" + this.infinityDateMethod + "]\" ");
        } else {
            writer.print("toIsInclusive=\"" + this.toDateInclusive + "\" ");
            writer.print("infinityDate=\"[" + this.infinityDateMethod + "]\" ");
            writer.print("defaultIfNotSpecified=\"[" + this.defaultIfNotSpecifiedMethod + "]\" ");
            writer.print("isProcessingDate=\"true\" ");
            if (this.processingDateTimezoneConversion != null) {
                writer.print("timezoneConversion=\"" + this.processingDateTimezoneConversion + "\" ");
            }
        }
        writer.println("/>");
    }

    public void printIndices(PrintWriter writer, TableInfo tableInfo) {
        for (IndexInfo indexInfo : tableInfo.getIndexMap().values()) {
            if (!indexInfo.isUnique()) continue;
            writer.print("<Index name=\"" + indexInfo.getName() + "\" unique=\"true\">");
            for (int i = 0; i < indexInfo.getColumnInfoList().size(); ++i) {
                writer.print(indexInfo.getColumnInfoList().get(i).getAttributeName());
                if (i >= indexInfo.getColumnInfoList().size() - 1) continue;
                writer.print(", ");
            }
            writer.println("</Index>");
        }
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.log(e.getMessage(), 0);
                throw new BuildException();
            }
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log(e.getMessage(), 0);
                throw new BuildException();
            }
        }
    }

    protected static String getCredential(String key, Properties credentials) {
        String property = credentials.getProperty(key);
        if (property == null) {
            throw new RuntimeException("Missing property: " + key);
        }
        return property;
    }

    public static void main(String[] args) {
        System.out.println("Not a real main method. For testing only");
        Properties credentials = new Properties();
        try {
            credentials.load(MithraObjectXmlGenerator.class.getClassLoader().getResourceAsStream("credentials.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("No credentials found");
        }
        MithraObjectXmlGenerator generator = new MithraObjectXmlGenerator();
        generator.setUserName(MithraObjectXmlGenerator.getCredential("postgres_user", credentials));
        generator.setPassword(MithraObjectXmlGenerator.getCredential("postgres_password", credentials));
        generator.setUrl("jdbc:postgresql://" + MithraObjectXmlGenerator.getCredential("postgres_hostName", credentials) + ":" + MithraObjectXmlGenerator.getCredential("postgres_port", credentials) + "/" + MithraObjectXmlGenerator.getCredential("postgres_databaseName", credentials));
        generator.setDatabaseType(DB_NAME_POSTGRES);
        generator.setDriver("org.postgresql.Driver");
        generator.setOutputDir("./reladomogenutil/target/reverse/postgres");
        generator.setSchema(MithraObjectXmlGenerator.getCredential("postgres_schemaName", credentials));
        generator.setIncludeTables("ALL_TYPES, IDENTITY_TABLE, PRODUCT, TEST_BALANCE_NO_ACMAP, ORDERS, ORDER_ITEM");
        generator.execute();
    }

    static {
        VALID_DBS.add(DB_NAME_MSSQL);
        VALID_DBS.add(DB_NAME_H2);
        VALID_DBS.add(DB_NAME_POSTGRES);
        VALID_DBS.add(DB_NAME_SYBASE);
        VALID_DBS.add(DB_NAME_SYBASEIQ);
        VALID_DBS.add(DB_NAME_UDB82);
        VALID_DBS.add(DB_NAME_MARIA);
        VALID_DBS.add(DB_NAME_ORACLE);
    }
}

