/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.fw.common.mithra.MithraDatabaseObject;
import com.gs.fw.common.mithra.connectionmanager.XAConnectionManager;
import com.gs.fw.common.mithra.test.MithraTestConnectionManager;
import com.gs.fw.common.mithra.test.MithraTestResource;
import com.gs.fw.common.mithra.test.TestDatabaseConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMithraTestConnectionManager
implements MithraTestConnectionManager {
    private String defaultSource;
    private Set<TestDatabaseConfiguration> testDbConfigurations = new UnifiedSet(3);
    private String connectionManagerIdentifier;
    private boolean shutdown = false;
    private Properties credentials = new Properties();

    protected void readCredentials() {
        try {
            this.credentials.load(this.getClass().getClassLoader().getResourceAsStream("credentials.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("No credentials found");
        }
    }

    protected String getCredential(String key) {
        String property = this.credentials.getProperty(key);
        if (property == null) {
            throw new RuntimeException("Missing property: " + key);
        }
        return property;
    }

    @Override
    public boolean addConnectionManagerForSource(String schemaName) {
        return false;
    }

    @Override
    public boolean addConnectionManagerForSource(Object sourceId, String schemaName) {
        return false;
    }

    public void setDefaultSource(String defaultSource) {
        if (this.connectionManagerIdentifier != null) {
            // empty if block
        }
        this.defaultSource = defaultSource;
    }

    @Override
    public String getDefaultSource() {
        return this.defaultSource;
    }

    @Override
    public String getConnectionManagerIdentifier() {
        return this.connectionManagerIdentifier;
    }

    public void setConnectionManagerIdentifier(String connectionManagerIdentifier) {
        this.connectionManagerIdentifier = connectionManagerIdentifier;
    }

    @Override
    public void createSchema(String databaseName, String schemaName, Class sourceAttributeType) {
    }

    @Override
    public void addTestDbConfiguration(TestDatabaseConfiguration testDbConfiguration) {
        this.testDbConfigurations.add(testDbConfiguration);
    }

    @Override
    public void setUpDatabases(MithraTestResource mtr, boolean createTables) {
        this.ensureAllDatabasesRegisteredAndTablesExist(mtr, this.testDbConfigurations);
        if (createTables) {
            Iterator<TestDatabaseConfiguration> it = this.testDbConfigurations.iterator();
            for (int i = 0; i < this.testDbConfigurations.size(); ++i) {
                TestDatabaseConfiguration testDbConfiguration = it.next();
                testDbConfiguration.createTables(this, mtr);
            }
        }
        this.cleanUpAllData(mtr);
        this.ensureAllDatabasesRegisteredAndTablesExist(mtr, this.testDbConfigurations);
        this.insertAllData(mtr);
    }

    protected void ensureAllDatabasesRegisteredAndTablesExist(MithraTestResource mtr, Set<TestDatabaseConfiguration> testDbConfigs) {
    }

    public Set<String> getCreatedTables() {
        UnifiedSet tables = UnifiedSet.newSet();
        for (TestDatabaseConfiguration configuration : this.testDbConfigurations) {
            tables.addAll(configuration.getCreatedTableNames());
        }
        return tables;
    }

    @Override
    public void tearDownDatabases(MithraTestResource mtr) {
        TestDatabaseConfiguration testDbConfiguration;
        int i;
        Iterator<TestDatabaseConfiguration> it = this.testDbConfigurations.iterator();
        for (i = 0; i < this.testDbConfigurations.size() && !this.shutdown; ++i) {
            testDbConfiguration = it.next();
            testDbConfiguration.tearDownDatabase(this, mtr);
        }
        if (this.shutdown) {
            it = this.testDbConfigurations.iterator();
            for (i = 0; i < this.testDbConfigurations.size(); ++i) {
                testDbConfiguration = it.next();
                testDbConfiguration.setShutdown();
            }
        }
        this.testDbConfigurations.clear();
        this.shutdown = false;
    }

    @Override
    public void addDatabaseObjectsToTestDatabases(List<MithraDatabaseObject> databaseObjects, MithraTestResource mtr) {
        int size = this.testDbConfigurations.size();
        Iterator<TestDatabaseConfiguration> it = this.testDbConfigurations.iterator();
        for (int i = 0; i < size; ++i) {
            TestDatabaseConfiguration testDbConfig = it.next();
            testDbConfig.addMoreDatabaseObjects(mtr, databaseObjects);
        }
    }

    @Override
    public boolean hasConnectionManagerForSource(String source) {
        return false;
    }

    private void cleanUpAllData(MithraTestResource mtr) {
        Iterator<TestDatabaseConfiguration> it = this.testDbConfigurations.iterator();
        for (int i = 0; i < this.testDbConfigurations.size(); ++i) {
            TestDatabaseConfiguration testDbConfiguration = it.next();
            if (mtr.getAdditionalConnectionManagersInUse().contains(this) || !mtr.isDeleteOnCreate()) continue;
            testDbConfiguration.tearDownDatabase(this, mtr);
        }
    }

    private void insertAllData(MithraTestResource mtr) {
        Iterator<TestDatabaseConfiguration> it = this.testDbConfigurations.iterator();
        for (int i = 0; i < this.testDbConfigurations.size(); ++i) {
            TestDatabaseConfiguration testDbConfiguration = it.next();
            testDbConfiguration.insertData(this, mtr);
            testDbConfiguration.setConfigured(true);
        }
    }

    @Override
    public void fullyShutdown() {
        this.shutdown = true;
    }

    public boolean ensureAllConnectionsReturnedToPool() {
        for (XAConnectionManager connectionManager : this.getAllConnectionManagers()) {
            if (connectionManager.getNumberOfActiveConnections() == 0) continue;
            return false;
        }
        return true;
    }

    protected abstract Collection<XAConnectionManager> getAllConnectionManagers();
}

