/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import com.gs.fw.common.mithra.extractor.AbstractStringExtractor;
import com.gs.fw.common.mithra.extractor.NonPrimitiveExtractor;
import com.gs.fw.common.mithra.util.fileparser.MithraParsedData;
import java.net.URL;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataFile {
    private String filename;
    private Object sourceId;
    private List<MithraParsedData> parsedData;
    private boolean inserted;

    public TestDataFile(String filename, List<MithraParsedData> parsedData) {
        this.filename = filename;
        this.parsedData = parsedData;
    }

    public TestDataFile(URL fileLocation, List<MithraParsedData> parsedData) {
        if (fileLocation == null) {
            throw new IllegalArgumentException("file location must not be null");
        }
        this.filename = fileLocation.toString();
        this.parsedData = parsedData;
    }

    public TestDataFile(URL fileLocation, List<MithraParsedData> parsedData, Object sourceId) {
        if (fileLocation == null) {
            throw new IllegalArgumentException("file location must not be null");
        }
        this.filename = fileLocation.toString();
        this.parsedData = parsedData;
        this.sourceId = sourceId;
    }

    public TestDataFile(String filename, List<MithraParsedData> parsedData, Object sourceId) {
        this.filename = filename;
        this.parsedData = parsedData;
        this.sourceId = sourceId;
    }

    public List<MithraParsedData> getParsedData() {
        return this.parsedData;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestDataFile that = (TestDataFile)o;
        return this.filename.equals(that.filename) && (this.sourceId == null || this.sourceId.equals(that.sourceId));
    }

    public int hashCode() {
        return this.filename.hashCode();
    }

    public static class SourceIdExtractor
    extends NonPrimitiveExtractor {
        public void setValue(Object o, Object newValue) {
        }

        public Object valueOf(Object object) {
            TestDataFile tdf = (TestDataFile)object;
            return tdf.sourceId;
        }
    }

    public static class FilenameExtractor
    extends AbstractStringExtractor {
        public void setStringValue(Object o, String newValue) {
            throw new RuntimeException("not implemented");
        }

        public String stringValueOf(Object o) {
            return ((TestDataFile)o).getFilename();
        }
    }
}

