/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.fw.common.mithra.MithraDatabaseObject;
import com.gs.fw.common.mithra.MithraException;
import com.gs.fw.common.mithra.MithraManagerProvider;
import com.gs.fw.common.mithra.MithraObjectPortal;
import com.gs.fw.common.mithra.attribute.Attribute;
import com.gs.fw.common.mithra.attribute.SourceAttributeType;
import com.gs.fw.common.mithra.test.ConnectionManagerForTests;
import com.gs.fw.common.mithra.test.MithraTestConnectionManager;
import com.gs.fw.common.mithra.test.MithraTestDataParser;
import com.gs.fw.common.mithra.test.MithraTestResource;
import com.gs.fw.common.mithra.test.TestDataFile;
import com.gs.fw.common.mithra.util.fileparser.BinaryCompressor;
import com.gs.fw.common.mithra.util.fileparser.MithraDelimitedDataParser;
import com.gs.fw.common.mithra.util.fileparser.MithraParsedData;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDatabaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger((String)TestDatabaseConfiguration.class.getName());
    private String databaseName;
    private Object sourceId;
    private Class sourceAttributeType;
    private List<TestDataFile> testDataFiles;
    private List<MithraDatabaseObject> databaseObjects;
    private Set<String> createdTableNames;
    private boolean configured;
    protected static final Class[] NO_PARAMS = new Class[0];
    protected static final Object[] NO_ARGS = new Object[0];
    private boolean shutdown;
    private boolean enableStrictParsing;

    public TestDatabaseConfiguration(String databaseName, Object sourceId, Class sourceAttributeType) {
        this(databaseName, sourceId, sourceAttributeType, false);
    }

    public TestDatabaseConfiguration(String databaseName, Object sourceId, Class sourceAttributeType, boolean enableStrictParsing) {
        this.databaseName = databaseName;
        this.sourceId = sourceId;
        this.sourceAttributeType = sourceAttributeType;
        this.testDataFiles = new ArrayList<TestDataFile>(3);
        this.enableStrictParsing = enableStrictParsing;
    }

    protected static Logger getLogger() {
        return logger;
    }

    private boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Set<String> getCreatedTableNames() {
        return this.createdTableNames;
    }

    public void setCreatedTableNames(Set<String> createdTableNames) {
        this.createdTableNames = createdTableNames;
    }

    public List<MithraDatabaseObject> getDatabaseObjects() {
        return this.databaseObjects;
    }

    public void setDatabaseObjects(List<MithraDatabaseObject> databaseObjects) {
        this.databaseObjects = databaseObjects;
    }

    public void addMoreDatabaseObjects(MithraTestResource mtr, List<MithraDatabaseObject> databaseObjects) {
        if (this.databaseObjects == null) {
            this.databaseObjects = new ArrayList<MithraDatabaseObject>();
        }
        this.databaseObjects.addAll(databaseObjects);
        this.createTables(mtr, databaseObjects);
    }

    public Class getSourceAttributeType() {
        return this.sourceAttributeType;
    }

    public void setSourceAttributeType(Class sourceAttributeType) {
        this.sourceAttributeType = sourceAttributeType;
    }

    public Object getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Object sourceId) {
        this.sourceId = sourceId;
    }

    protected boolean isUsed(MithraTestResource mtr, String classname) {
        return mtr.isUsed(classname);
    }

    public TestDataFile parseTestDataStream(URL streamLocation, InputStream is) {
        TestDataFile parsedData = MithraTestResource.findObjectInList(new TestDataFile(streamLocation, null), this.testDataFiles);
        if (parsedData == null) {
            Object results;
            TestDatabaseConfiguration.getLogger().debug("Parsing data from url: " + streamLocation.toString());
            if (streamLocation.toString().endsWith(".ccbf")) {
                BinaryCompressor compressor = new BinaryCompressor();
                results = compressor.decompress(streamLocation, is);
            } else {
                MithraTestDataParser parser = new MithraTestDataParser(streamLocation, is);
                results = parser.getResults();
            }
            TestDatabaseConfiguration.getLogger().debug("Finished parsing data from url: " + streamLocation.toString());
            parsedData = new TestDataFile(streamLocation, (List<MithraParsedData>)results);
            this.testDataFiles.add(parsedData);
        }
        return parsedData;
    }

    public TestDataFile parseTestDataFile(String testDataFilename) {
        TestDataFile parsedData = MithraTestResource.findObjectInList(new TestDataFile(testDataFilename, null), this.testDataFiles);
        if (parsedData == null) {
            List results;
            TestDatabaseConfiguration.getLogger().debug("Parsing data file: " + testDataFilename);
            if (testDataFilename.endsWith(".ccbf")) {
                BinaryCompressor binaryCompressor = new BinaryCompressor();
                results = binaryCompressor.decompress(testDataFilename);
            } else {
                MithraTestDataParser parser = new MithraTestDataParser(testDataFilename);
                results = parser.getResults();
            }
            TestDatabaseConfiguration.getLogger().debug("Finished parsing data file: " + testDataFilename);
            parsedData = new TestDataFile(testDataFilename, (List<MithraParsedData>)results);
            this.testDataFiles.add(parsedData);
        }
        return parsedData;
    }

    private TestDataFile parseBcpTestDataFile(String bcpFilename, String delimiter, List<Attribute> attributes, Format dateFormat) {
        TestDataFile parsedData = MithraTestResource.findObjectInList(new TestDataFile(bcpFilename, null), this.testDataFiles);
        if (parsedData == null) {
            TestDatabaseConfiguration.getLogger().debug("Parsing data file: " + bcpFilename);
            MithraDelimitedDataParser parser = new MithraDelimitedDataParser(bcpFilename, delimiter, attributes, dateFormat);
            List results = parser.getResults();
            TestDatabaseConfiguration.getLogger().debug("Finished parsing data file: " + bcpFilename);
            parsedData = new TestDataFile(bcpFilename, (List<MithraParsedData>)results);
            this.testDataFiles.add(parsedData);
        }
        return parsedData;
    }

    public void parseAndInsertTestData(MithraTestResource mtr, MithraTestConnectionManager testConnectionManager, URL streamLocation, InputStream is, boolean isSetupCompleted) {
        TestDataFile parsedData = this.parseTestDataStream(streamLocation, is);
        if (parsedData != null && !parsedData.isInserted() && this.isConfigured() && isSetupCompleted) {
            this.insertParsedData(parsedData, mtr);
        }
    }

    public void parseAndInsertTestData(MithraTestResource mtr, MithraTestConnectionManager testConnectionManager, String testDataFilename, boolean isSetupCompleted) {
        TestDataFile parsedData = this.parseTestDataFile(testDataFilename);
        if (parsedData != null && !parsedData.isInserted() && this.isConfigured() && isSetupCompleted) {
            this.insertParsedData(parsedData, mtr);
        }
    }

    public void parseAndInsertBcpTestData(MithraTestResource mtr, String bcpFilename, String delimiter, List<Attribute> attributes, Format dateFormat, boolean isSetupCompleted) {
        TestDataFile parsedData = this.parseBcpTestDataFile(bcpFilename, delimiter, attributes, dateFormat);
        if (parsedData != null && !parsedData.isInserted() && this.isConfigured() && isSetupCompleted) {
            this.insertParsedData(parsedData, mtr);
        }
    }

    public void insertData(MithraTestConnectionManager connectionManager, MithraTestResource mtr) {
        for (int i = 0; i < this.testDataFiles.size(); ++i) {
            TestDataFile testDataFile = this.testDataFiles.get(i);
            if (!mtr.getTestDataFilesInUse().contains(testDataFile.getFilename()) || testDataFile.isInserted()) continue;
            this.insertParsedData(testDataFile, mtr);
        }
    }

    private void insertParsedData(TestDataFile testDataFile, MithraTestResource mtr) {
        List<MithraParsedData> parsedDataList = testDataFile.getParsedData();
        for (int i = 0; i < parsedDataList.size(); ++i) {
            MithraParsedData mithraParsedData = parsedDataList.get(i);
            List attributes = mithraParsedData.getAttributes();
            List dataObjects = mithraParsedData.getDataObjects();
            String currentClassName = mithraParsedData.getParsedClassName();
            String finderClassname = currentClassName + "Finder";
            if (!mtr.isConfigured(currentClassName) && !MithraManagerProvider.getMithraManager().getConfigManager().isClassConfigured(currentClassName)) continue;
            Method method = TestDatabaseConfiguration.getMethod(finderClassname, "getMithraObjectPortal", NO_PARAMS);
            MithraObjectPortal mithraObjectPortal = (MithraObjectPortal)TestDatabaseConfiguration.invokeMethod(method, null, NO_ARGS);
            MithraDatabaseObject databaseObject = mithraObjectPortal.getDatabaseObject();
            if (!this.isCompatibleWithConnectionManager(mithraObjectPortal) || !this.isUsed(mtr, currentClassName) || databaseObject == null || dataObjects.size() <= 0) continue;
            Method insertDataMethod = TestDatabaseConfiguration.getMethod(databaseObject, "insertData", new Class[]{List.class, List.class, Object.class});
            TestDatabaseConfiguration.invokeMethod(insertDataMethod, databaseObject, new Object[]{attributes, dataObjects, this.sourceId});
        }
        testDataFile.setInserted(true);
    }

    private boolean isCompatibleWithConnectionManager(MithraObjectPortal mithraObjectPortal) {
        return !this.enableStrictParsing || this.sourceId == null ^ mithraObjectPortal.getFinder().getSourceAttribute() != null;
    }

    private Set<String> getSchemaNames(List<MithraDatabaseObject> databaseObjects) {
        UnifiedSet schemaNames = new UnifiedSet();
        if (databaseObjects == null) {
            return schemaNames;
        }
        for (int i = 0; i < databaseObjects.size(); ++i) {
            MithraDatabaseObject databaseObject = databaseObjects.get(i);
            String defaultSchema = databaseObject.getDefaultSchema();
            if (defaultSchema == null) continue;
            schemaNames.add(defaultSchema);
        }
        return schemaNames;
    }

    public void recreateTables(MithraTestConnectionManager connectionManager, MithraTestResource mtr) {
        if (this.createdTableNames != null) {
            this.createdTableNames.clear();
        }
        this.createTables(connectionManager, mtr);
    }

    public void createTables(MithraTestConnectionManager connectionManager, MithraTestResource mtr) {
        List<MithraDatabaseObject> loadedDatabaseObjects = mtr.getDatabaseObjectPerConnectionManager().get(connectionManager);
        if (this.createdTableNames == null) {
            this.createdTableNames = new UnifiedSet();
        }
        if (this.databaseObjects == null) {
            this.databaseObjects = new ArrayList<MithraDatabaseObject>();
        }
        Set<String> schemaNames = this.getSchemaNames(loadedDatabaseObjects);
        for (String schemaName : schemaNames) {
            if (this.sourceId == null) {
                connectionManager.createSchema(this.databaseName, schemaName, null);
                continue;
            }
            connectionManager.createSchema("" + this.sourceId, schemaName, this.sourceAttributeType);
        }
        this.createTables(mtr, loadedDatabaseObjects);
        this.setConfigured(true);
    }

    private void createTables(MithraTestResource mtr, List<MithraDatabaseObject> loadedDatabaseObjects) {
        if (loadedDatabaseObjects == null) {
            return;
        }
        for (int i = 0; i < loadedDatabaseObjects.size(); ++i) {
            String tableName;
            MithraDatabaseObject databaseObject = loadedDatabaseObjects.get(i);
            String classname = TestDatabaseConfiguration.getClassNameFromDatabaseObject(databaseObject);
            if (this.isInvalidSourceIdForDatabaseObject(classname) || this.createdTableNames.contains(tableName = databaseObject.getFullyQualifiedTableNameGenericSource(this.sourceId)) || !this.isUsed(mtr, classname)) continue;
            this.verifyAndCreateTestTable(mtr, databaseObject, classname);
        }
    }

    private boolean isInvalidSourceIdForDatabaseObject(String classname) {
        String finderClassname = classname + "Finder";
        Method sourceAttributeTypeMethod = TestDatabaseConfiguration.getMethod(finderClassname, "getSourceAttributeType", NO_PARAMS);
        SourceAttributeType sourceAttributeType = (SourceAttributeType)TestDatabaseConfiguration.invokeMethod(sourceAttributeTypeMethod, null, NO_ARGS);
        return this.sourceId != null && sourceAttributeType == null || sourceAttributeType != null && sourceAttributeType.getSourceAttributeUnderlyingClass() != this.sourceAttributeType;
    }

    private void verifyAndCreateTestTable(MithraTestResource mtr, MithraDatabaseObject databaseObject, String classname) {
        Method goodTableMethod = TestDatabaseConfiguration.getMethod(databaseObject, "verifyTable", new Class[]{Object.class});
        Boolean goodTable = (Boolean)TestDatabaseConfiguration.invokeMethod(goodTableMethod, databaseObject, new Object[]{this.sourceId});
        if (!goodTable.booleanValue()) {
            Method dropTestTableMethod = TestDatabaseConfiguration.getMethod(databaseObject, "dropTestTable", new Class[]{Object.class});
            Object mdbe = TestDatabaseConfiguration.invokeMethod(dropTestTableMethod, databaseObject, new Object[]{this.sourceId});
            Method createTestTableMethod = TestDatabaseConfiguration.getMethod(databaseObject, "createTestTable", new Class[]{Object.class});
            try {
                TestDatabaseConfiguration.invokeMethod(createTestTableMethod, databaseObject, new Object[]{this.sourceId});
            }
            catch (Exception e) {
                if (mdbe != null) {
                    TestDatabaseConfiguration.getLogger().error("drop table failed with exception", (Throwable)mdbe);
                }
                TestDatabaseConfiguration.getLogger().error("Failed to invoke createTestTable in " + databaseObject.getClass().getName(), (Throwable)e);
                throw new MithraException("Failed to invoke createTestTable in " + databaseObject.getClass().getName(), (Throwable)e);
            }
            TestDatabaseConfiguration.getLogger().debug("Creating a table with databaseObject: " + databaseObject.getClass().getName() + " in database " + this.databaseName + " with sourceAttribute " + this.sourceId);
            this.addToReplicatedObjects(mtr, databaseObject);
        }
        this.databaseObjects.add(databaseObject);
        String tableName = databaseObject.getFullyQualifiedTableNameGenericSource(this.sourceId);
        this.createdTableNames.add(tableName);
    }

    protected void addToReplicatedObjects(MithraTestResource mtr, MithraDatabaseObject databaseObject) {
        if (databaseObject.isReplicated()) {
            mtr.getReplicatedChildQueueTables().add(databaseObject);
        }
    }

    public void tearDownDatabase(MithraTestConnectionManager connectionManager, MithraTestResource mtr) {
        int i;
        MithraTestConnectionManager dead = null;
        for (i = 0; i < this.databaseObjects.size(); ++i) {
            MithraDatabaseObject databaseObject = this.databaseObjects.get(i);
            String classname = TestDatabaseConfiguration.getClassNameFromDatabaseObject(databaseObject);
            if (!this.isUsed(mtr, classname) || databaseObject.getConnectionManager() == dead) continue;
            Method deleteAllRowsMethod = TestDatabaseConfiguration.getMethod(databaseObject, "deleteAllRowsFromTestTable", new Class[]{Object.class});
            try {
                TestDatabaseConfiguration.invokeMethod(deleteAllRowsMethod, databaseObject, new Object[]{this.sourceId});
                continue;
            }
            catch (Throwable t) {
                this.shutdown = true;
                TestDatabaseConfiguration.getLogger().error("Could not tear down " + classname, t);
                dead = (MithraTestConnectionManager)databaseObject.getConnectionManager();
                dead.fullyShutdown();
                break;
            }
        }
        for (i = 0; i < this.testDataFiles.size(); ++i) {
            TestDataFile testDataFile = this.testDataFiles.get(i);
            testDataFile.setInserted(false);
        }
    }

    private static Method getMethod(Class underlyingObjectClass, String methodName, Class[] parameterTypes) {
        try {
            return underlyingObjectClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            TestDatabaseConfiguration.getLogger().error("Class " + underlyingObjectClass.getName() + " does not have method " + methodName);
            throw new MithraException("Class " + underlyingObjectClass.getName() + " does not have method " + methodName, (Throwable)e);
        }
    }

    protected static Method getMethod(Object underlyingObject, String methodName, Class[] parameterTypes) {
        return TestDatabaseConfiguration.getMethod(underlyingObject.getClass(), methodName, parameterTypes);
    }

    protected static Method getMethod(String classname, String methodName, Class[] parameterTypes) {
        try {
            return TestDatabaseConfiguration.getMethod(Class.forName(classname), methodName, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            TestDatabaseConfiguration.getLogger().error("Could not find class " + classname);
            throw new MithraException("Could not find class " + classname, (Throwable)e);
        }
    }

    protected static Object invokeMethod(Method method, Object underlyingObject, Object[] arguments) {
        try {
            return method.invoke(underlyingObject, arguments);
        }
        catch (IllegalAccessException e) {
            TestDatabaseConfiguration.getLogger().error("Could not access method " + method.getName() + " in class " + underlyingObject.getClass().getName());
            throw new MithraException("Could not access method " + method.getName() + " in class " + underlyingObject.getClass().getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            TestDatabaseConfiguration.getLogger().error("Exception during the invocation of " + method.getName() + " in class " + method.getDeclaringClass().getName(), e.getTargetException());
            throw new MithraException("Exception during the invocation of " + method.getName() + " in class " + method.getDeclaringClass().getName(), e.getTargetException());
        }
    }

    protected static String getClassNameFromDatabaseObject(MithraDatabaseObject databaseObject) {
        String classname = databaseObject.getClass().getName();
        int index = classname.lastIndexOf("DatabaseObject");
        classname = classname.substring(0, index);
        return classname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestDatabaseConfiguration that = (TestDatabaseConfiguration)o;
        if (!this.databaseName.equals(that.databaseName)) {
            return false;
        }
        if (this.sourceAttributeType != null ? !this.sourceAttributeType.equals(that.sourceAttributeType) : that.sourceAttributeType != null) {
            return false;
        }
        return !(this.sourceId == null ? that.sourceId != null : !this.sourceId.equals(that.sourceId));
    }

    public int hashCode() {
        int result = this.databaseName.hashCode();
        result = 29 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
        result = 29 * result + (this.sourceAttributeType != null ? this.sourceAttributeType.hashCode() : 0);
        return result;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown() {
        this.shutdown = true;
    }

    public boolean addToConnectionManager(MithraTestConnectionManager connectionManager) {
        return connectionManager.addConnectionManagerForSource(this.getSourceId(), this.getDatabaseName());
    }

    public Object getConnectionManagerSourceKey(ConnectionManagerForTests connectionManager) {
        return connectionManager.getConnectionManagerSourceKey(this.getSourceId(), this.getDatabaseName());
    }

    public String toString() {
        return "TestDatabaseConfiguration{databaseName='" + this.databaseName + '\'' + ", sourceId=" + this.sourceId + ", sourceAttributeType=" + this.sourceAttributeType + '}';
    }
}

