/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import org.apache.derby.drda.NetworkServerControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyServer {
    private static final Logger logger = LoggerFactory.getLogger((String)DerbyServer.class.getName());
    private static final DerbyServer instance = new DerbyServer();
    private static boolean derbyServerStarted = false;

    public static Logger getLogger() {
        return logger;
    }

    private DerbyServer() {
    }

    public void startDerbyServer() {
        if (!derbyServerStarted) {
            derbyServerStarted = true;
            try {
                DerbyServer.getLogger().info("Starting DerbyServer");
                this.startNetworkServer();
                DerbyServer.getLogger().info("DerbyServer Started");
            }
            catch (Exception e) {
                logger.error("During derby DB initialisation!", (Throwable)e);
            }
        }
    }

    private void startNetworkServer() throws Exception {
        DerbyServer.getLogger().info("Starting Network Server");
        System.setProperty("derby.drda.startNetworkServer", "true");
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        DerbyServer.getLogger().info("Network Server Started");
        new NetworkServerControl();
    }

    public static DerbyServer getInstance() {
        return instance;
    }
}

