/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DbServer {
    private static final H2DbServer instance = new H2DbServer();
    private static boolean h2dbServerStarted = false;
    private static final Logger logger = LoggerFactory.getLogger((String)H2DbServer.class.getName());

    public static Logger getLogger() {
        return logger;
    }

    private H2DbServer() {
    }

    public void startH2DbServer() {
        if (!h2dbServerStarted) {
            h2dbServerStarted = true;
            try {
                this.initializeH2();
            }
            catch (Exception e) {
                H2DbServer.getLogger().error("Unable to start H2 Database", (Throwable)e);
            }
        }
    }

    public void stopH2DbServer() {
        try {
            if (h2dbServerStarted) {
                H2DbServer.getLogger().info("Stopping H2 database Server");
                h2dbServerStarted = false;
                H2DbServer.getLogger().info("H2 database Server is down");
            }
        }
        catch (Exception e) {
            H2DbServer.getLogger().error("Unable to stop H2 Database", (Throwable)e);
        }
    }

    private void initializeH2() throws Exception {
        H2DbServer.getLogger().info("Starting H2 database Server");
        Class.forName("org.h2.Driver").newInstance();
        H2DbServer.getLogger().info("H2 database Server Started");
    }

    public static H2DbServer getInstance() {
        return instance;
    }
}

