/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.CommonAttribute;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.AsOfAttributePureType;
import com.gs.fw.common.mithra.generator.metamodel.PropertyType;
import com.gs.fw.common.mithra.generator.metamodel.TimePrecisionType;
import com.gs.fw.common.mithra.generator.metamodel.TimestampPrecisionType;
import com.gs.fw.common.mithra.generator.metamodel.TimezoneConversionType;
import com.gs.fw.common.mithra.generator.type.JavaType;
import com.gs.fw.common.mithra.generator.type.TimestampJavaType;
import com.gs.fw.common.mithra.generator.util.StringUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsOfAttribute
extends Attribute {
    private AsOfAttributePureType wrapped;
    private boolean isProcessingDate;
    private JavaType type = new TimestampJavaType();

    public AsOfAttribute(AsOfAttributePureType wrapped, MithraObjectTypeWrapper owner) {
        super(owner);
        this.wrapped = wrapped;
        this.isProcessingDate = this.wrapped.isIsProcessingDate();
    }

    @Override
    public TimestampPrecisionType getTimestampPrecision() {
        return this.wrapped.getTimestampPrecision();
    }

    @Override
    public boolean isFinalGetter() {
        return this.wrapped.isFinalGetterSet() ? this.wrapped.isFinalGetter() : this.getOwner().isDefaultFinalGetters();
    }

    public boolean isProcessingDateSet() {
        return this.wrapped.isIsProcessingDateSet();
    }

    public boolean isInfinityNull() {
        return this.wrapped.isInfinityIsNull();
    }

    @Override
    public boolean isSetAsString() {
        return this.wrapped.isSetAsString();
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public boolean isAsOfAttribute() {
        return true;
    }

    @Override
    public boolean isTimezoneConversionNeeded() {
        return !this.isTimezoneNone();
    }

    @Override
    public TimezoneConversionType getTimezoneConversion() {
        TimezoneConversionType conversionType = this.wrapped.getTimezoneConversion();
        if (conversionType == null) {
            conversionType = this.getDefaultTimezoneConversion();
        }
        return conversionType;
    }

    public boolean isProcessingDate() {
        return this.isProcessingDate;
    }

    public void setProcessingDate(boolean processingDate) {
        this.isProcessingDate = processingDate;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public String getQuotedColumnName() {
        throw new RuntimeException("not supported!");
    }

    @Override
    public JavaType getType() {
        return this.type;
    }

    public String getFromColumnName() {
        return this.wrapped.getFromColumnName();
    }

    public String getToColumnName() {
        return this.wrapped.getToColumnName();
    }

    public String getInfinityDate() {
        return this.wrapped.getInfinityDate();
    }

    public boolean isToIsInclusive() {
        return this.wrapped.isToIsInclusive();
    }

    public boolean futureExpiringRowsExist() {
        return this.wrapped.isFutureExpiringRowsExist();
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public String getFinderAttributeType() {
        return "AsOfAttribute";
    }

    @Override
    public List getProperty() {
        return this.wrapped.getProperties();
    }

    @Override
    public boolean hasProperties() {
        return this.wrapped.getProperties() != null && !this.wrapped.getProperties().isEmpty();
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.hasProperties()) {
            List<PropertyType> propertyTypes = this.wrapped.getProperties();
            for (PropertyType property : propertyTypes) {
                properties.put(property.getKey(), property.getValue() == null ? "Boolean.TRUE" : property.getValue());
            }
        }
        return properties;
    }

    public String getInfinityExpression() {
        if (this.isInfinityNull()) {
            return "com.gs.fw.common.mithra.util.NullDataTimestamp.getInstance()";
        }
        String original = this.wrapped.getInfinityDate();
        return this.createTimestampExpression(original);
    }

    private String createTimestampExpression(String original) {
        if (original == null) {
            return "null";
        }
        if ((original = original.trim()).startsWith("[") && original.endsWith("]")) {
            return original.substring(1, original.length() - 1);
        }
        throw new RuntimeException("timestamp parsing not yet implemented");
    }

    public String getDefaultDateExpression() {
        String original = this.wrapped.getDefaultIfNotSpecified();
        return this.createTimestampExpression(original);
    }

    @Override
    public boolean hasModifyTimePrecisionOnSet() {
        return false;
    }

    @Override
    public TimePrecisionType getModifyTimePrecisionOnSet() {
        return null;
    }

    @Override
    public boolean hasMaxLength() {
        return false;
    }

    @Override
    public int getMaxLength() {
        return 0;
    }

    @Override
    public boolean mustTrim() {
        return false;
    }

    public AsOfAttribute getCompatibleAsOfAttribute(MithraObjectTypeWrapper fromObject) {
        return fromObject.getCompatibleAsOfAttribute(this);
    }

    @Override
    public List<String> validateAndUseMissingValuesFromSuperClass(CommonAttribute superClassAttribute) {
        AsOfAttribute superClassAsOfAttribute = (AsOfAttribute)superClassAttribute;
        ArrayList<String> errors = new ArrayList<String>();
        if (!superClassAsOfAttribute.getType().equals(this.getType())) {
            errors.add("java type for attribute '" + this.getName() + "' does not match java type for same attribute in superclass '" + superClassAttribute.getName());
        }
        if (errors.size() == 0) {
            if (this.wrapped.getInfinityDate() == null) {
                this.wrapped.setInfinityDate(superClassAsOfAttribute.getInfinityDate());
            }
            if (this.wrapped.getFromColumnName() == null) {
                this.wrapped.setFromColumnName(superClassAsOfAttribute.getFromColumnName());
            }
            if (this.wrapped.getToColumnName() == null) {
                this.wrapped.setToColumnName(superClassAsOfAttribute.getToColumnName());
            }
            if (!this.wrapped.isToIsInclusiveSet()) {
                this.wrapped.setToIsInclusive(superClassAsOfAttribute.isToIsInclusive());
            }
            if (this.wrapped.getDefaultIfNotSpecified() == null) {
                this.wrapped.setDefaultIfNotSpecified(superClassAsOfAttribute.wrapped.getDefaultIfNotSpecified());
            }
            if (!this.wrapped.isPoolableSet() && superClassAsOfAttribute.wrapped.isPoolableSet()) {
                this.wrapped.setPoolable(superClassAsOfAttribute.isPoolable());
            }
        }
        return errors;
    }

    @Override
    public Attribute cloneForNewOwner(MithraObjectTypeWrapper newOwner) {
        return new AsOfAttribute(this.wrapped, newOwner);
    }

    public String getSerializationStatement(String variable) {
        if (this.isTimezoneConversionNeeded()) {
            return "MithraTimestamp.writeTimestampWithInfinity(out, " + variable + ", " + this.getInfinityExpression() + ")";
        }
        return "MithraTimestamp.writeTimezoneInsensitiveTimestampWithInfinity(out, " + variable + ", " + this.getInfinityExpression() + ")";
    }

    @Override
    public String getDeserializationStatement() {
        String result = this.isTimezoneConversionNeeded() ? "MithraTimestamp.readTimestampWithInfinity(in, " + this.getInfinityExpression() + ")" : "MithraTimestamp.readTimezoneInsensitiveTimestampWithInfinity(in, " + this.getInfinityExpression() + ")";
        if (this.isPoolable()) {
            result = "TimestampPool.getInstance().getOrAddToCache(" + result + ", " + this.getOwner().getFinderClassName() + ".isFullCache())";
        }
        return result;
    }

    @Override
    public boolean isPoolable() {
        return this.wrapped.isPoolable();
    }

    @Override
    public String getGeneratorParameters() {
        String result = this.getCommonConstructorParameters();
        result = result + ",";
        result = result + "this." + this.getName() + "From()";
        result = result + ",";
        result = result + "this." + this.getName() + "To()";
        result = result + ",";
        result = result + this.getOwner().getFinderClassName() + "." + this.getName() + "Infinity";
        result = result + ",";
        result = result + this.futureExpiringRowsExist();
        result = result + ",";
        result = result + this.isToIsInclusive();
        result = result + ",";
        result = result + this.getOwner().getFinderClassName() + "." + this.getName() + "Default";
        result = result + ",";
        result = result + this.isProcessingDate();
        result = result + ",";
        result = result + this.isInfinityNull();
        return result;
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    public String getTimestampLongFromGetter() {
        return "zGet" + StringUtility.firstLetterToUpper(this.getName()) + "FromAsLong()";
    }

    public String getTimestampLongToGetter() {
        return "zGet" + StringUtility.firstLetterToUpper(this.getName()) + "ToAsLong()";
    }

    public Attribute getAsOfAttributeTo() {
        return this.getOwner().getAttributeByName(this.getName() + "To");
    }
}

