/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.BaseMithraGenerator;
import com.gs.fw.common.mithra.generator.CommonWrapper;
import com.gs.fw.common.mithra.generator.GenerationLog;
import com.gs.fw.common.mithra.generator.GenerationLogger;
import com.gs.fw.common.mithra.generator.HttpServletRequest;
import com.gs.fw.common.mithra.generator.HttpServletResponse;
import com.gs.fw.common.mithra.generator.JspWriter;
import com.gs.fw.common.mithra.generator.MithraBaseObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraGeneratorException;
import com.gs.fw.common.mithra.generator.MithraSuperTypeWrapper;
import com.gs.fw.common.mithra.generator.MithraTemplate;
import com.gs.fw.common.mithra.generator.MithraXMLObjectTypeParser;
import com.gs.fw.common.mithra.generator.SourceFormatter;
import com.gs.fw.common.mithra.generator.StdOutLogger;
import com.gs.fw.common.mithra.generator.filesystem.GeneratedFileManager;
import com.gs.fw.common.mithra.generator.filesystem.StandardGeneratedFileManager;
import com.gs.fw.common.mithra.generator.metamodel.MithraInterfaceType;
import com.gs.fw.common.mithra.generator.util.AwaitingThreadExecutor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreMithraGenerator
extends BaseMithraGenerator {
    private static final String TEMPLATE_PACKAGE_PREFIX = "com.gs.fw.common.mithra.templates";
    private static final Map<String, String> TEMPLATE_PACKAGES = new HashMap<String, String>();
    private static final Map<String, List<String>> TEMPLATE_LISTS = new HashMap<String, List<String>>();
    private static final String GENERATED_COMMON_TEMPLATE = "CommonSuper";
    private static final List<String> READ_ONLY_TEMPLATES = Arrays.asList("Abstract_jsp", "Data_jsp", "ListAbstract_jsp", "Finder_jsp", "DatabaseObjectAbstract_jsp");
    private static final List<String> DATED_READ_ONLY_TEMPLATES = Arrays.asList("Abstract_jsp", "Data_jsp", "ListAbstract_jsp", "Finder_jsp", "DatabaseObjectAbstract_jsp");
    private static final List<String> TRANSACTIONAL_TEMPLATES = Arrays.asList("Abstract_jsp", "Data_jsp", "ListAbstract_jsp", "Finder_jsp", "DatabaseObjectAbstract_jsp");
    private static final List<String> DATED_TRANSACTIONAL_TEMPLATES = Arrays.asList("Abstract_jsp", "Data_jsp", "ListAbstract_jsp", "Finder_jsp", "DatabaseObjectAbstract_jsp");
    private static final List<String> EMBEDDED_VALUE_TEMPLATES = Arrays.asList("Abstract_jsp", "Data_jsp");
    private static final List<String> ENUMERATION_TEMPLATES = Arrays.asList("Enumeration_jsp");
    private static final List<String> SUPERCLASS_TEMPLATES = Arrays.asList("Abstract_jsp", "Finder_jsp");
    private static final List<String> MITHRA_INTERFACE_TEMPLATES = Arrays.asList("Abstract_jsp", "Finder_jsp");
    public static final String FORMAT_NONE = "none";
    public static final String FORMAT_FAST = "fast";
    public static final String FORMAT_PRETTY = "pretty";
    private boolean executed = false;
    private boolean generateConcreteClasses = true;
    private boolean warnAboutConcreteClasses = true;
    private boolean generateGscListMethod = false;
    private boolean generateLegacyCaramel = false;
    private String format = "fast";
    private boolean generateImported;
    private ThreadLocal<ByteArrayOutputStream> byteArrayOutputStreamThreadLocal = new ThreadLocal();
    private ThreadLocal<SourceFormatter> sourceFormatterThreadLocal = new ThreadLocal();

    public CoreMithraGenerator() {
        this.initGeneratedFileManager(new StandardGeneratedFileManager());
    }

    private ByteArrayOutputStream getByteArrayOutputStream() {
        ByteArrayOutputStream result = this.byteArrayOutputStreamThreadLocal.get();
        if (result == null) {
            result = new ByteArrayOutputStream(10000);
            this.byteArrayOutputStreamThreadLocal.set(result);
        }
        result.reset();
        return result;
    }

    private SourceFormatter getSourceFormatter() {
        SourceFormatter result = this.sourceFormatterThreadLocal.get();
        if (result == null) {
            result = new SourceFormatter();
            this.sourceFormatterThreadLocal.set(result);
        }
        return result;
    }

    public boolean isGenerateImported() {
        return this.generateImported;
    }

    public void setGenerateImported(boolean generateImported) {
        this.generateImported = generateImported;
    }

    public void setGenerateConcreteClasses(boolean generateConcreteClasses) {
        this.generateConcreteClasses = generateConcreteClasses;
    }

    public void setWarnAboutConcreteClasses(boolean warnAboutConreteClasses) {
        this.warnAboutConcreteClasses = warnAboutConreteClasses;
    }

    public void setGenerateGscListMethod(boolean generateGscListMethod) {
        this.generateGscListMethod = generateGscListMethod;
    }

    @Deprecated
    public void setGenerateLegacyCaramel(boolean generateLegacyCaramel) {
        this.generateLegacyCaramel = false;
    }

    public void setCodeFormat(String format) {
        if (format.equals(FORMAT_NONE) || format.equals(FORMAT_PRETTY) || format.equals(FORMAT_FAST)) {
            this.format = format;
        } else {
            System.out.println("Code format option '" + format + "' not recognized. Using '" + this.format + "' instead. Valid values are 'none', 'fast', and 'pretty");
        }
    }

    public void setGeneratedFileManager(GeneratedFileManager generatedFileManager) {
        this.initGeneratedFileManager(generatedFileManager);
    }

    private void initGeneratedFileManager(GeneratedFileManager generatedFileManager) {
        if (this.generatedFileManager != null) {
            throw new MithraGeneratorException("Attempt to reset file manager. An instance of " + generatedFileManager.getClass().getCanonicalName() + " has already been set");
        }
        this.generatedFileManager = generatedFileManager;
    }

    private void setFileGenerationOptions() {
        GeneratedFileManager.Options fileGenerationOptions = new GeneratedFileManager.Options(this.getGeneratedDir(), this.getNonGeneratedDir(), this.warnAboutConcreteClasses, this.generateConcreteClasses, this.getGenerationLogger(), this.logger, this.fauxFileSystem);
        this.generatedFileManager.setOptions(fileGenerationOptions);
    }

    private void applyMithraInterfaceTemplates(MithraInterfaceType mithraObject, AtomicInteger count) {
        List<String> templates = TEMPLATE_LISTS.get("mithra-interface");
        String templatePackage = TEMPLATE_PACKAGES.get("mithra-interface");
        for (String name : templates) {
            String templatePrefix = name.substring(name.lastIndexOf(46) + 1, name.lastIndexOf(95));
            String outputFileSuffix = "";
            if (templatePackage.endsWith("mithrainterface")) {
                outputFileSuffix = templatePrefix;
            }
            this.generateFile(mithraObject, count, templatePackage, templatePrefix, outputFileSuffix, true);
        }
        this.generateFile(mithraObject, count, templatePackage, "", "", false);
    }

    private void applyTemplates(MithraBaseObjectTypeWrapper mithraObject, AtomicInteger count) {
        List<String> templates = TEMPLATE_LISTS.get(mithraObject.getObjectType());
        String templatePackage = TEMPLATE_PACKAGES.get(mithraObject.getObjectType());
        if (mithraObject.isTablePerSubclassSuperClass()) {
            templates = SUPERCLASS_TEMPLATES;
            templatePackage = templatePackage + ".superclass";
        }
        for (String name : templates) {
            String nonInterfaceSuffix;
            String outputFileSuffix;
            if (name.startsWith("Enumeration")) {
                MithraTemplate servlet = this.newTemplate(templatePackage + "." + name);
                this.generateJavaFileFromTemplate(mithraObject, "", servlet, false, count);
                outputFileSuffix = "";
                nonInterfaceSuffix = "";
            } else {
                if (name.startsWith("DatabaseObject") && mithraObject.isPure()) {
                    name = name.replace("DatabaseObject", "ObjectFactory");
                }
                outputFileSuffix = name.substring(name.lastIndexOf(46) + 1, name.lastIndexOf(95));
                nonInterfaceSuffix = "";
                if (mithraObject.isGenerateInterfaces() && outputFileSuffix.endsWith("Abstract") && !outputFileSuffix.contains("Database")) {
                    nonInterfaceSuffix = "Impl";
                }
            }
            this.generateAbstractClass(mithraObject, count, templatePackage, outputFileSuffix, nonInterfaceSuffix);
            if (!outputFileSuffix.endsWith("Abstract")) continue;
            this.generateConcreteSubclass(mithraObject, count, templatePackage, outputFileSuffix, nonInterfaceSuffix);
        }
        if (mithraObject.isGenerateInterfaces()) {
            this.generateInterfaces(mithraObject, count, templatePackage);
        }
        if (mithraObject.getSubstituteSuperType() != null) {
            this.generateSuperType(mithraObject.getSubstituteSuperType(), count);
        }
    }

    private void generateSuperType(MithraSuperTypeWrapper superType, AtomicInteger count) {
        if (!superType.isWritten()) {
            superType.setWritten(true);
            this.generateFile(superType, count, TEMPLATE_PACKAGE_PREFIX, GENERATED_COMMON_TEMPLATE, "", true);
        }
    }

    private void generateAbstractClass(MithraBaseObjectTypeWrapper mithraObject, AtomicInteger count, String templatePackage, String templatePrefix, String nonInterfaceSuffix) {
        String outputFileSuffix = templatePrefix.contains("List") ? (mithraObject.isGenerateInterfaces() ? "ListImplAbstract" : templatePrefix) : nonInterfaceSuffix + templatePrefix;
        this.generateFile(mithraObject, count, templatePackage, templatePrefix, outputFileSuffix, true);
    }

    private void generateConcreteSubclass(MithraBaseObjectTypeWrapper mithraObject, AtomicInteger count, String templatePackage, String templatePrefix, String nonInterfaceSuffix) {
        String outputFileSuffix = (templatePrefix = templatePrefix.substring(0, templatePrefix.indexOf("Abstract"))).contains("List") ? templatePrefix + nonInterfaceSuffix : nonInterfaceSuffix + templatePrefix;
        this.generateFile(mithraObject, count, templatePackage, templatePrefix, outputFileSuffix, false);
    }

    private void generateFile(CommonWrapper mithraObject, AtomicInteger count, String templatePackage, String templatePrefix, String foo, boolean replaceIfExists) {
        MithraTemplate servlet = this.newTemplate(templatePackage + "." + (templatePrefix.equals("") ? "Main" : templatePrefix) + "_jsp");
        this.generateJavaFileFromTemplate(mithraObject, foo, servlet, replaceIfExists, count);
    }

    private void generateInterfaces(MithraBaseObjectTypeWrapper mithraObject, AtomicInteger count, String templatePackage) {
        MithraTemplate servlet = this.newTemplate(templatePackage + "." + "AbstractInterface_jsp");
        this.generateJavaFileFromTemplate(mithraObject, "Abstract", servlet, true, count);
        servlet = this.newTemplate(templatePackage + "." + "MainInterface_jsp");
        this.generateJavaFileFromTemplate(mithraObject, "", servlet, false, count);
        servlet = this.newTemplate(templatePackage + "." + "ListAbstractInterface_jsp");
        this.generateJavaFileFromTemplate(mithraObject, "ListAbstract", servlet, true, count);
        servlet = this.newTemplate(templatePackage + "." + "ListInterface_jsp");
        this.generateJavaFileFromTemplate(mithraObject, "List", servlet, false, count);
    }

    private MithraTemplate newTemplate(String name) {
        try {
            return (MithraTemplate)BaseMithraGenerator.class.getClassLoader().loadClass(name).newInstance();
        }
        catch (Exception e) {
            throw new MithraGeneratorException("unable to load template " + name + ", make sure you have compiled the templates", e);
        }
    }

    private byte[] prettyFormatCode(byte[] originalBytes) throws IOException {
        throw new RuntimeException("extreme pretty printing is no longer supported");
    }

    private byte[] fastFormatCode(byte[] originalBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(originalBytes);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(bais));
        SourceFormatter sourceFormatter = this.getSourceFormatter();
        sourceFormatter.init();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(originalBytes.length);
        PrintWriter writer = new PrintWriter(byteArrayOutputStream);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            sourceFormatter.formatLine(line, writer);
        }
        reader.close();
        writer.flush();
        byteArrayOutputStream.flush();
        writer.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] formatCode(byte[] originalBytes) throws IOException {
        if (this.format.equalsIgnoreCase(FORMAT_FAST)) {
            return this.fastFormatCode(originalBytes);
        }
        if (this.format.equalsIgnoreCase(FORMAT_PRETTY)) {
            return this.prettyFormatCode(originalBytes);
        }
        return originalBytes;
    }

    private void generateJavaFileFromTemplate(CommonWrapper wrapper, String outputFileSuffix, MithraTemplate servlet, boolean replaceIfExists, AtomicInteger count) {
        String packageName = wrapper.getPackageName().replace('.', '/');
        boolean shouldCreateFile = this.generatedFileManager.shouldCreateFile(replaceIfExists, packageName, wrapper.getClassName(), outputFileSuffix);
        if (!shouldCreateFile) {
            return;
        }
        this.generateJavaFile(wrapper, replaceIfExists, packageName, wrapper.getClassName(), outputFileSuffix, servlet, count);
    }

    private void generateJavaFile(final CommonWrapper wrapper, final boolean relaceIfExists, final String packageName, final String className, final String outputFileSuffix, final MithraTemplate servlet, final AtomicInteger count) {
        this.getExecutor().submit(new BaseMithraGenerator.GeneratorTask(0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrintWriter writer = null;
                try {
                    byte[] result;
                    CoreMithraGenerator.this.getChopAndStickResource().acquireCpuResource();
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = CoreMithraGenerator.this.getByteArrayOutputStream();
                        writer = new JspWriter(byteArrayOutputStream);
                        HttpServletRequest request = new HttpServletRequest();
                        request.setAttribute("mithraWrapper", wrapper);
                        request.setAttribute("generateGscListMethod", CoreMithraGenerator.this.generateGscListMethod);
                        request.setAttribute("generateLegacyCaramel", false);
                        HttpServletResponse response = new HttpServletResponse((JspWriter)writer);
                        servlet._jspService(request, response);
                        writer.close();
                        writer = null;
                        byte[] originalBytes = byteArrayOutputStream.toByteArray();
                        result = CoreMithraGenerator.this.formatCode(originalBytes);
                    }
                    finally {
                        CoreMithraGenerator.this.getChopAndStickResource().releaseCpuResource();
                    }
                    CoreMithraGenerator.this.getChopAndStickResource().acquireIoResource();
                    try {
                        CoreMithraGenerator.this.generatedFileManager.writeFile(relaceIfExists, packageName, className, outputFileSuffix + ".java", result, count);
                    }
                    finally {
                        CoreMithraGenerator.this.getChopAndStickResource().releaseIoResource();
                    }
                }
                catch (IOException e) {
                    throw new MithraGeneratorException("Error writing class " + wrapper.getPackageName() + "." + wrapper.getClassName() + outputFileSuffix + " " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
        });
    }

    public int processMithraInterfaces(Collection<? extends MithraInterfaceType> wrappers) {
        AtomicInteger count = new AtomicInteger();
        for (MithraInterfaceType mithraInterfaceType : wrappers) {
            if (mithraInterfaceType.isImported() && !this.isGenerateImported()) continue;
            try {
                this.applyMithraInterfaceTemplates(mithraInterfaceType, count);
            }
            catch (Exception e) {
                throw new MithraGeneratorException("Failed to generate classes for " + mithraInterfaceType.getClassName() + " with nested exception " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
        this.getExecutor().waitUntilDone();
        return count.get();
    }

    public int processMithraObjects(Collection<? extends MithraBaseObjectTypeWrapper> wrappers) {
        AtomicInteger count = new AtomicInteger();
        for (MithraBaseObjectTypeWrapper mithraBaseObjectTypeWrapper : wrappers) {
            this.processWrapper(mithraBaseObjectTypeWrapper, count);
        }
        this.getExecutor().waitUntilDone();
        return count.get();
    }

    private void processWrapper(MithraBaseObjectTypeWrapper wrapper, AtomicInteger count) {
        if (!wrapper.isImported() || this.isGenerateImported()) {
            try {
                this.applyTemplates(wrapper, count);
            }
            catch (Exception e) {
                throw new MithraGeneratorException("Failed to generate classes for " + wrapper.getClassName() + " with nested exception " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        this.setFileGenerationOptions();
        if (!this.executed) {
            try {
                long start = System.currentTimeMillis();
                this.logger.info("MithraGenerator MD5: " + this.getMd5());
                String filePath = this.parseAndValidate();
                GenerationLogger generationLogger = this.getGenerationLogger();
                generationLogger.setOldGenerationLog(GenerationLog.readOldLog(this.getGeneratedDir(), filePath, this.generatedFileManager));
                generationLogger.setNewGenerationLog(new GenerationLog(this.getMd5(), this.getCrc()));
                int normal = this.processMithraObjects(this.getSortedMithraObjects());
                int mithraInterfaces = this.processMithraInterfaces(this.getMithraInterfaces().values());
                int embedded = this.processMithraObjects(this.getMithraEmbeddedValueObjects().values());
                int enumerations = this.processMithraObjects(this.getMithraEnumerations().values());
                if (!generationLogger.getNewGenerationLog().isSame(generationLogger.getOldGenerationLog())) {
                    generationLogger.getNewGenerationLog().writeLog(this.getGeneratedDir(), this.generatedFileManager, filePath);
                }
                this.logger.info("Wrote " + normal + " normal/pure/temp, " + mithraInterfaces + " interface, " + embedded + " embedded value, " + enumerations + " enumeration Mithra objects (" + (System.currentTimeMillis() - start) + " ms)");
                this.executed = true;
                AwaitingThreadExecutor executor = this.getExecutor();
                if (executor == null) return;
                executor.shutdown();
                return;
            }
            catch (MithraGeneratorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MithraGeneratorException("Exception in mithra code generation " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
        } else {
            this.logger.info("skipped");
        }
    }

    public static void main(String[] args) {
        MithraXMLObjectTypeParser parser = new MithraXMLObjectTypeParser("H:/projects/Mithra/xml/mithra/test/MithraClassList.xml");
        parser.setLogger(new StdOutLogger());
        CoreMithraGenerator gen = new CoreMithraGenerator();
        gen.setMithraObjectTypeParser(parser);
        gen.setLogger(new StdOutLogger());
        gen.setGeneratedDir("H:/temp/Mithra/src");
        gen.setNonGeneratedDir("H:/temp/Mithra/src");
        gen.setGenerateGscListMethod(true);
        gen.execute();
    }

    static {
        TEMPLATE_PACKAGES.put("read-only", "com.gs.fw.common.mithra.templates.readonly");
        TEMPLATE_PACKAGES.put("datedread-only", "com.gs.fw.common.mithra.templates.datedreadonly");
        TEMPLATE_PACKAGES.put("transactional", "com.gs.fw.common.mithra.templates.transactional");
        TEMPLATE_PACKAGES.put("datedtransactional", "com.gs.fw.common.mithra.templates.datedtransactional");
        TEMPLATE_PACKAGES.put("embedded-value", "com.gs.fw.common.mithra.templates.embeddedvalue");
        TEMPLATE_PACKAGES.put("enumeration", "com.gs.fw.common.mithra.templates.enumeration");
        TEMPLATE_PACKAGES.put("mithra-interface", "com.gs.fw.common.mithra.templates.mithrainterface");
        TEMPLATE_LISTS.put("read-only", READ_ONLY_TEMPLATES);
        TEMPLATE_LISTS.put("datedread-only", DATED_READ_ONLY_TEMPLATES);
        TEMPLATE_LISTS.put("transactional", TRANSACTIONAL_TEMPLATES);
        TEMPLATE_LISTS.put("datedtransactional", DATED_TRANSACTIONAL_TEMPLATES);
        TEMPLATE_LISTS.put("embedded-value", EMBEDDED_VALUE_TEMPLATES);
        TEMPLATE_LISTS.put("enumeration", ENUMERATION_TEMPLATES);
        TEMPLATE_LISTS.put("mithra-interface", MITHRA_INTERFACE_TEMPLATES);
    }
}

