/*
 * Decompiled with CFR 0.152.
 */
package com.gs.fw.common.mithra.generator;

import com.gs.fw.common.mithra.generator.Attribute;
import com.gs.fw.common.mithra.generator.EnumerationAttributeMapping;
import com.gs.fw.common.mithra.generator.MithraObjectTypeWrapper;
import com.gs.fw.common.mithra.generator.metamodel.EnumerationAttributeType;
import com.gs.fw.common.mithra.generator.metamodel.EnumerationMappingType;
import com.gs.fw.common.mithra.generator.metamodel.SimulatedSequenceType;
import com.gs.fw.common.mithra.generator.metamodel.TimePrecisionType;
import com.gs.fw.common.mithra.generator.metamodel.TimezoneConversionType;
import com.gs.fw.common.mithra.generator.type.JavaType;
import java.util.ArrayList;
import java.util.List;

public class EnumerationAttribute
extends Attribute {
    private final EnumerationAttributeType wrapped;
    private final List<EnumerationAttributeMapping> attributeMappings = new ArrayList<EnumerationAttributeMapping>();

    public EnumerationAttribute(MithraObjectTypeWrapper owner, EnumerationAttributeType wrapped) {
        super(owner);
        this.wrapped = wrapped;
        this.type = JavaType.createEnumeration(this.getEnumerationType(), this.getUnderlyingType());
        this.setJavaType(this.getUnderlyingType());
        this.extractMemberMappings();
    }

    private EnumerationAttributeType getEnumerationAttributeType() {
        return this.wrapped;
    }

    public boolean isFinalGetter() {
        return this.getOwner().isDefaultFinalGetters();
    }

    public String getEnumerationType() {
        return this.getEnumerationAttributeType().getType();
    }

    public String getUnderlyingType() {
        return this.getEnumerationAttributeType().getPersistenceType();
    }

    public void setJavaType(String type) {
    }

    public boolean isPrimitive() {
        return false;
    }

    public String getName() {
        return this.getEnumerationAttributeType().getName();
    }

    protected void setName(String name) {
        this.getEnumerationAttributeType().setName(name);
    }

    public String getColumnName() {
        return this.getEnumerationAttributeType().getColumnName();
    }

    public void setColumnName(String columnName) {
        this.getEnumerationAttributeType().setColumnName(columnName);
    }

    public boolean isNullable() {
        return this.getEnumerationAttributeType().isNullable();
    }

    public String getDefaultIfNull() {
        return this.getEnumerationAttributeType().getDefaultIfNull();
    }

    public boolean isReadonly() {
        return this.getEnumerationAttributeType().isReadonly();
    }

    public boolean hasModifyTimePrecisionOnSet() {
        return this.getEnumerationAttributeType().isModifyTimePrecisionOnSetSet();
    }

    public TimePrecisionType getModifyTimePrecisionOnSet() {
        return this.getEnumerationAttributeType().getModifyTimePrecisionOnSet();
    }

    public boolean hasMaxLength() {
        return this.getEnumerationAttributeType().isMaxLengthSet();
    }

    public int getMaxLength() {
        return this.getEnumerationAttributeType().getMaxLength();
    }

    public boolean mustTrim() {
        return false;
    }

    public int getMaxLengthForComparison() {
        if (this.hasMaxLength()) {
            return this.getEnumerationAttributeType().getMaxLength();
        }
        return 255;
    }

    public boolean truncate() {
        return false;
    }

    public boolean modifyTimePrecisionOnSet() {
        return false;
    }

    public boolean trimString() {
        return false;
    }

    public boolean isPoolable() {
        return false;
    }

    public boolean isUsedForOptimisticLocking() {
        return false;
    }

    public boolean isPrimaryKey() {
        return false;
    }

    public boolean isMutablePrimaryKey() {
        return false;
    }

    public boolean isPrimaryKeyUsingSimulatedSequence() {
        return false;
    }

    public SimulatedSequenceType getSimulatedSequence() {
        throw new UnsupportedOperationException("An enumeration attribute may not serve as a primary key");
    }

    public boolean isSetPrimaryKeyGeneratorStrategy() {
        return false;
    }

    public String getPrimaryKeyGeneratorStrategy() {
        throw new UnsupportedOperationException("An enumeration attribute may not serve as a primary key");
    }

    public TimezoneConversionType getTimezoneConversion() {
        throw new UnsupportedOperationException("An enumeration attribute may not specify a TimezoneConversionType");
    }

    public EnumerationAttributeMapping[] getMembers() {
        EnumerationAttributeMapping[] attributeMappings = new EnumerationAttributeMapping[this.attributeMappings.size()];
        return this.attributeMappings.toArray(attributeMappings);
    }

    private void extractMemberMappings() {
        for (int i = 0; i < this.wrapped.getMappings().size(); ++i) {
            EnumerationMappingType member = this.wrapped.getMappings().get(i);
            this.attributeMappings.add(new EnumerationAttributeMapping(this, member));
        }
    }

    public boolean isMapped() {
        return false;
    }
}

